/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.forge;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import java.util.ArrayList;
import mapwriter.Mw;
import mapwriter.config.Config;
import mapwriter.overlay.OverlaySlime;
import mapwriter.util.Logging;
import mapwriter.util.Utils;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.reflect.FieldUtils;

public class EventHandler {
    Mw mw;

    public EventHandler(Mw mw) {
        this.mw = mw;
    }

    @SubscribeEvent
    public void eventChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            this.mw.onChunkLoad(event.getChunk());
        }
    }

    @SubscribeEvent
    public void eventChunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            this.mw.onChunkUnload(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatReceivedEvent event) {
        if (OverlaySlime.seedFound || !OverlaySlime.seedAsked) {
            return;
        }
        try {
            TextComponentString component;
            String msg;
            if (event.getMessage() instanceof TextComponentTranslation) {
                TextComponentTranslation component2 = (TextComponentTranslation)event.getMessage();
                if (component2.func_150268_i().equals("commands.seed.success")) {
                    Long lSeed = 0L;
                    lSeed = component2.func_150271_j()[0] instanceof Long ? (Long)component2.func_150271_j()[0] : Long.valueOf(Long.parseLong((String)component2.func_150271_j()[0]));
                    OverlaySlime.setSeed(lSeed);
                    event.setCanceled(true);
                }
            } else if (event.getMessage() instanceof TextComponentString && (msg = (component = (TextComponentString)event.getMessage()).func_150260_c()).startsWith("Seed: ")) {
                OverlaySlime.setSeed(Long.parseLong(msg.substring(6)));
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            Logging.logError("Something went wrong getting the seed. %s", e.toString());
        }
    }

    @SubscribeEvent
    public void renderMap(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Mw.getInstance().onTick();
        }
    }

    @SubscribeEvent
    public void onTextureStitchEventPost(TextureStitchEvent.Post event) {
        if (Config.reloadColours) {
            Logging.logInfo("Skipping the first generation of blockcolours, models are not loaded yet", null);
        } else {
            this.mw.reloadBlockColours();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (Mw.getInstance().ready) {
            Mw.getInstance().markerManager.drawMarkersWorld(event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && Config.reloadColours) {
            this.mw.reloadBlockColours();
            Config.reloadColours = false;
        } else if (event.getGui() instanceof GuiGameOver) {
            this.mw.onPlayerDeath();
        } else if (event.getGui() instanceof GuiScreenRealmsProxy) {
            try {
                RealmsScreen proxy = ((GuiScreenRealmsProxy)event.getGui()).func_154321_a();
                RealmsMainScreen parrent = null;
                if (proxy instanceof RealmsLongRunningMcoTaskScreen || proxy instanceof RealmsConfigureWorldScreen) {
                    long id;
                    Object obj = FieldUtils.readField((Object)proxy, (String)"lastScreen", (boolean)true);
                    if (obj instanceof RealmsMainScreen) {
                        parrent = (RealmsMainScreen)obj;
                    }
                    if (parrent != null && (id = ((Long)FieldUtils.readField((Object)parrent, (String)"selectedServerId", (boolean)true)).longValue()) > 0L) {
                        ArrayList list = (ArrayList)FieldUtils.readField((Object)parrent, (String)"realmsServers", (boolean)true);
                        for (Object item : list) {
                            RealmsServer server = (RealmsServer)item;
                            String Name = server.getName();
                            String Owner = server.owner;
                            StringBuilder builder = new StringBuilder();
                            builder.append(server.owner);
                            builder.append("_");
                            builder.append(server.getName());
                            Utils.RealmsWorldName = builder.toString();
                        }
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

