/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import mapwriter.region.BlockColours;
import mapwriter.util.Logging;
import mapwriter.util.Render;
import mapwriter.util.Texture;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.Biome;

public class BlockColourGen {
    public static void genBlockColours(BlockColours bc) {
        Logging.log("generating block map colours from textures", new Object[0]);
        int terrainTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
        if (terrainTextureId == 0) {
            Logging.log("error: could get terrain texture ID", new Object[0]);
            return;
        }
        Texture terrainTexture = new Texture(terrainTextureId);
        double u1Last = 0.0;
        double u2Last = 0.0;
        double v1Last = 0.0;
        double v2Last = 0.0;
        int blockColourLast = 0;
        int e_count = 0;
        int b_count = 0;
        int s_count = 0;
        for (Object oblock : Block.field_149771_c) {
            Block block = (Block)oblock;
            int blockID = Block.func_149682_b((Block)block);
            for (int dv = 0; dv < 16; ++dv) {
                int blockColour = 0;
                if (block != null && block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.INVISIBLE) {
                    TextureAtlasSprite icon = null;
                    try {
                        icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176203_a(dv));
                    }
                    catch (Exception e) {
                        ++e_count;
                    }
                    if (icon != null) {
                        double u1 = icon.func_94209_e();
                        double u2 = icon.func_94212_f();
                        double v1 = icon.func_94206_g();
                        double v2 = icon.func_94210_h();
                        if (u1 == u1Last && u2 == u2Last && v1 == v1Last && v2 == v2Last) {
                            blockColour = blockColourLast;
                            ++s_count;
                        } else {
                            blockColour = BlockColourGen.getIconMapColour(icon, terrainTexture);
                            if (((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b().contains("CarpentersBlocks")) {
                                // empty if block
                            }
                            u1Last = u1;
                            u2Last = u2;
                            v1Last = v1;
                            v2Last = v2;
                            blockColourLast = blockColour;
                            ++b_count;
                        }
                    }
                }
                bc.setColour(block.delegate.name().toString(), String.valueOf(dv), blockColour);
            }
        }
        Logging.log("processed %d block textures, %d skipped, %d exceptions", b_count, s_count, e_count);
        BlockColourGen.genBiomeColours(bc);
    }

    private static void genBiomeColours(BlockColours bc) {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            double temp = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
            double rain = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
            int grasscolor = ColorizerGrass.func_77480_a((double)temp, (double)rain);
            int foliagecolor = ColorizerFoliage.func_77470_a((double)temp, (double)rain);
            int watercolor = biome.getWaterColorMultiplier();
            bc.setBiomeData(biome.func_185359_l(), watercolor & 0xFFFFFF, grasscolor & 0xFFFFFF, foliagecolor & 0xFFFFFF);
        }
    }

    private static int getIconMapColour(TextureAtlasSprite icon, Texture terrainTexture) {
        int iconX = Math.round((float)terrainTexture.w * Math.min(icon.func_94209_e(), icon.func_94212_f()));
        int iconY = Math.round((float)terrainTexture.h * Math.min(icon.func_94206_g(), icon.func_94210_h()));
        int iconWidth = Math.round((float)terrainTexture.w * Math.abs(icon.func_94212_f() - icon.func_94209_e()));
        int iconHeight = Math.round((float)terrainTexture.h * Math.abs(icon.func_94210_h() - icon.func_94206_g()));
        int[] pixels = new int[iconWidth * iconHeight];
        terrainTexture.getRGB(iconX, iconY, iconWidth, iconHeight, pixels, 0, iconWidth, icon);
        return Render.getAverageColourOfArray(pixels);
    }
}

