/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.ArrayList;
import java.util.List;
import mapwriter.config.ConfigurationHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModGuiConfig
extends GuiConfig {
    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("options", "mw.configgui.ctgy.general", new ConfigElement(ConfigurationHandler.configuration.getCategory("options")).getChildElements()));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("fullscreenmap", "mw.configgui.ctgy.fullScreenMap", new ConfigElement(ConfigurationHandler.configuration.getCategory("fullscreenmap")).getChildElements(), MapModeConfigEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("largemap", "mw.configgui.ctgy.largeMap", new ConfigElement(ConfigurationHandler.configuration.getCategory("largemap")).getChildElements(), MapModeConfigEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("smallmap", "mw.configgui.ctgy.smallMap", new ConfigElement(ConfigurationHandler.configuration.getCategory("smallmap")).getChildElements(), MapModeConfigEntry.class));
        return list;
    }

    public ModGuiConfig(GuiScreen guiScreen) {
        super(guiScreen, ModGuiConfig.getConfigElements(), "mapwriter", "options", false, false, GuiConfig.getAbridgedConfigPath((String)ConfigurationHandler.configuration.toString()));
    }

    public static class ModNumberSliderEntry
    extends GuiConfigEntries.NumberSliderEntry {
        private boolean enabled = true;

        public ModNumberSliderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            ((GuiSlider)this.btnValue).precision = 2;
            this.updateValueButtonText();
        }

        public boolean enabled() {
            return this.owningScreen.isWorldRunning ? !this.owningScreen.allRequireWorldRestart && !this.configElement.requiresWorldRestart() && this.enabled : this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setValue(double val) {
            ((GuiSlider)this.btnValue).setValue(val);
            ((GuiSlider)this.btnValue).updateSlider();
        }
    }

    public static class ModBooleanEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        public ModBooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        public boolean enabled() {
            for (GuiConfigEntries.IConfigEntry entry : this.owningEntryList.listEntries) {
                if (!entry.getName().equals("circular") || !(entry instanceof GuiConfigEntries.BooleanEntry)) continue;
                return Boolean.valueOf(entry.getCurrentValue().toString());
            }
            return true;
        }

        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }

        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
        }

        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }
    }

    public static class MapModeConfigEntry
    extends GuiConfigEntries.CategoryEntry {
        public MapModeConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            String QualifiedName = this.configElement.getQualifiedName();
            return new GuiConfig((GuiScreen)this.owningScreen, this.getConfigElement().getChildElements(), this.owningScreen.modID, QualifiedName, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title);
        }
    }
}

