/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import mapwriter.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class MwGuiLabel {
    static int spacingX = 4;
    static int spacingY = 2;
    int x = 0;
    int y = 0;
    int w = 1;
    int h = 12;
    private FontRenderer fontRendererObj;
    private Boolean Background;
    private Boolean AllowFlip;
    private int parentWidth;
    private int parentHeight;
    private String str1;
    private String str2;
    private String[] s1;
    private String[] s2;
    private MwGuiLabel label;
    private Side side;

    public MwGuiLabel(String[] s1, String[] s2, int x, int y, Boolean Background, Boolean AllowFlip, int parentWidth, int parentHeight) {
        this.fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.side = Side.none;
        this.Background = Background;
        this.AllowFlip = AllowFlip;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.setCoords(x, y);
        this.setText(s1, s2);
    }

    public void draw() {
        this.updateCoords();
        if (this.str1 != null) {
            if (this.Background.booleanValue()) {
                Gui.func_73734_a((int)(this.x - spacingX), (int)(this.y - spacingY), (int)(this.x + this.w + spacingX), (int)(this.h + this.y + spacingY), (int)Integer.MIN_VALUE);
            }
            this.fontRendererObj.func_78279_b(this.str1, this.x, this.y, this.w, 0xFFFFFF);
            if (this.str2 != null) {
                this.fontRendererObj.func_78279_b(this.str2, this.x + 65, this.y, this.w, 0xFFFFFF);
            }
        }
    }

    public void drawToAboveOf(MwGuiLabel label) {
        this.label = label;
        this.side = Side.top;
    }

    public void drawToBelowOf(MwGuiLabel label) {
        this.label = label;
        this.side = Side.bottom;
    }

    public void drawToLeftOf(MwGuiLabel label) {
        this.label = label;
        this.side = Side.left;
    }

    public void drawToRightOf(MwGuiLabel label) {
        this.label = label;
        this.side = Side.right;
    }

    public boolean getAllowFlip() {
        return this.Background;
    }

    public boolean getDrawBackground() {
        return this.Background;
    }

    public int getparentHeight() {
        return this.parentHeight;
    }

    public int getparentWidth() {
        return this.parentWidth;
    }

    public boolean posWithin(int x, int y) {
        return x >= this.x + spacingX && y >= this.y + spacingY && x <= this.x + this.w + spacingX && y <= this.y + this.h + spacingY;
    }

    public void setAllowFlip(boolean enable) {
        this.Background = enable;
    }

    public void setCoords(int x, int y) {
        if (this.AllowFlip.booleanValue()) {
            this.x = x + this.w + spacingX > this.parentWidth ? x - this.w - spacingX - 5 : x;
            this.y = y + this.h + spacingY > this.parentHeight ? y - this.h - spacingY : y;
        } else {
            this.x = x;
            this.y = y;
        }
    }

    public void setDrawBackground(boolean enable) {
        this.Background = enable;
    }

    public void setParentWidthAndHeight(int width, int height) {
        this.parentWidth = width;
        this.parentHeight = height;
        this.updateWidthAndHeight();
    }

    public void setText(String[] s1, String[] s2) {
        this.s1 = s1;
        this.s2 = s2;
        this.UpdateStrings();
    }

    private void updateCoords() {
        switch (this.side) {
            case left: {
                this.setCoords(this.label.x - (this.w + 2 * spacingX + 2), this.label.y);
                break;
            }
            case right: {
                this.setCoords(this.label.x + this.label.w + 2 * spacingX + 2, this.label.y);
                break;
            }
            case bottom: {
                this.setCoords(this.label.x, this.label.y + this.label.h + 2 * spacingY + 2);
                break;
            }
            case top: {
                this.setCoords(this.label.x, this.label.y - (this.h + 2 * spacingY + 2));
                break;
            }
        }
    }

    private void UpdateStrings() {
        if (this.s1 != null && this.s1.length > 0) {
            this.str1 = Utils.stringArrayToString(this.s1);
        }
        if (this.s2 != null && this.s2.length > 0) {
            this.str2 = Utils.stringArrayToString(this.s2);
        }
        this.updateWidthAndHeight();
    }

    private void updateWidthAndHeight() {
        if (this.s1 != null) {
            int stringwidth = Utils.getMaxWidth(this.s1, this.s2);
            this.w = stringwidth < this.parentWidth - 20 ? stringwidth : this.parentWidth - 20;
            this.h = this.fontRendererObj.func_78267_b(this.str1, this.parentWidth > 0 ? this.parentWidth : 10);
        }
    }

    private static enum Side {
        left,
        right,
        top,
        bottom,
        none;

    }
}

