/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import mapwriter.gui.ScrollableField;
import mapwriter.gui.ScrollableNumericTextBox;
import mapwriter.util.Utils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;

public class ScrollableColorSelector
extends ScrollableField {
    private String editRed = "mw.gui.ScrollableColorSelector.Red";
    private String editGreen = "mw.gui.ScrollableColorSelector.Green";
    private String editBlue = "mw.gui.ScrollableColorSelector.Blue";
    private ScrollableNumericTextBox ScrollableNumericTextBoxColourRed;
    private ScrollableNumericTextBox ScrollableNumericTextBoxColourGreen;
    private ScrollableNumericTextBox ScrollableNumericTextBoxColourBlue;
    private int colour = 0;
    private int colourFieldX = 0;
    private int colourFieldY = 0;
    private int colourFieldW = 0;
    private int colourFieldH = 0;
    private int y;

    public ScrollableColorSelector(int x, int y, int width, String label, FontRenderer fontrendererObj) {
        super(x, y + 20, width, label, fontrendererObj);
        this.y = y;
        this.init();
    }

    public void colourFieldScroll(int direction) {
        if (direction > 0) {
            this.nextElement();
        } else if (direction < 0) {
            this.previousElement();
        }
    }

    @Override
    public void draw() {
        super.draw();
        this.ScrollableNumericTextBoxColourRed.draw();
        this.ScrollableNumericTextBoxColourGreen.draw();
        this.ScrollableNumericTextBoxColourBlue.draw();
        this.UpdateColour();
        Gui.func_73734_a((int)(this.colourFieldX - 1), (int)(this.colourFieldY - 1), (int)(this.colourFieldX + this.colourFieldW + 1), (int)(this.colourFieldY + this.colourFieldH + 1), (int)-16777216);
        Gui.func_73734_a((int)this.colourFieldX, (int)this.colourFieldY, (int)(this.colourFieldX + this.colourFieldW), (int)(this.colourFieldY + this.colourFieldH), (int)this.colour);
    }

    public int getColor() {
        return this.colour;
    }

    @Override
    public Boolean isFocused() {
        if (this.ScrollableNumericTextBoxColourRed.isFocused().booleanValue() || this.ScrollableNumericTextBoxColourGreen.isFocused().booleanValue() || this.ScrollableNumericTextBoxColourBlue.isFocused().booleanValue()) {
            return true;
        }
        return false;
    }

    public void KeyTyped(char c, int key) {
        this.ScrollableNumericTextBoxColourRed.KeyTyped(c, key);
        this.ScrollableNumericTextBoxColourGreen.KeyTyped(c, key);
        this.ScrollableNumericTextBoxColourBlue.KeyTyped(c, key);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.ScrollableNumericTextBoxColourRed.mouseClicked(x, y, button);
        this.ScrollableNumericTextBoxColourGreen.mouseClicked(x, y, button);
        this.ScrollableNumericTextBoxColourBlue.mouseClicked(x, y, button);
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        this.ScrollableNumericTextBoxColourRed.mouseDWheelScrolled(x, y, direction);
        this.ScrollableNumericTextBoxColourGreen.mouseDWheelScrolled(x, y, direction);
        this.ScrollableNumericTextBoxColourBlue.mouseDWheelScrolled(x, y, direction);
        if (this.posWithinColourField(x, y)) {
            this.colourFieldScroll(-direction);
        }
    }

    @Override
    public void nextElement() {
        this.setColor(Utils.getNextColour());
    }

    public ScrollableField nextField(ScrollableField field) {
        if (this.ScrollableNumericTextBoxColourRed.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourGreen;
        }
        if (this.ScrollableNumericTextBoxColourGreen.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourBlue;
        }
        return field;
    }

    public boolean posWithinColourField(int x, int y) {
        return x >= this.colourFieldX && y >= this.colourFieldY && x <= this.colourFieldW + this.colourFieldX && y <= this.colourFieldH + this.colourFieldY;
    }

    public ScrollableField prevField(ScrollableField field) {
        if (this.ScrollableNumericTextBoxColourGreen.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourRed;
        }
        if (this.ScrollableNumericTextBoxColourBlue.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourGreen;
        }
        return field;
    }

    @Override
    public void previousElement() {
        this.setColor(Utils.getPrevColour());
    }

    public void setColor(int colour) {
        this.colour = colour;
        int red = colour >> 16 & 0xFF;
        int green = colour >> 8 & 0xFF;
        int blue = colour & 0xFF;
        this.ScrollableNumericTextBoxColourRed.setText(red);
        this.ScrollableNumericTextBoxColourGreen.setText(green);
        this.ScrollableNumericTextBoxColourBlue.setText(blue);
    }

    @Override
    public void setFocused(Boolean focus) {
        this.ScrollableNumericTextBoxColourRed.setFocused(focus);
    }

    public ScrollableField thisField() {
        if (this.ScrollableNumericTextBoxColourRed.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourRed;
        }
        if (this.ScrollableNumericTextBoxColourGreen.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourGreen;
        }
        if (this.ScrollableNumericTextBoxColourBlue.isFocused().booleanValue()) {
            return this.ScrollableNumericTextBoxColourBlue;
        }
        return this.ScrollableNumericTextBoxColourRed;
    }

    public boolean validateColorData() {
        return this.ScrollableNumericTextBoxColourRed.getText().length() > 0 && this.ScrollableNumericTextBoxColourGreen.getText().length() > 0 && this.ScrollableNumericTextBoxColourBlue.getText().length() > 0;
    }

    private void init() {
        int textboxWidth = 16;
        int x1 = this.x + ScrollableField.arrowsWidth + this.fontrendererObj.func_78256_a(I18n.func_135052_a((String)this.editGreen, (Object[])new Object[0])) + 4;
        int w = ScrollableField.arrowsWidth * 2 + this.fontrendererObj.func_78256_a("999") + textboxWidth;
        this.ScrollableNumericTextBoxColourRed = new ScrollableNumericTextBox(x1, this.y, w, I18n.func_135052_a((String)this.editRed, (Object[])new Object[0]), this.fontrendererObj);
        this.ScrollableNumericTextBoxColourRed.setDrawArrows(true);
        this.ScrollableNumericTextBoxColourRed.setMaxValue(255);
        this.ScrollableNumericTextBoxColourRed.setMinValue(0);
        this.ScrollableNumericTextBoxColourGreen = new ScrollableNumericTextBox(x1, this.y + 20, w, I18n.func_135052_a((String)this.editGreen, (Object[])new Object[0]), this.fontrendererObj);
        this.ScrollableNumericTextBoxColourGreen.setDrawArrows(true);
        this.ScrollableNumericTextBoxColourGreen.setMaxValue(255);
        this.ScrollableNumericTextBoxColourGreen.setMinValue(0);
        this.ScrollableNumericTextBoxColourBlue = new ScrollableNumericTextBox(x1, this.y + 40, w, I18n.func_135052_a((String)this.editBlue, (Object[])new Object[0]), this.fontrendererObj);
        this.ScrollableNumericTextBoxColourBlue.setDrawArrows(true);
        this.ScrollableNumericTextBoxColourBlue.setMaxValue(255);
        this.ScrollableNumericTextBoxColourBlue.setMinValue(0);
        this.colourFieldX = x1 + w + 2;
        this.colourFieldY = this.y + 6;
        this.colourFieldW = this.width - w - ScrollableField.arrowsWidth * 2 - this.fontrendererObj.func_78256_a(I18n.func_135052_a((String)this.editGreen, (Object[])new Object[0])) - 8;
        this.colourFieldH = 40;
    }

    private void UpdateColour() {
        int colour = -16777216;
        colour += this.ScrollableNumericTextBoxColourRed.getTextFieldIntValue() << 16;
        colour += this.ScrollableNumericTextBoxColourGreen.getTextFieldIntValue() << 8;
        this.colour = colour += this.ScrollableNumericTextBoxColourBlue.getTextFieldIntValue();
    }
}

