/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.tasks;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import mapwriter.region.MwChunk;
import mapwriter.region.RegionManager;
import mapwriter.tasks.Task;

public class SaveChunkTask
extends Task {
    private static HashMap<Long, SaveChunkTask> chunksUpdating = new HashMap();
    private MwChunk chunk;
    private RegionManager regionManager;
    private AtomicBoolean Running = new AtomicBoolean();

    public SaveChunkTask(MwChunk chunk, RegionManager regionManager) {
        this.chunk = chunk;
        this.regionManager = regionManager;
    }

    @Override
    public boolean CheckForDuplicate() {
        Long coords = this.chunk.getCoordIntPair();
        if (!chunksUpdating.containsKey(coords)) {
            chunksUpdating.put(coords, this);
            return false;
        }
        SaveChunkTask task2 = chunksUpdating.get(coords);
        if (task2.Running.get()) {
            chunksUpdating.put(coords, this);
            return false;
        }
        task2.UpdateChunkData(this.chunk, this.regionManager);
        return true;
    }

    @Override
    public void onComplete() {
        Long coords = this.chunk.getCoordIntPair();
        chunksUpdating.remove(coords);
        this.Running.set(false);
    }

    @Override
    public void run() {
        this.Running.set(true);
        this.chunk.write(this.regionManager.regionFileCache);
    }

    public void UpdateChunkData(MwChunk chunk, RegionManager regionManager) {
        this.chunk = chunk;
        this.regionManager = regionManager;
    }
}

