/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.config;

import mapwriter.config.ConfigurationHandler;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;

public class MapModeConfig {
    public final String configCategory;
    public static final String[] coordsModeStringArray = new String[]{"mw.config.map.coordsMode.disabled", "mw.config.map.coordsMode.small", "mw.config.map.coordsMode.large"};
    public static final String[] miniMapPositionStringArray = new String[]{"mw.config.map.position.topRight", "mw.config.map.position.topLeft", "mw.config.map.position.botRight", "mw.config.map.position.botLeft"};
    public boolean enabledDef;
    public boolean enabled;
    public boolean rotateDef;
    public boolean rotate;
    public boolean circularDef;
    public boolean circular;
    public String coordsModeDef;
    public String coordsMode;
    public boolean borderModeDef;
    public boolean borderMode;
    public int playerArrowSizeDef;
    public int playerArrowSize;
    public int markerSizeDef;
    public int markerSize;
    public int trailMarkerSizeDef;
    public int trailMarkerSize;
    public int alphaPercentDef;
    public int alphaPercent;
    public int heightPercentDef;
    public int heightPercent;
    public String PositionDef;
    public String Position;
    public String biomeModeDef;
    public String biomeMode;

    public MapModeConfig(String configCategory) {
        this.enabled = this.enabledDef = true;
        this.rotate = this.rotateDef = false;
        this.circular = this.circularDef = false;
        this.coordsMode = this.coordsModeDef = coordsModeStringArray[0];
        this.borderMode = this.borderModeDef = false;
        this.playerArrowSize = this.playerArrowSizeDef = 5;
        this.markerSize = this.markerSizeDef = 5;
        this.trailMarkerSize = this.trailMarkerSizeDef = 3;
        this.alphaPercent = this.alphaPercentDef = 100;
        this.heightPercent = this.heightPercentDef = -1;
        this.Position = this.PositionDef = "FullScreen";
        this.biomeMode = this.biomeModeDef = coordsModeStringArray[0];
        this.configCategory = configCategory;
    }

    public void loadConfig() {
        this.playerArrowSize = ConfigurationHandler.configuration.getInt("playerArrowSize", this.configCategory, this.playerArrowSizeDef, 1, 20, "", "mw.config.map.playerArrowSize");
        this.markerSize = ConfigurationHandler.configuration.getInt("markerSize", this.configCategory, this.markerSizeDef, 1, 20, "", "mw.config.map.markerSize");
        this.alphaPercent = ConfigurationHandler.configuration.getInt("alphaPercent", this.configCategory, this.alphaPercentDef, 0, 100, "", "mw.config.map.alphaPercent");
        this.trailMarkerSize = Math.max(1, this.markerSize - 1);
    }

    public void setDefaults() {
    }

    public IConfigElement categoryElement(String name, String tooltip_key) {
        return new DummyConfigElement.DummyCategoryElement(name, tooltip_key, new ConfigElement(ConfigurationHandler.configuration.getCategory(this.configCategory)).getChildElements());
    }
}

