/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mapwriter.region.IChunk;
import mapwriter.region.RegionFile;
import mapwriter.region.RegionFileCache;
import mapwriter.util.Logging;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class MwChunk
implements IChunk {
    public static final int SIZE = 16;
    public final int x;
    public final int z;
    public final int dimension;
    char[][] dataArray = new char[16][];
    public final byte[][] lightingArray;
    public final Map<BlockPos, TileEntity> tileentityMap;
    public final byte[] biomeArray;
    public final int maxY;
    private static Method CarpenterMethod = null;
    private static Method FMPMethodParts = null;
    private static Method FMPMethodMaterial = null;
    private static Field FMPFieldBlock = null;
    private static Field FMPFieldMeta = null;

    public MwChunk(int x, int z, int dimension, char[][] data, byte[][] lightingArray, byte[] biomeArray, Map<BlockPos, TileEntity> TileEntityMap) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
        this.biomeArray = biomeArray;
        this.lightingArray = lightingArray;
        this.tileentityMap = TileEntityMap;
        this.dataArray = data;
        int maxY = 0;
        for (int y = 0; y < 16; ++y) {
            if (data[y] == null) continue;
            maxY = (y << 4) + 15;
        }
        this.maxY = maxY;
    }

    public String toString() {
        return String.format("(%d, %d) dim%d", this.x, this.z, this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MwChunk read(int x, int z, int dimension, RegionFileCache regionFileCache) {
        byte[] biomeArray = null;
        byte[][] lsbArray = new byte[16][];
        char[][] data = new char[16][];
        byte[][] lightingArray = new byte[16][];
        HashMap<BlockPos, TileEntity> TileEntityMap = new HashMap<BlockPos, TileEntity>();
        FilterInputStream dis = null;
        RegionFile regionFile = regionFileCache.getRegionFile(x << 4, z << 4, dimension);
        if (!regionFile.isOpen() && regionFile.exists()) {
            regionFile.open();
        }
        if (regionFile.isOpen()) {
            dis = regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F);
        }
        if (dis == null) return new MwChunk(x, z, dimension, data, lightingArray, biomeArray, TileEntityMap);
        try {
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74794_a(dis);
            NBTTagCompound level = nbttagcompound.func_74775_l("Level");
            int xNbt = level.func_74762_e("xPos");
            int zNbt = level.func_74762_e("zPos");
            if (xNbt != x || zNbt != z) {
                Logging.logWarning("chunk (%d, %d) has NBT coords (%d, %d)", x, z, xNbt, zNbt);
            }
            NBTTagList sections = level.func_150295_c("Sections", 10);
            int k = 0;
            while (true) {
                NibbleArray nibblearray1;
                NibbleArray nibblearray;
                byte y;
                if (k < sections.func_74745_c()) {
                    NBTTagCompound section = sections.func_150305_b(k);
                    y = section.func_74771_c("Y");
                    lsbArray[y & 0xF] = section.func_74770_j("Blocks");
                    nibblearray = new NibbleArray(section.func_74770_j("Data"));
                    nibblearray1 = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : null;
                    data[y & 0xF] = new char[lsbArray[y].length];
                } else {
                    biomeArray = level.func_74770_j("Biomes");
                    NBTTagList nbttaglist2 = level.func_150295_c("TileEntities", 10);
                    if (nbttaglist2 != null) {
                        for (int i1 = 0; i1 < nbttaglist2.func_74745_c(); ++i1) {
                            NBTTagCompound nbttagcompound4 = nbttaglist2.func_150305_b(i1);
                            TileEntity tileentity = TileEntity.func_145827_c((NBTTagCompound)nbttagcompound4);
                            if (tileentity == null) continue;
                            TileEntityMap.put(tileentity.func_174877_v(), tileentity);
                        }
                    }
                    try {
                        dis.close();
                        return new MwChunk(x, z, dimension, data, lightingArray, biomeArray, TileEntityMap);
                    }
                    catch (IOException e) {
                        Logging.logError("MwChunk.read: %s while closing input stream", e);
                        return new MwChunk(x, z, dimension, data, lightingArray, biomeArray, TileEntityMap);
                    }
                }
                for (int l = 0; l < data[y & 0xF].length; ++l) {
                    int i1 = l & 0xF;
                    int j1 = l >> 8 & 0xF;
                    int k1 = l >> 4 & 0xF;
                    int l1 = nibblearray1 != null ? nibblearray1.func_76582_a(i1, j1, k1) : 0;
                    data[y & 0xF][l] = (char)(l1 << 12 | (lsbArray[y][l] & 0xFF) << 4 | nibblearray.func_76582_a(i1, j1, k1));
                }
                ++k;
            }
        }
        catch (IOException e) {
            try {
                Logging.logError("%s: could not read chunk (%d, %d) from region file\n", e, x, z);
            }
            catch (Throwable throwable) {
                try {
                    dis.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Logging.logError("MwChunk.read: %s while closing input stream", e2);
                }
                throw throwable;
            }
            try {
                dis.close();
                return new MwChunk(x, z, dimension, data, lightingArray, biomeArray, TileEntityMap);
            }
            catch (IOException e3) {
                Logging.logError("MwChunk.read: %s while closing input stream", e3);
                return new MwChunk(x, z, dimension, data, lightingArray, biomeArray, TileEntityMap);
            }
        }
    }

    public boolean isEmpty() {
        return this.maxY <= 0;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeArray != null ? this.biomeArray[(z & 0xF) << 4 | x & 0xF] & 0xFF : 0;
    }

    @Override
    public int getLightValue(int x, int y, int z) {
        return 15;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    public static void carpenterdata() {
        try {
            Class<?> act = Class.forName("com.carpentersblocks.tileentity.TEBase");
            CarpenterMethod = act.getMethod("getAttribute", Byte.TYPE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void FMPdata() {
        try {
            Class<?> act = Class.forName("codechicken.multipart.TileMultipart");
            FMPMethodParts = act.getMethod("jPartList", new Class[0]);
            act = Class.forName("codechicken.microblock.Microblock");
            FMPMethodMaterial = act.getMethod("getIMaterial", new Class[0]);
            act = Class.forName("codechicken.microblock.BlockMicroMaterial");
            FMPFieldBlock = act.getDeclaredField("block");
            FMPFieldBlock.setAccessible(true);
            FMPFieldMeta = act.getDeclaredField("meta");
            FMPFieldMeta.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    public int getBlockAndMetadata(int x, int y, int z) {
        int data;
        int yi = y >> 4 & 0xF;
        int offset = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        int lsb = 0;
        int msb = 0;
        int meta = 0;
        BlockPos pos = new BlockPos(x, y, z);
        int n = data = this.dataArray != null && this.dataArray[yi] != null && this.dataArray[yi].length != 0 ? this.dataArray[yi][offset] : 0;
        if (this.tileentityMap.containsKey(pos)) {
            TileEntity value = this.tileentityMap.get(pos);
            int id = 0;
            if (CarpenterMethod != null) {
                try {
                    ItemStack itemStack = (ItemStack)CarpenterMethod.invoke((Object)value, (byte)6);
                    if (itemStack != null) {
                        ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
                        id = Block.func_149682_b((Block)itemBlock.field_150939_a);
                        meta = itemStack.func_77960_j();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (FMPMethodParts != null) {
                try {
                    for (Object temp : (List)FMPMethodParts.invoke((Object)value, new Object[0])) {
                        Object material = FMPMethodMaterial.invoke(temp, new Object[0]);
                        Block block = (Block)FMPFieldBlock.get(material);
                        id = Block.func_149682_b((Block)block);
                        meta = (Integer)FMPFieldMeta.get(material);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (id != 0) {
                lsb = id & 0xFF;
                msb = id > 255 ? (id & 0xF00) >> 8 : 0;
                data = (char)((msb & 0xF) << 12 | (lsb & 0xFF) << 4 | meta & 0xF);
            }
        }
        return data;
    }

    private NBTTagCompound writeChunkToNBT() {
        NBTTagCompound nbttagcompound2;
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound.func_74782_a("Level", (NBTBase)nbttagcompound1);
        nbttagcompound1.func_74768_a("xPos", this.x);
        nbttagcompound1.func_74768_a("zPos", this.z);
        NBTTagList nbttaglist = new NBTTagList();
        for (int y = 0; y < this.dataArray.length; ++y) {
            if (this.dataArray[y] != null) {
                byte[] abyte = new byte[this.dataArray[y].length];
                NibbleArray nibblearray = new NibbleArray();
                NibbleArray nibblearray1 = null;
                for (int k = 0; k < this.dataArray[y].length; ++k) {
                    char c0 = this.dataArray[y][k];
                    int l = k & 0xF;
                    int i1 = k >> 8 & 0xF;
                    int j1 = k >> 4 & 0xF;
                    if (c0 >> 12 != 0) {
                        if (nibblearray1 == null) {
                            nibblearray1 = new NibbleArray();
                        }
                        nibblearray1.func_76581_a(l, i1, j1, c0 >> 12);
                    }
                    abyte[k] = (byte)(c0 >> 4 & 0xFF);
                    nibblearray.func_76581_a(l, i1, j1, c0 & 0xF);
                }
                nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Y", (byte)y);
                nbttagcompound2.func_74773_a("Blocks", abyte);
                if (nibblearray1 != null) {
                    nbttagcompound2.func_74773_a("Add", nibblearray1.func_177481_a());
                }
                nbttagcompound2.func_74773_a("Data", nibblearray.func_177481_a());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound1.func_74782_a("Sections", (NBTBase)nbttaglist);
        }
        nbttagcompound1.func_74773_a("Biomes", this.biomeArray);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (TileEntity tileentity : this.tileentityMap.values()) {
            nbttagcompound2 = new NBTTagCompound();
            try {
                nbttaglist3.func_74742_a((NBTBase)nbttagcompound2);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"A TileEntity type %s has throw an exception trying to write state. It will not persist. Report this to the mod author", (Object[])new Object[]{tileentity.getClass().getName()});
            }
        }
        nbttagcompound1.func_74782_a("TileEntities", (NBTBase)nbttaglist3);
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean write(RegionFileCache regionFileCache) {
        boolean error;
        block11: {
            block12: {
                block13: {
                    error = false;
                    RegionFile regionFile = regionFileCache.getRegionFile(this.x << 4, this.z << 4, this.dimension);
                    if (!regionFile.isOpen()) {
                        error = regionFile.open();
                    }
                    if (error) break block12;
                    DataOutputStream dos = regionFile.getChunkDataOutputStream(this.x & 0x1F, this.z & 0x1F);
                    if (dos == null) break block13;
                    CompressedStreamTools.func_74800_a((NBTTagCompound)this.writeChunkToNBT(), (DataOutput)dos);
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        Logging.logError("%s while closing chunk data output stream", e);
                    }
                    break block11;
                    catch (IOException e) {
                        try {
                            Logging.logError("%s: could not write chunk (%d, %d) to region file", e, this.x, this.z);
                            error = true;
                        }
                        catch (Throwable throwable) {
                            try {
                                dos.close();
                            }
                            catch (IOException e2) {
                                Logging.logError("%s while closing chunk data output stream", e2);
                            }
                            throw throwable;
                        }
                        try {
                            dos.close();
                        }
                        catch (IOException e3) {
                            Logging.logError("%s while closing chunk data output stream", e3);
                        }
                        break block11;
                    }
                }
                Logging.logError("error: could not get output stream for chunk (%d, %d)", this.x, this.z);
                break block11;
            }
            Logging.logError("error: could not open region file for chunk (%d, %d)", this.x, this.z);
        }
        return error;
    }

    public Long getCoordIntPair() {
        return ChunkCoordIntPair.func_77272_a((int)this.x, (int)this.z);
    }
}

