/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.config;

import java.io.File;
import mapwriter.config.Config;
import mapwriter.util.Logging;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.setMapModeDefaults();
            ConfigurationHandler.loadConfig();
            Config.fullScreenMap.loadConfig();
            Config.largeMap.loadConfig();
            Config.smallMap.loadConfig();
            if (configuration.hasChanged()) {
                configuration.save();
            }
            configuration.get("options", "overlayModeIndex", Config.overlayModeIndexDef).setShowInGui(false);
            configuration.get("options", "overlayZoomLevel", Config.zoomInLevelsDef).setShowInGui(false);
        }
    }

    public static void loadConfig() {
        Config.linearTextureScaling = configuration.getBoolean("linearTextureScaling", "options", Config.linearTextureScalingDef, "", "mw.config.linearTextureScaling");
        Config.useSavedBlockColours = configuration.getBoolean("useSavedBlockColours", "options", Config.useSavedBlockColoursDef, "", "mw.config.useSavedBlockColours");
        Config.teleportEnabled = configuration.getBoolean("teleportEnabled", "options", Config.teleportEnabledDef, "", "mw.config.teleportEnabled");
        Config.teleportCommand = configuration.getString("teleportCommand", "options", Config.teleportCommandDef, "", "mw.config.teleportCommand");
        Config.maxChunkSaveDistSq = configuration.getInt("maxChunkSaveDistSq", "options", Config.maxChunkSaveDistSqDef, 1, 65536, "", "mw.config.maxChunkSaveDistSq");
        Config.mapPixelSnapEnabled = configuration.getBoolean("mapPixelSnapEnabled", "options", Config.mapPixelSnapEnabledDef, "", "mw.config.mapPixelSnapEnabled");
        Config.maxDeathMarkers = configuration.getInt("maxDeathMarkers", "options", Config.maxDeathMarkersDef, 0, 1000, "", "mw.config.maxDeathMarkers");
        Config.chunksPerTick = configuration.getInt("chunksPerTick", "options", Config.chunksPerTickDef, 1, 500, "", "mw.config.chunksPerTick");
        Config.saveDirOverride = configuration.getString("saveDirOverride", "options", Config.saveDirOverrideDef, "", "mw.config.saveDirOverride");
        Config.portNumberInWorldNameEnabled = configuration.getBoolean("portNumberInWorldNameEnabled", "options", Config.portNumberInWorldNameEnabledDef, "", "mw.config.portNumberInWorldNameEnabled");
        Config.undergroundMode = configuration.getBoolean("undergroundMode", "options", Config.undergroundModeDef, "", "mw.config.undergroundMode");
        Config.regionFileOutputEnabledSP = configuration.getBoolean("regionFileOutputEnabledSP", "options", Config.regionFileOutputEnabledSPDef, "", "mw.config.regionFileOutputEnabledSP");
        Config.regionFileOutputEnabledMP = configuration.getBoolean("regionFileOutputEnabledMP", "options", Config.regionFileOutputEnabledMPDef, "", "mw.config.regionFileOutputEnabledMP");
        Config.backgroundTextureMode = configuration.getString("backgroundTextureMode", "options", Config.backgroundTextureModeDef, "", Config.backgroundModeStringArray, "mw.config.backgroundTextureMode");
        Config.zoomOutLevels = configuration.getInt("zoomOutLevels", "options", Config.zoomOutLevelsDef, 1, 256, "", "mw.config.zoomOutLevels");
        Config.zoomInLevels = -configuration.getInt("zoomInLevels", "options", -Config.zoomInLevelsDef, 1, 256, "", "mw.config.zoomInLevels");
        Config.configTextureSize = configuration.getInt("textureSize", "options", Config.configTextureSizeDef, 1024, 4096, "", "mw.config.textureSize");
        Config.overlayModeIndex = configuration.getInt("overlayModeIndex", "options", Config.overlayModeIndexDef, 0, 1000, "", "mw.config.overlayModeIndex");
        Config.overlayZoomLevel = configuration.getInt("overlayZoomLevel", "options", Config.overlayZoomLevelDef, Config.zoomInLevels, Config.zoomOutLevels, "", "mw.config.overlayZoomLevel");
        Config.moreRealisticMap = configuration.getBoolean("moreRealisticMap", "options", Config.moreRealisticMapDef, "", "mw.config.moreRealisticMap");
        Config.newMarkerDialog = configuration.getBoolean("newMarkerDialog", "options", Config.newMarkerDialogDef, "", "mw.config.newMarkerDialog");
        Config.drawMarkersInWorld = configuration.getBoolean("drawMarkersInWorld", "options", Config.drawMarkersInWorldDef, "", "mw.config.drawMarkersInWorld");
        Config.drawMarkersNameInWorld = configuration.getBoolean("drawMarkersNameInWorld", "options", Config.drawMarkersNameInWorldDef, "", "mw.config.drawMarkersNameInWorld");
        Config.drawMarkersDistanceInWorld = configuration.getBoolean("drawMarkersDistanceInWorld", "options", Config.drawMarkersDistanceInWorldDef, "", "mw.config.drawMarkersDistanceInWorld");
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("MapWriter")) {
            if (event.getConfigID().equals("options")) {
                ConfigurationHandler.loadConfig();
            } else if (event.getConfigID().equals("fullscreenmap")) {
                Config.fullScreenMap.loadConfig();
            } else if (event.getConfigID().equals("largemap")) {
                Config.largeMap.loadConfig();
            } else if (event.getConfigID().equals("smallmap")) {
                Config.smallMap.loadConfig();
            } else {
                Logging.logError("Unknown config id: %s", event.getConfigID());
            }
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void setMapModeDefaults() {
        Config.fullScreenMap.setDefaults();
        Config.largeMap.setDefaults();
        Config.smallMap.setDefaults();
    }
}

