/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import mapwriter.util.Reference;
import mapwriter.util.Render;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;

public abstract class ScrollableField
extends Gui {
    public int x;
    public int y;
    public int width;
    public int labelX;
    public int labelY;
    public int labelWidth;
    public int labelHeight;
    public String label;
    private boolean drawArrows = false;
    private int leftArrowX;
    private int rightArrowX;
    private int arrowsY;
    public static int arrowsWidth = 7;
    private int arrowsHeight = 12;
    public final FontRenderer fontrendererObj;

    public ScrollableField(int x, int y, int width, String label, FontRenderer fontrendererObj) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.fontrendererObj = fontrendererObj;
        this.label = label;
        this.leftArrowX = this.x + 1;
        this.rightArrowX = this.x + (this.width - arrowsWidth);
        this.arrowsY = this.y;
        this.labelWidth = fontrendererObj.func_78256_a(this.label);
        this.labelHeight = this.fontrendererObj.field_78288_b;
        this.labelX = this.x - this.labelWidth;
        this.labelY = this.y + this.labelHeight / 2 - 2;
    }

    public void draw() {
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.func_73731_b(this.fontrendererObj, this.label, this.labelX, this.labelY, 0xFFFFFF);
        if (this.drawArrows) {
            renderEngine.func_110577_a(Reference.leftArrowTexture);
            Render.drawTexturedRect(this.leftArrowX, this.arrowsY, arrowsWidth, this.arrowsHeight, 0.0, 0.0, 1.0, 1.0);
            renderEngine.func_110577_a(Reference.rightArrowTexture);
            Render.drawTexturedRect(this.rightArrowX, this.arrowsY, arrowsWidth, this.arrowsHeight, 0.0, 0.0, 1.0, 1.0);
        }
    }

    public void setDrawArrows(boolean value) {
        this.drawArrows = value;
    }

    public void mouseClicked(int x, int y, int button) {
        int direction = this.posWithinArrows(x, y);
        if (direction == 1) {
            this.nextElement();
        } else if (direction == -1) {
            this.previousElement();
        }
    }

    public int posWithinArrows(int x, int y) {
        if (x >= this.leftArrowX && y >= this.arrowsY && x <= arrowsWidth + this.leftArrowX && y <= this.arrowsHeight + this.arrowsY) {
            return -1;
        }
        if (x >= this.rightArrowX && y >= this.arrowsY && x <= arrowsWidth + this.rightArrowX && y <= this.arrowsHeight + this.arrowsY) {
            return 1;
        }
        return 0;
    }

    public abstract void nextElement();

    public abstract void previousElement();

    public abstract void setFocused(Boolean var1);

    public abstract Boolean isFocused();
}

