/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.ChangePacket;
import assets.recipehandler.CraftingHandler;
import assets.recipehandler.GuiEventHandler;
import assets.recipehandler.RecipeMod;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

public final class ClientEventHandler
implements RecipeMod.IRegister {
    private KeyBinding key;
    private ItemStack oldItem = ItemStack.field_190927_a;
    private boolean pressed = false;

    @Override
    public void register() {
        if (RecipeMod.switchKey) {
            this.key = new KeyBinding("RecipeSwitch", (IKeyConflictContext)KeyConflictContext.GUI, 78, "key.categories.gui");
            ClientRegistry.registerKeyBinding((KeyBinding)this.key);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (RecipeMod.cycleButton) {
            MinecraftForge.EVENT_BUS.register((Object)GuiEventHandler.INSTANCE);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public void scheduleTask(Runnable runner) {
        FMLClientHandler.instance().getClient().func_152344_a(runner);
    }

    @Override
    public void sendShift(InventoryCrafting crafting, Slot slot) {
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer && GuiScreen.func_146272_n()) {
            GuiContainer screen = (GuiContainer)FMLClientHandler.instance().getClient().field_71462_r;
            ItemStack temp = FMLClientHandler.instance().getClient().field_71442_b.func_187098_a(screen.field_147002_h.field_75152_c, slot.field_75222_d, 0, ClickType.QUICK_MOVE, this.getPlayer());
            ItemStack result = CraftingHandler.findMatchingRecipe(crafting, ClientEventHandler.getWorld());
            if (!slot.func_75216_d() && !result.func_190926_b() && ItemStack.func_77989_b((ItemStack)result, (ItemStack)temp)) {
                RecipeMod.NETWORK.sendToServer(new ChangePacket(slot.field_75222_d, result, CraftingHandler.getRecipeIndex()).setShift().toProxy(Side.SERVER));
            }
        }
    }

    public static World getWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }

    private Container getContainer() {
        return this.getPlayer().field_71070_bA;
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Text event) {
        int result;
        if (RecipeMod.cornerText && this.getPlayer() != null && FMLClientHandler.instance().getClient().field_71462_r != null && (result = CraftingHandler.getNumberOfCraft(this.getContainer(), ClientEventHandler.getWorld())) > 1) {
            event.getRight().add(I18n.func_74837_a((String)"handler.found.text", (Object[])new Object[]{result}));
        }
    }

    @SubscribeEvent
    public void keyDown(InputEvent.MouseInputEvent event) {
        if (FMLClientHandler.instance().getClient().field_71462_r != null) {
            if (this.key != null) {
                if (GameSettings.func_100015_a((KeyBinding)this.key)) {
                    if (!this.pressed) {
                        this.pressed = true;
                        this.pressed();
                    }
                } else if (this.pressed) {
                    this.pressed = false;
                }
            }
            if (Mouse.isButtonDown((int)0) && GuiScreen.func_146272_n()) {
                InventoryCrafting craft;
                Slot result = null;
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer) {
                    Slot slot = ((GuiContainer)FMLClientHandler.instance().getClient().field_71462_r).getSlotUnderMouse();
                    if (!(slot instanceof SlotCrafting)) {
                        return;
                    }
                    result = slot;
                }
                if ((craft = CraftingHandler.getCraftingMatrix(this.getContainer())) != null) {
                    if (result == null) {
                        result = CraftingHandler.getResultSlot(this.getContainer(), craft, 0);
                    }
                    if (result != null) {
                        ItemStack res = CraftingHandler.findMatchingRecipe(craft, ClientEventHandler.getWorld());
                        if (res.func_190926_b()) {
                            this.oldItem = ItemStack.field_190927_a;
                        } else if (!ItemStack.func_77989_b((ItemStack)res, (ItemStack)result.func_75211_c())) {
                            RecipeMod.NETWORK.sendToServer(new ChangePacket(result.field_75222_d, res, CraftingHandler.getRecipeIndex()).setShift().toProxy(Side.SERVER));
                            this.oldItem = res;
                        }
                    }
                }
            }
        }
    }

    public void pressed() {
        InventoryCrafting craft = CraftingHandler.getCraftingMatrix(this.getContainer());
        if (craft != null) {
            ItemStack res = CraftingHandler.findNextMatchingRecipe(craft, ClientEventHandler.getWorld());
            if (res.func_190926_b()) {
                this.oldItem = ItemStack.field_190927_a;
            } else if (!ItemStack.func_77989_b((ItemStack)res, (ItemStack)this.oldItem)) {
                int index = 0;
                Slot slot = CraftingHandler.getResultSlot(this.getContainer(), craft, index);
                if (slot != null) {
                    index = slot.field_75222_d;
                }
                RecipeMod.NETWORK.sendToServer(new ChangePacket(index, res, CraftingHandler.getRecipeIndex()).toProxy(Side.SERVER));
                this.oldItem = res;
            }
        }
    }
}

