/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class CraftingHandler {
    private static HashMap<String, Field> knownCraftingContainer;
    private static HashSet<String> notCraftingContainer;
    private static Field slotCraftInv;
    private static int previousNumberOfCraft;
    private static long delayTimer;
    private static int recipeIndex;

    public static void enableGuessing() {
        knownCraftingContainer = new HashMap();
        notCraftingContainer = new HashSet();
        slotCraftInv = ReflectionHelper.findField(SlotCrafting.class, (String[])new String[]{"field_75239_a", "craftMatrix"});
    }

    public static int getRecipeIndex() {
        return recipeIndex;
    }

    public static void setRecipeIndex(int id) {
        if (id >= 0) {
            recipeIndex = id;
        }
    }

    @Nullable
    public static InventoryCrafting getCraftingMatrix(Container container) {
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75181_e;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75162_e;
        }
        if (notCraftingContainer != null) {
            for (Slot slot : container.field_75151_b) {
                if (slot == null || !(slot.field_75224_c instanceof InventoryCrafting)) continue;
                return (InventoryCrafting)slot.field_75224_c;
            }
            String name = container.getClass().getName();
            if (!notCraftingContainer.contains(name)) {
                Field f = knownCraftingContainer.get(name);
                if (f == null) {
                    for (Field field : container.getClass().getDeclaredFields()) {
                        if (field == null) continue;
                        try {
                            field.setAccessible(true);
                            Object craft = field.get(container);
                            if (!(craft instanceof InventoryCrafting)) continue;
                            knownCraftingContainer.put(name, field);
                            return (InventoryCrafting)craft;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    notCraftingContainer.add(name);
                } else {
                    try {
                        return (InventoryCrafting)f.get(container);
                    }
                    catch (Exception ref) {
                        knownCraftingContainer.put(name, null);
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack findNextMatchingRecipe(InventoryCrafting craft, World world) {
        recipeIndex = recipeIndex == Integer.MAX_VALUE ? 0 : ++recipeIndex;
        return CraftingHandler.findMatchingRecipe(craft, world);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting craft, World world) {
        if (!CraftingManager.func_77594_a().func_82787_a(craft, world).func_190926_b()) {
            List<ItemStack> result = CraftingHandler.getCraftResult(craft, world);
            if (previousNumberOfCraft != result.size()) {
                previousNumberOfCraft = result.size();
                recipeIndex = 0;
            }
            delayTimer = world.func_82737_E();
            if (previousNumberOfCraft == 0) {
                return ItemStack.field_190927_a;
            }
            if (recipeIndex < 0) {
                int j1 = -recipeIndex;
                j1 %= previousNumberOfCraft;
                if ((j1 = previousNumberOfCraft - j1) == previousNumberOfCraft) {
                    j1 = 0;
                }
                return result.get(j1);
            }
            return result.get(recipeIndex % previousNumberOfCraft);
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getCraftResult(InventoryCrafting craft, World world) {
        Iterator recipes = CraftingManager.func_77594_a().func_77592_b().iterator();
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        while (recipes.hasNext()) {
            IRecipe irecipe = (IRecipe)recipes.next();
            if (!irecipe.func_77569_a(craft, world)) continue;
            arraylist.add(irecipe.func_77572_b(craft));
        }
        return arraylist;
    }

    @Nullable
    public static Slot getResultSlot(Container container, InventoryCrafting inventory, int index) {
        Slot slot;
        if (index < container.field_75151_b.size() && (slot = container.func_75139_a(index)) instanceof SlotCrafting) {
            return slot;
        }
        if (slotCraftInv != null) {
            try {
                for (Slot slot2 : container.field_75151_b) {
                    if (!(slot2 instanceof SlotCrafting) || inventory != slotCraftInv.get(slot2)) continue;
                    return slot2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getNumberOfCraft(Container container, World world) {
        if (world.func_82737_E() - delayTimer > 10L) {
            delayTimer = world.func_82737_E();
            InventoryCrafting craft = CraftingHandler.getCraftingMatrix(container);
            previousNumberOfCraft = craft != null ? CraftingHandler.getCraftResult(craft, world).size() : 0;
        }
        return previousNumberOfCraft;
    }

    static {
        delayTimer = 0L;
    }
}

