/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.realbench;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import pw.prok.realbench.WorkbenchContainer;

public class WorkbenchTile
extends TileEntity {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;
    public static final int TOTAL = 9;
    protected final ItemStack[] mCraftMatrix = new ItemStack[9];

    public void onBlockActivated(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            mp.func_71117_bO();
            mp.field_71135_a.func_147359_a((Packet)new S2DPacketOpenWindow(mp.field_71139_cq, 1, "Crafting", 9, true));
            mp.field_71070_bA = new WorkbenchContainer(player.field_71071_by, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            mp.field_71070_bA.field_75152_c = mp.field_71139_cq;
            mp.field_71070_bA.func_75132_a((ICrafting)mp);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public List<ItemStack> getCraftMatrixItems() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : this.mCraftMatrix) {
            if (stack == null) continue;
            builder.add((Object)stack);
        }
        return builder.build();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeSlots(nbt);
    }

    private void writeSlots(NBTTagCompound nbt) {
        for (int i = 0; i < 9; ++i) {
            if (this.mCraftMatrix[i] == null) {
                nbt.func_82580_o("Slot" + i);
                continue;
            }
            NBTTagCompound slot = new NBTTagCompound();
            this.mCraftMatrix[i].func_77955_b(slot);
            nbt.func_74782_a("Slot" + i, (NBTBase)slot);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSlots(nbt);
    }

    private void readSlots(NBTTagCompound nbt) {
        for (int i = 0; i < 9; ++i) {
            this.mCraftMatrix[i] = !nbt.func_150297_b("Slot" + i, 10) ? null : ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Slot" + i));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeSlots(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSlots(pkt.func_148857_g());
    }
}

