/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.realbench;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import pw.prok.realbench.WorkbenchTile;

public class WorkbenchRenderer
extends TileEntitySpecialRenderer<WorkbenchTile> {
    Map<WorkbenchTile, RenderingState> states = new WeakHashMap<WorkbenchTile, RenderingState>();
    static final int ANIMATION_DURATION = 1000;

    public void renderTileEntityAt(WorkbenchTile tile, double xOffset, double yOffset, double zOffset, float partialTicks, int destroyStage) {
        super.func_180535_a((TileEntity)tile, xOffset, yOffset, zOffset, partialTicks, destroyStage);
        for (int i = 0; i < tile.mCraftMatrix.size(); ++i) {
            Item item;
            ItemStack itemStack = (ItemStack)tile.mCraftMatrix.get(i);
            if (itemStack == ItemStack.field_190927_a) continue;
            RenderingState state = this.states.get((Object)tile);
            if (state == null) {
                state = new RenderingState();
                this.states.put(tile, state);
            }
            double playerAngle = (Math.atan2(xOffset + 0.5, zOffset + 0.5) + 3.9269908169872414) % (Math.PI * 2);
            byte sector = (byte)(playerAngle * 2.0 / Math.PI);
            long time = System.currentTimeMillis();
            if (state.sector != sector) {
                state.animating = true;
                state.animationAngleStart = state.currentAngle;
                float delta1 = (float)sector * 90.0f - state.currentAngle;
                float abs1 = Math.abs(delta1);
                float delta2 = delta1 + 360.0f;
                float abs2 = Math.abs(delta2);
                float delta3 = delta1 - 360.0f;
                float abs3 = Math.abs(delta3);
                state.animationAngleEnd = abs3 < abs1 && abs3 < abs2 ? delta3 + state.currentAngle : (abs2 < abs1 && abs2 < abs3 ? delta2 + state.currentAngle : delta1 + state.currentAngle);
                state.startTime = time;
                state.sector = sector;
            }
            if (state.animating) {
                if (time >= state.startTime + 1000L) {
                    state.animating = false;
                    state.currentAngle = (state.animationAngleEnd + 360.0f) % 360.0f;
                } else {
                    state.currentAngle = (WorkbenchRenderer.easeOutQuad(time - state.startTime, state.animationAngleStart, state.animationAngleEnd - state.animationAngleStart, 1000) + 360.0f) % 360.0f;
                }
            }
            Object block = (item = itemStack.func_77973_b()) instanceof ItemBlock ? ((ItemBlock)item).field_150939_a : (item instanceof ItemBlockSpecial ? ((ItemBlockSpecial)item).field_150935_a : null);
            boolean normalBlock = block != null && block.func_176223_P().func_185904_a().func_76220_a();
            float shift = (float)Math.abs((time + (long)(i * 1000)) % 5000L - 2500L) / 200000.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(xOffset + 0.5), (double)(yOffset + (double)shift), (double)(zOffset + 0.5));
            GlStateManager.func_179114_b((float)state.currentAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)(i % 3) * 3.0 / 16.0 + 0.3125 - 0.5), (double)1.09375, (double)((double)(i / 3) * 3.0 / 16.0 + 0.3125 - 0.5));
            if (!normalBlock) {
                GlStateManager.func_179114_b((float)(-this.field_147501_a.field_147563_i), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)0.125f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(itemStack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }

    private static float easeOutQuad(long t, float b, float c, int d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }

    static class RenderingState {
        byte sector;
        float currentAngle;
        boolean animating;
        float animationAngleStart;
        float animationAngleEnd;
        long startTime;

        RenderingState() {
        }
    }
}

