/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static final Random random = new Random();
    public static List<abp> availableItems = new ArrayList<abp>();

    public static File configFile() {
        return new File(azd.A().w, CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(azd.A().w, NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i = 0; i < 7; ++i) {
                        map.put("save" + (i + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i = 0; i < tMIConfig.getNumSaves(); ++i) {
                        if (!map.containsKey("save" + (i + 1))) continue;
                        tMIConfig.decodeState(i, map.get("save" + (i + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            dg dg2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            dp dp2 = new dp();
            dp dp3 = new dp();
            List<abp> list = tMIConfig.getFavorites();
            for (abp dp4 : list) {
                dg2 = new dg();
                if (dp4 != null) {
                    dp4.b(dg2);
                }
                dp3.a((du)dg2);
            }
            dp2.a((du)dp3);
            for (int i = 0; i < 7; ++i) {
                if (TMIConfig.statesSaved[i]) {
                    abp[] abpArray = tMIConfig.getState(i);
                    dg2 = new dp();
                    for (int j = 0; j < abpArray.length; ++j) {
                        dg dg3 = new dg();
                        if (abpArray[j] != null) {
                            abpArray[j].b(dg3);
                        }
                        dg2.a((du)dg3);
                    }
                    dp2.a((du)dg2);
                    continue;
                }
                dp dp4 = new dp();
                dp2.a((du)dp4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)dp2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println("[TMI] While saving NBT file.");
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            abp[] abpArray;
            dp dp2;
            du du2;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dp dp3 = new dp();
            TMIPrivateFields.readTagList.invoke((Object)dp3, dataInputStream, 1);
            List<du> list = TMISnapshotUtil.getTaglist(dp3);
            int n = 0;
            if (list.size() > 0) {
                List<du> list2 = TMISnapshotUtil.getTaglist((dp)list.get(0));
                du2 = tMIConfig.getFavorites();
                du2.clear();
                dp2 = list2.iterator();
                while (dp2.hasNext()) {
                    abpArray = dp2.next();
                    abp abp2 = TMISnapshotUtil.createStack(1);
                    abp2.c((dg)abpArray);
                    du2.add(abp2);
                }
            }
            for (int i = 1; i < list.size(); ++i) {
                n = i - 1;
                du2 = list.get(i);
                if (!(du2 instanceof dp) || (dp2 = (dp)du2).c() <= 0 || n >= 7) continue;
                abpArray = tMIConfig.getState(n);
                for (int j = 0; j < dp2.c(); ++j) {
                    dg dg2 = dp2.b(j);
                    if (dg2.c("id")) {
                        abpArray[j] = TMISnapshotUtil.createStack(1);
                        abpArray[j].c(dg2);
                        continue;
                    }
                    abpArray[j] = null;
                }
                TMIConfig.statesSaved[n] = true;
            }
        }
        catch (Exception exception) {
            System.out.println("[TMI] While loading NBT");
            exception.printStackTrace();
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        Object object;
        Object object2;
        Iterator iterator;
        Serializable serializable;
        List<abp> list = availableItems;
        List<abn> list2 = tMIConfig.getEnchantableItems();
        boolean bl = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            iterator = (ahu)((Class)serializable).getDeclaredField("blockMicro").get(null);
            object2 = ahu.class.getDeclaredField("_block_id");
            TMIItemInfo.setMaxDamageException(((Field)object2).getInt(iterator), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new ArrayList();
        iterator = TMISnapshotUtil.itemIter();
        block11: while (iterator.hasNext()) {
            Iterator<Object> iterator2;
            object2 = (abn)iterator.next();
            if (object2 == null) continue;
            if (TMISnapshotUtil.idForItem((abn)object2) == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                iterator2 = qt.a.keySet().iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    list.add(TMISnapshotUtil.newStack(TMIItemInfo.addItemOffset(127), 64, (Integer)object));
                }
                continue;
            }
            if (TMISnapshotUtil.idForItem((abn)object2) == 52) {
                if (bl) {
                    list.add(TMISnapshotUtil.newStack(52, 64, 0));
                    continue;
                }
                try {
                    iterator2 = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (iterator2.hasNext()) {
                        int n = (Integer)iterator2.next();
                        abp abp2 = TMISnapshotUtil.newStack(52, 64, n);
                        TMICustomItems.nameStack(abp2, "\u00a7r" + qt.b((int)n) + " Spawner");
                        list.add(abp2);
                    }
                    list.addAll(TMICustomItems.tmiCustomSpawners());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    list.add(TMISnapshotUtil.newStack(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(TMISnapshotUtil.idForItem((abn)object2))) continue;
            if (object2.c() > 0) {
                list2.add((abn)object2);
            }
            if ((iterator2 = TMISnapshotUtil.blockForId(TMISnapshotUtil.idForItem((abn)object2))) != null) {
                serializable.clear();
                iterator2.a((abn)object2, null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    object = serializable.iterator();
                    while (object.hasNext()) {
                        abp abp3 = (abp)object.next();
                        abp3.b = TMISnapshotUtil.maxStack(abp3);
                        list.add(abp3);
                    }
                    continue;
                }
            }
            object = new HashSet();
            int n = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(TMISnapshotUtil.idForItem((abn)object2));
            if (n2 > n) {
                n = n2;
            }
            boolean bl2 = false;
            for (int i = 0; i <= n; ++i) {
                if (TMISnapshotUtil.idForItem((abn)object2) == 43 && i > 0 || TMISnapshotUtil.idForItem((abn)object2) == 44 && i > 5 || TMISnapshotUtil.idForItem((abn)object2) == 59 && (i != 7 || bl) || TMISnapshotUtil.idForItem((abn)object2) == 104 && (i != 7 || bl) || TMISnapshotUtil.idForItem((abn)object2) == 105 && (i != 7 || bl) || TMISnapshotUtil.idForItem((abn)object2) == 115 && (i != 3 || bl) || TMISnapshotUtil.idForItem((abn)object2) == 78 && i > 0 && bl || TMISnapshotUtil.idForItem((abn)object2) == 125 && i > 0 || TMISnapshotUtil.idForItem((abn)object2) == 126 && i > 3) continue;
                abp abp4 = new abp((abn)object2, object2.m(), i);
                try {
                    ps ps2 = object2.j(abp4);
                    String string = object2.a(abp4);
                    if (TMIUtils.itemDisplayName(abp4).equals("Unnamed")) {
                        if (i != 0) continue;
                        continue block11;
                    }
                    if (iterator2 != null) {
                        try {
                            iterator2.b(1, i);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl3 = !bl && (TMISnapshotUtil.idForItem((abn)object2) == 99 || TMISnapshotUtil.idForItem((abn)object2) == 100) && i < 16;
                    String string2 = string + "@" + ps2.g();
                    if (((HashSet)object).contains(string2) && !TMIItemInfo.isShown(TMISnapshotUtil.idForItem((abn)object2), i) && !bl3) continue;
                    list.add(abp4);
                    ((HashSet)object).add(string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object2 = TMIItemInfo.potionValues.iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                object = TMISnapshotUtil.newStack(TMIItemInfo.addItemOffset(117), 64, n);
                list.add((abp)object);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                list.addAll(TMICustomItems.tmiCustomPotions());
                list.addAll(TMICustomItems.tmiCustomFireworks());
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<abp> list = availableItems;
        List<abp> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (abp abp2 : list) {
                list2.add(abp2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (abp abp3 : list) {
                String string2;
                if (abp3 == null || (string2 = TMIUtils.itemDisplayName(abp3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(abp3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(azd.A().w, string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.7.2 2014-01-13\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(abp abp2, boolean bl) {
        return TMIUtils.itemDisplayNameMultiline(abp2, bl, false);
    }

    public static List<String> itemDisplayNameMultiline(abp abp2, boolean bl, boolean bl2) {
        Object object;
        if (abp2 == null) {
            return EMPTY_NAME;
        }
        if (bl2) {
            bl = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(abp2)) {
            try {
                object = abp2.a((xl)azd.A().h, bl2);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || TMISnapshotUtil.idForStack(abp2) == 52 && abp2.d == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(TMISnapshotUtil.idForStack(abp2), abp2.j()));
            if (bl2) {
                bl = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(TMISnapshotUtil.idForStack(abp2), abp2.j());
            list.set(0, (String)object);
        }
        if (bl && abp2 != null) {
            object = (String)object + " " + TMISnapshotUtil.idForStack(abp2);
            if (abp2.j() != 0) {
                object = (String)object + " : " + abp2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(abp abp2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(abp2, false);
        return list.get(0);
    }

    public static boolean isValidItem(abp abp2) {
        return abp2 == null || TMISnapshotUtil.itemForStack(abp2) != null;
    }

    public static abp getValidItem(abp abp2) {
        if (TMIUtils.isValidItem(abp2)) {
            return abp2;
        }
        return TMISnapshotUtil.createStack(52);
    }

    public static String getValidItemDisplayName(abp abp2) {
        if (TMIUtils.isValidItem(abp2)) {
            return TMIUtils.itemDisplayName(abp2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(abp abp2) {
        TMIUtils.getPlayer().bn.b(abp2);
        azd.A().h.bn.b(abp2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static abp getHeldItem() {
        return azd.A().h.bn.o();
    }

    public static void giveStack(abp abp2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(abp2, tMIConfig, abp2.b);
    }

    public static void giveStack(abp abp2, TMIConfig tMIConfig, int n) {
        abp abp3 = TMIUtils.copyStack(abp2);
        abp3.b = n;
        azd azd2 = azd.A();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            boolean bl = tMIConfig.getBooleanSetting("give-command-num-id");
            String string = bl ? "" + TMISnapshotUtil.idForStack(abp3) : TMISnapshotUtil.keyForItem(TMISnapshotUtil.itemForStack(abp3));
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{azd2.h.b_(), string, abp3.b, abp3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            for (int[] nArray : TMIUtils.getEnchantments(abp3)) {
                stringBuilder.append(" ");
                stringBuilder.append(nArray[0]);
                stringBuilder.append(":");
                stringBuilder.append(nArray[1]);
            }
            azd2.h.a(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bn.a(abp3);
        }
    }

    public static abp copyStack(abp abp2) {
        return abp2 == null ? null : abp2.m();
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (abp abp2 : TMIUtils.getPlayer().bn.a) {
                dg dg2;
                if (abp2 == null || abp2.d == null || !abp2.d.c("TooManyItems") || !(dg2 = abp2.d.m("TooManyItems")).c("Unlimited")) continue;
                if (TMIConfig.isTool(TMISnapshotUtil.idForStack(abp2))) {
                    abp2.b(0);
                    continue;
                }
                int n = TMIUtils.maxStackSize(TMISnapshotUtil.idForStack(abp2));
                if (n == 1) {
                    n = 64;
                }
                abp2.b = n;
            }
            abp abp3 = TMIUtils.getHeldItem();
            if (abp3 != null && abp3.b > 64) {
                abp3.b = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(abp abp2, int n) {
        try {
            TMIPrivateFields.stackDamage.setInt(abp2, n);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            zk zk2 = (zk)list.get(i);
            if (zk2 == null) continue;
            zk2.c((abp)null);
        }
    }

    public static void deleteItemsOfType(abp abp2, bdd bdd2) {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            abp abp3;
            zk zk2 = (zk)list.get(i);
            if (zk2 == null || (abp3 = zk2.d()) == null || TMISnapshotUtil.idForStack(abp3) != TMISnapshotUtil.idForStack(abp2) || abp3.j() != abp2.j()) continue;
            zk2.c((abp)null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((afw)TMIPrivateFields.gameMode.get(azd.A().c)).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n) {
        if (TMIConfig.isMultiplayer()) {
            azd.A().h.a("/gamemode " + n);
        } else {
            TMIUtils.getPlayer().a(afw.a((int)n));
        }
    }

    public static boolean isCreativeMode() {
        return azd.A().c.h();
    }

    public static void setCreativeMode(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            azd.A().h.a("/gamemode " + (bl ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl ? afw.c : afw.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return azd.A().f.M().p();
    }

    public static void setRaining(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            azd.A().h.a("/toggledownfall");
        } else {
            MinecraftServer.G().b[0].M().b(bl);
            MinecraftServer.G().b[0].M().g(bl ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return azd.A().f.M().g();
    }

    public static void setTime(long l) {
        if (TMIConfig.isMultiplayer()) {
            azd.A().h.a("/time set " + l);
        } else {
            MinecraftServer.G().b[0].b(l);
        }
    }

    public static void setHourForward(int n) {
        long l = TMIUtils.getTime() / 24000L * 24000L;
        long l2 = l + 24000L + (long)(n * 1000);
        TMIUtils.setTime(l2);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static void logWithTrace(String string, int n) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !azd.A().h.L;
    }

    public static void setPlayerHealth(float f) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().g(f);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bO().a(20);
            TMIUtils.getPlayer().bO().b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        azd.A().u.a(azz.l, 1);
    }

    public static String getDifficultyString() {
        return azd.A().u.c(azz.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : azd.A().q.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(azd.A().q, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n) {
        return TMISnapshotUtil.itemForId(n).m();
    }

    public static List<int[]> getEnchantments(abp abp2) {
        dp dp2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (abp2 != null && (dp2 = abp2.r()) != null) {
            for (int i = 0; i < dp2.c(); ++i) {
                short s = dp2.b(i).e("id");
                short s2 = dp2.b(i).e("lvl");
                int[] nArray = new int[]{s, s2};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(abp abp2, int n, int n2) {
        if (n < aef.b.length && aef.b[n] != null) {
            abp2.a(aef.b[n], n2);
            return true;
        }
        return false;
    }

    public static dg getTagCompoundWithCreate(abp abp2, String string) {
        dg dg2;
        if (abp2.d == null) {
            abp2.d = new dg();
        }
        if (!abp2.d.c(string)) {
            dg2 = new dg();
            abp2.d.a(string, (du)dg2);
        } else {
            dg2 = abp2.d.m(string);
        }
        return dg2;
    }

    public static mm getPlayer() {
        MinecraftServer minecraftServer = MinecraftServer.G();
        ld ld2 = minecraftServer.af();
        String string = azd.A().h.b_();
        return ld2.e(string);
    }

    public static boolean isEnchantmentNormallyPossible(aef aef2, abn abn2) {
        return aef2.C.a(abn2) || TMISnapshotUtil.idForItem(abn2) == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(aef aef2, abp abp2) {
        return aef2.C.a(TMISnapshotUtil.itemForId(TMISnapshotUtil.idForStack(abp2))) || TMISnapshotUtil.idForStack(abp2) == TMIItemInfo.addItemOffset(147);
    }

    public static List<aef> getPossibleEnchantments(abn abn2) {
        if (abn2.c() > 0) {
            ArrayList<aef> arrayList = new ArrayList<aef>();
            for (aef aef2 : aef.b) {
                if (aef2 == null || !aef2.C.a(abn2)) continue;
                arrayList.add(aef2);
            }
            return arrayList;
        }
        return new ArrayList<aef>();
    }

    public static void dumpItemList() {
        try {
            File file = new File(azd.A().w, "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (abp abp2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + TMISnapshotUtil.idForStack(abp2) + ":" + abp2.j() + " " + TMIUtils.getValidItemDisplayName(abp2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

