/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static final Random random = new Random();
    public static List<ye> availableItems = new ArrayList<ye>();

    public static File configFile() {
        return new File(atv.w().x, CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(atv.w().x, NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i = 0; i < 7; ++i) {
                        map.put("save" + (i + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i = 0; i < tMIConfig.getNumSaves(); ++i) {
                        if (!map.containsKey("save" + (i + 1))) continue;
                        tMIConfig.decodeState(i, map.get("save" + (i + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            by by2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            cg cg2 = new cg();
            cg cg3 = new cg();
            List<ye> list = tMIConfig.getFavorites();
            for (ye cg4 : list) {
                by2 = new by();
                if (cg4 != null) {
                    cg4.b(by2);
                }
                cg3.a((cl)by2);
            }
            cg2.a((cl)cg3);
            for (int i = 0; i < 7; ++i) {
                if (TMIConfig.statesSaved[i]) {
                    ye[] yeArray = tMIConfig.getState(i);
                    by2 = new cg();
                    for (int j = 0; j < yeArray.length; ++j) {
                        by by3 = new by();
                        if (yeArray[j] != null) {
                            yeArray[j].b(by3);
                        }
                        by2.a((cl)by3);
                    }
                    cg2.a((cl)by2);
                    continue;
                }
                cg cg4 = new cg();
                cg2.a((cl)cg4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)cg2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            ye[] yeArray;
            cl cl2;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            cg cg2 = new cg();
            TMIPrivateFields.readTagList.invoke((Object)cg2, dataInputStream, 1);
            int n = 0;
            if (cg2.c() > 0) {
                cg cg3 = (cg)cg2.b(0);
                cl2 = tMIConfig.getFavorites();
                cl2.clear();
                for (int i = 0; i < cg3.c(); ++i) {
                    yeArray = (ye[])cg3.b(i);
                    ye ye2 = new ye(0, 1, 0);
                    ye2.c((by)yeArray);
                    cl2.add(ye2);
                }
            }
            for (int i = 1; i < cg2.c(); ++i) {
                cg cg4;
                n = i - 1;
                cl2 = cg2.b(i);
                if (!(cl2 instanceof cg) || (cg4 = (cg)cl2).c() <= 0 || n >= 7) continue;
                yeArray = tMIConfig.getState(n);
                for (int j = 0; j < cg4.c(); ++j) {
                    cl cl3 = cg4.b(j);
                    if (!(cl3 instanceof by)) continue;
                    by by2 = (by)cl3;
                    if (by2.b("id")) {
                        yeArray[j] = new ye(0, 1, 0);
                        yeArray[j].c(by2);
                        continue;
                    }
                    yeArray[j] = null;
                }
                TMIConfig.statesSaved[n] = true;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        Object object;
        Serializable serializable;
        List<ye> list = availableItems;
        List<yc> list2 = tMIConfig.getEnchantableItems();
        boolean bl = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            object = (aqz)((Class)serializable).getDeclaredField("blockMicro").get(null);
            Field field = aqz.class.getDeclaredField("cF");
            TMIItemInfo.setMaxDamageException(field.getInt(object), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new ArrayList();
        block11: for (aqz aqz2 : yc.g) {
            Iterator<String> iterator;
            if (aqz2 == null) continue;
            if (aqz2.cv == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                for (Object object2 : nt.a.keySet()) {
                    list.add(new ye(TMIItemInfo.addItemOffset(127), 64, ((Integer)object2).intValue()));
                }
                continue;
            }
            if (aqz2.cv == 52) {
                if (bl) {
                    list.add(new ye(52, 64, 0));
                    continue;
                }
                try {
                    iterator = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        ye ye2 = new ye(52, 64, n);
                        TMICustomItems.nameStack(ye2, "\u00a7r" + nt.b((int)n) + " Spawner");
                        list.add(ye2);
                    }
                    list.addAll(TMICustomItems.tmiCustomSpawners());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    list.add(new ye(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(aqz2.cv)) continue;
            if (aqz2.c() > 0) {
                list2.add((yc)aqz2);
            }
            if (aqz2.cv < aqz.s.length && aqz.s[aqz2.cv] != null) {
                serializable.clear();
                aqz.s[aqz2.cv].a(aqz2.cv, (ww)null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        ye ye3 = (ye)iterator.next();
                        ye3.b = yc.g[ye3.d].m();
                        list.add(ye3);
                    }
                    continue;
                }
            }
            iterator = new HashSet();
            int n = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(aqz2.cv);
            if (n2 > n) {
                n = n2;
            }
            boolean bl2 = false;
            for (int i = 0; i <= n; ++i) {
                if (aqz2.cv == 43 && i > 0 || aqz2.cv == 44 && i > 5 || aqz2.cv == 59 && (i != 7 || bl) || aqz2.cv == 104 && (i != 7 || bl) || aqz2.cv == 105 && (i != 7 || bl) || aqz2.cv == 115 && (i != 3 || bl) || aqz2.cv == 78 && i > 0 && bl || aqz2.cv == 125 && i > 0 || aqz2.cv == 126 && i > 3) continue;
                ye ye4 = new ye((yc)aqz2, aqz2.m(), i);
                try {
                    ms ms2 = aqz2.h(ye4);
                    String string = aqz2.d(ye4);
                    if (TMIUtils.itemDisplayName(ye4).equals("Unnamed")) {
                        if (i != 0) continue;
                        continue block11;
                    }
                    if (aqz2.cv < aqz.s.length && aqz.s[aqz2.cv] != null) {
                        try {
                            aqz.s[aqz2.cv].a(1, i);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl3 = !bl && (aqz2.cv == 99 || aqz2.cv == 100) && i < 16;
                    String string2 = string + "@" + ms2.g();
                    if (((HashSet)((Object)iterator)).contains(string2) && !TMIItemInfo.isShown(aqz2.cv, i) && !bl3) continue;
                    list.add(ye4);
                    ((HashSet)((Object)iterator)).add(string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object = TMIItemInfo.potionValues.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                ye ye5 = new ye(TMIItemInfo.addItemOffset(117), 64, n);
                list.add(ye5);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                list.addAll(TMICustomItems.tmiCustomPotions());
                list.addAll(TMICustomItems.tmiCustomFireworks());
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<ye> list = availableItems;
        List<ye> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (ye ye2 : list) {
                list2.add(ye2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (ye ye3 : list) {
                String string2;
                if (ye3 == null || (string2 = TMIUtils.itemDisplayName(ye3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(ye3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(atv.w().x, string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.6.4 2013-09-24\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(ye ye2, boolean bl) {
        return TMIUtils.itemDisplayNameMultiline(ye2, bl, false);
    }

    public static List<String> itemDisplayNameMultiline(ye ye2, boolean bl, boolean bl2) {
        Object object;
        if (ye2 == null) {
            return EMPTY_NAME;
        }
        if (bl2) {
            bl = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(ye2)) {
            try {
                object = ye2.a((uf)atv.w().h, bl2);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || ye2.d == 52 && ye2.e == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(ye2.d, ye2.j()));
            if (bl2) {
                bl = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(ye2.d, ye2.j());
            list.set(0, (String)object);
        }
        if (bl && ye2 != null) {
            object = (String)object + " " + ye2.d;
            if (ye2.j() != 0) {
                object = (String)object + " : " + ye2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(ye ye2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(ye2, false);
        return list.get(0);
    }

    public static boolean isValidItem(ye ye2) {
        return ye2 == null || ye2.d >= 0 && ye2.d < yc.g.length && yc.g[ye2.d] != null;
    }

    public static ye getValidItem(ye ye2) {
        if (TMIUtils.isValidItem(ye2)) {
            return ye2;
        }
        return new ye(yc.g[52]);
    }

    public static String getValidItemDisplayName(ye ye2) {
        if (TMIUtils.isValidItem(ye2)) {
            return TMIUtils.itemDisplayName(ye2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(ye ye2) {
        TMIUtils.getPlayer().bn.b(ye2);
        atv.w().h.bn.b(ye2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static ye getHeldItem() {
        return atv.w().h.bn.o();
    }

    public static void giveStack(ye ye2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(ye2, tMIConfig, ye2.b);
    }

    public static void giveStack(ye ye2, TMIConfig tMIConfig, int n) {
        ye ye3 = TMIUtils.copyStack(ye2);
        ye3.b = n;
        atv atv2 = atv.w();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            messageFormat.setFormatByArgumentIndex(1, numberFormat);
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{atv2.h.bu, ye3.d, ye3.b, ye3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            for (int[] nArray : TMIUtils.getEnchantments(ye3)) {
                stringBuilder.append(" ");
                stringBuilder.append(nArray[0]);
                stringBuilder.append(":");
                stringBuilder.append(nArray[1]);
            }
            atv2.h.b(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bn.a(ye3);
        }
    }

    public static ye copyStack(ye ye2) {
        return ye2 == null ? null : ye2.m();
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (ye ye2 : TMIUtils.getPlayer().bn.a) {
                by by2;
                if (ye2 == null || ye2.e == null || !ye2.e.b("TooManyItems") || !(by2 = ye2.e.l("TooManyItems")).b("Unlimited")) continue;
                if (TMIConfig.isTool(ye2.d)) {
                    ye2.b(0);
                    continue;
                }
                int n = TMIUtils.maxStackSize(ye2.d);
                if (n == 1) {
                    n = 64;
                }
                ye2.b = n;
            }
            ye ye3 = TMIUtils.getHeldItem();
            if (ye3 != null && ye3.b > 64) {
                ye3.b = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(ye ye2, int n) {
        try {
            TMIPrivateFields.stackDamage.setInt(ye2, n);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            we we2 = (we)list.get(i);
            if (we2 == null) continue;
            we2.c((ye)null);
        }
    }

    public static void deleteItemsOfType(ye ye2, awy awy2) {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            ye ye3;
            we we2 = (we)list.get(i);
            if (we2 == null || (ye3 = we2.d()) == null || ye3.d != ye2.d || ye3.j() != ye2.j()) continue;
            we2.c((ye)null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((ace)TMIPrivateFields.gameMode.get(atv.w().c)).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n) {
        if (TMIConfig.isMultiplayer()) {
            atv.w().h.b("/gamemode " + n);
        } else {
            TMIUtils.getPlayer().a(ace.a((int)n));
        }
    }

    public static boolean isCreativeMode() {
        return atv.w().c.h();
    }

    public static void setCreativeMode(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            atv.w().h.b("/gamemode " + (bl ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl ? ace.c : ace.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return atv.w().f.x.p();
    }

    public static void setRaining(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            atv.w().h.b("/toggledownfall");
        } else {
            MinecraftServer.F().b[0].x.b(bl);
            MinecraftServer.F().b[0].x.g(bl ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return atv.w().f.x.g();
    }

    public static void setTime(long l) {
        if (TMIConfig.isMultiplayer()) {
            atv.w().h.b("/time set " + l);
        } else {
            MinecraftServer.F().b[0].b(l);
        }
    }

    public static void setHourForward(int n) {
        long l = TMIUtils.getTime() / 24000L * 24000L;
        long l2 = l + 24000L + (long)(n * 1000);
        TMIUtils.setTime(l2);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static void logWithTrace(String string, int n) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !atv.w().h.M;
    }

    public static void setPlayerHealth(float f) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().g(f);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bq.a(20);
            TMIUtils.getPlayer().bq.b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        atv.w().u.a(aun.l, 1);
    }

    public static String getDifficultyString() {
        return atv.w().u.c(aun.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : atv.w().q.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(atv.w().q, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n) {
        return yc.g[n].m();
    }

    public static List<int[]> getEnchantments(ye ye2) {
        cg cg2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (ye2 != null && (cg2 = ye2.r()) != null) {
            for (int i = 0; i < cg2.c(); ++i) {
                short s = ((by)cg2.b(i)).d("id");
                short s2 = ((by)cg2.b(i)).d("lvl");
                int[] nArray = new int[]{s, s2};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(ye ye2, int n, int n2) {
        if (n < aau.b.length && aau.b[n] != null) {
            ye2.a(aau.b[n], n2);
            return true;
        }
        return false;
    }

    public static by getTagCompoundWithCreate(ye ye2, String string) {
        by by2;
        if (ye2.e == null) {
            ye2.e = new by();
        }
        if (!ye2.e.b(string)) {
            by2 = new by();
            ye2.e.a(string, by2);
        } else {
            by2 = ye2.e.l(string);
        }
        return by2;
    }

    public static jv getPlayer() {
        return MinecraftServer.F().af().f(atv.w().h.bu);
    }

    public static void fastTransfer(int n, int n2, uy uy2) {
        atv atv2 = atv.w();
        ye ye2 = TMIUtils.getHeldItem();
        atv2.c.a(uy2.d, n, n2, 0, (uf)atv2.h);
        int n3 = uy2.c.size() - 36;
        boolean bl = n < n3;
        int n4 = 0;
        int n5 = n3;
        int n6 = n3 - 1;
        int n7 = uy2.c.size();
        if (bl) {
            n4 = n3;
            n5 = uy2.c.size();
            n6 = -1;
            n7 = n3;
        }
        boolean bl2 = true;
        while (n4 < n5 && n6 < n7) {
            ye ye3;
            we we2 = (we)uy2.c.get(n4);
            if (we2 != null && (ye3 = we2.d()) != null && ye3.d == ye2.d && ye3.j() == ye2.j()) {
                we we3 = bl2 ? (we)uy2.c.get(n) : (we)uy2.c.get(n6);
                if (we3 == null) {
                    ++n6;
                    bl2 = false;
                    continue;
                }
                ye ye4 = we3.d();
                if (ye4 == null) {
                    we3.c(ye3);
                    we2.c((ye)null);
                } else if (ye4.d == ye3.d && ye4.j() == ye3.j()) {
                    int n8 = ye3.b + ye4.b;
                    int n9 = yc.g[ye3.d].m();
                    int n10 = n8 - n9;
                    if (n10 > 0) {
                        ye4.b = n9;
                        ye3.b = n10;
                        ++n6;
                        bl2 = false;
                        continue;
                    }
                    ye4.b = n8;
                    we2.c((ye)null);
                } else {
                    ++n6;
                    bl2 = false;
                    continue;
                }
            }
            ++n4;
        }
    }

    public static boolean isEnchantmentNormallyPossible(aau aau2, yc yc2) {
        return aau2.A.a(yc2) || yc2.cv == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(aau aau2, ye ye2) {
        return aau2.A.a(yc.g[ye2.d]) || ye2.d == TMIItemInfo.addItemOffset(147);
    }

    public static List<aau> getPossibleEnchantments(yc yc2) {
        if (yc2.c() > 0) {
            ArrayList<aau> arrayList = new ArrayList<aau>();
            for (aau aau2 : aau.b) {
                if (aau2 == null || !aau2.A.a(yc2)) continue;
                arrayList.add(aau2);
            }
            return arrayList;
        }
        return new ArrayList<aau>();
    }

    public static void dumpItemList() {
        try {
            File file = new File(atv.w().x, "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (ye ye2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + ye2.d + ":" + ye2.j() + " " + TMIUtils.getValidItemDisplayName(ye2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

