/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.effective.client.world;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ladysnake.effective.client.Effective;
import ladysnake.effective.client.EffectiveConfig;
import ladysnake.effective.client.sound.WaterfallSoundInstance;
import net.minecraft.class_1113;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_638;

public class WaterfallCloudGenerators {
    public static final List<class_2338> generators = new ArrayList<class_2338>();
    public static final Object2IntMap<class_2338> particlesToSpawn = new Object2IntOpenHashMap();
    private static class_1937 lastWorld = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGenerator(class_3610 state, class_2338 pos) {
        if (pos == null || !EffectiveConfig.generateCascades || state.method_15772() != class_3612.field_15909 || generators.contains(pos)) {
            return;
        }
        if (WaterfallCloudGenerators.shouldCauseWaterfall((class_1922)class_310.method_1551().field_1687, pos, state)) {
            List<class_2338> list = generators;
            synchronized (list) {
                generators.add(new class_2338((class_2382)pos));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (client.method_1493() || world == null) {
            return;
        }
        List<class_2338> list = generators;
        synchronized (list) {
            if (world != lastWorld) {
                generators.clear();
                particlesToSpawn.clear();
                lastWorld = world;
            }
            WaterfallCloudGenerators.tickParticles((class_1937)world);
            if (world.method_8510() % 3L != 0L) {
                return;
            }
            generators.forEach(arg_0 -> WaterfallCloudGenerators.lambda$tick$0(client, (class_1937)world, arg_0));
            generators.removeIf(arg_0 -> WaterfallCloudGenerators.lambda$tick$1((class_1937)world, arg_0));
        }
    }

    private static void tickParticles(class_1937 world) {
        for (class_2338 pos : particlesToSpawn.keySet()) {
            if (pos == null) continue;
            particlesToSpawn.computeInt((Object)pos, (blockPos, integer) -> integer - 1);
            WaterfallCloudGenerators.addWaterfallCloud((class_1936)world, pos);
        }
        particlesToSpawn.values().removeIf(integer -> integer < 0);
    }

    private static boolean shouldCauseWaterfall(class_1922 world, class_2338 pos, class_3610 fluidState) {
        if (!EffectiveConfig.generateCascades || fluidState.method_15772() != class_3612.field_15909) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (Math.sqrt(pos.method_10262((class_2382)client.field_1724.method_24515())) > (double)((Integer)client.field_1690.method_42503().method_41753() * 32)) {
            return false;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (world.method_8316((class_2338)mutable.method_25505((class_2382)pos, class_2350.field_11033)).method_15772() != class_3612.field_15910) {
            return false;
        }
        boolean foundAir = false;
        block0: for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2680 blockState;
                if (x == 0 && z == 0 || !(blockState = world.method_8320((class_2338)mutable.method_10103(pos.method_10263() + x, pos.method_10264(), pos.method_10260() + z))).method_26215()) continue;
                foundAir = true;
                continue block0;
            }
        }
        if (!foundAir) {
            return false;
        }
        return Arrays.stream(class_2350.values()).anyMatch(direction -> direction.method_10166() != class_2350.class_2351.field_11052 && world.method_8316((class_2338)mutable.method_10103(pos.method_10263() + direction.method_10148(), pos.method_10264() - 1, pos.method_10260() + direction.method_10165())).method_15772() == class_3612.field_15910);
    }

    public static void addWaterfallCloud(class_1936 world, class_2338 pos) {
        if (pos != null) {
            double offsetX = world.method_8409().method_43059() / 5.0;
            double offsetZ = world.method_8409().method_43059() / 5.0;
            world.method_8406((class_2394)Effective.WATERFALL_CLOUD, (double)pos.method_10263() + 0.5 + offsetX, (double)((float)pos.method_10264() + world.method_8409().method_43057()), (double)pos.method_10260() + 0.5 + offsetZ, (double)(world.method_8409().method_43057() / 5.0f) * Math.signum(offsetX), (double)(world.method_8409().method_43057() / 5.0f), (double)(world.method_8409().method_43057() / 5.0f) * Math.signum(offsetZ));
        }
    }

    public static void scheduleParticleTick(class_2338 pos, int ticks) {
        if (pos != null) {
            particlesToSpawn.put((Object)pos, ticks);
        }
    }

    private static /* synthetic */ boolean lambda$tick$1(class_1937 world, class_2338 blockPos) {
        return blockPos == null || !WaterfallCloudGenerators.shouldCauseWaterfall((class_1922)world, blockPos, world.method_8316(blockPos));
    }

    private static /* synthetic */ void lambda$tick$0(class_310 client, class_1937 world, class_2338 blockPos) {
        if (blockPos == null) {
            return;
        }
        WaterfallCloudGenerators.scheduleParticleTick(blockPos, 6);
        float distance = class_3532.method_15355((float)((float)client.field_1724.method_24515().method_10262((class_2382)blockPos)));
        if (distance > (float)EffectiveConfig.cascadeSoundDistanceBlocks || EffectiveConfig.cascadeSoundsVolumeMultiplier == 0 || EffectiveConfig.cascadeSoundDistanceBlocks == 0) {
            return;
        }
        if (world.field_9229.method_43048(200) == 0) {
            client.method_1483().method_4872((class_1113)WaterfallSoundInstance.ambient(Effective.AMBIENCE_WATERFALL, 1.2f + world.field_9229.method_43057() / 10.0f, blockPos, EffectiveConfig.cascadeSoundDistanceBlocks), (int)(distance / 2.0f));
        }
    }
}

