/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.level;

import bottomtextdanny.effective_fg.EffectiveFg;
import bottomtextdanny.effective_fg.registry.ParticleRegistry;
import bottomtextdanny.effective_fg.registry.SoundEventRegistry;
import bottomtextdanny.effective_fg.sound.LinearFadeSound;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WaterfallCloudGenerators {
    public static final Set<BlockPos> GENERATORS = new HashSet<BlockPos>();
    private static boolean resolvingWaterfalls;
    private static Level levelO;

    public static void addGenerator(BlockPos blockPos) {
        GENERATORS.add(blockPos);
    }

    public static void tick() {
        if (!((Boolean)EffectiveFg.config().cascades.get()).booleanValue()) {
            GENERATORS.clear();
            return;
        }
        Minecraft instance = Minecraft.m_91087_();
        ClientLevel level = instance.f_91073_;
        Camera camera = instance.m_91290_().f_114358_;
        if (instance.m_91104_() || level == null || camera == null) {
            return;
        }
        BlockPos pos = camera.m_90588_();
        if (level != levelO) {
            GENERATORS.clear();
        }
        levelO = level;
        Random random = level.f_46441_;
        SoundManager soundManager = instance.m_91106_();
        float cascadeRange = ((Double)EffectiveFg.config().cascadeSoundRange.get()).floatValue();
        float cascadeRangeSquared = cascadeRange * cascadeRange;
        resolvingWaterfalls = true;
        int maxGeneratorDistance = Mth.m_144944_((int)((Math.max(instance.f_91066_.f_92106_, instance.f_91066_.f_193768_) + 1) * 16));
        int[] soundCounter = new int[]{1};
        GENERATORS.removeIf(blockPos -> {
            int z;
            int x = pos.m_123341_() - blockPos.m_123341_();
            int dist = x * x + (z = pos.m_123343_() - blockPos.m_123343_()) * z;
            if (dist >= maxGeneratorDistance) {
                return true;
            }
            BlockState stateUp = level.m_8055_(blockPos.m_142082_(0, 1, 0));
            BlockState stateDoubleUp = level.m_8055_(blockPos.m_142082_(0, 2, 0));
            BlockState state = level.m_8055_(blockPos);
            return state.m_60734_() != Blocks.f_49990_ || state.m_60734_() != Blocks.f_49990_ || stateUp.m_60734_() != Blocks.f_49990_ || stateUp.m_60819_().m_76170_() || !(stateUp.m_60819_().m_76182_() >= 0.77f) || !stateDoubleUp.m_60713_(Blocks.f_49990_) || stateDoubleUp.m_60819_().m_76170_();
        });
        List<BlockPos> generators = GENERATORS.stream().sorted(Comparator.comparingDouble(bp -> bp.m_123331_((Vec3i)pos))).collect(Collectors.toList());
        generators.forEach(blockPos -> {
            double dist = blockPos.m_123331_((Vec3i)pos);
            double offsetX = random.nextDouble() / 5.0 + 0.2;
            offsetX = random.nextBoolean() ? offsetX : -offsetX;
            double offsetZ = random.nextDouble() / 5.0 + 0.2;
            double d = offsetZ = random.nextBoolean() ? offsetZ : -offsetZ;
            if ((int)level.m_46467_() % (soundCounter[0] * 7) == 0 && dist < (double)cascadeRangeSquared) {
                soundManager.m_120367_((SoundInstance)new LinearFadeSound((SoundEvent)SoundEventRegistry.AMBIENCE_WATERFALL.get(), SoundSource.AMBIENT, cascadeRange, 1.0f, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
            }
            if ((double)random.nextFloat() < (Double)EffectiveFg.config().cascadeParticleAmountMultiplier.get()) {
                level.m_7106_((ParticleOptions)ParticleRegistry.WATERFALL_CLOUD.get(), (double)blockPos.m_123341_() + 0.5 + offsetX, (double)blockPos.m_123342_() + 1.0 + (double)random.nextFloat(), (double)blockPos.m_123343_() + 0.5 + offsetZ, (double)random.nextFloat() / 5.0 * Math.signum(offsetX), (double)random.nextFloat() / 5.0, (double)random.nextFloat() / 5.0 * Math.signum(offsetZ));
            }
            soundCounter[0] = soundCounter[0] + (random.nextInt(2) + 1);
        });
        resolvingWaterfalls = false;
    }

    public static boolean isResolvingWaterfalls() {
        return resolvingWaterfalls;
    }

    static {
        levelO = null;
    }
}

