/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.mixin;

import bottomtextdanny.effective_fg.EffectiveFg;
import bottomtextdanny.effective_fg.registry.ParticleRegistry;
import bottomtextdanny.effective_fg.util.EffectUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaterFluid.class})
public abstract class WaterFluidMixin {
    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    protected void animateTick(Level level, BlockPos pos, FluidState fluidState, Random random, CallbackInfo ci) {
        if (EffectUtil.shouldSplashie(level, pos.m_7494_(), fluidState)) {
            Vec3 vec3d = fluidState.m_76179_((BlockGetter)level, pos);
            int amount = random.nextInt((Integer)EffectiveFg.config().flowingWaterSplashiesAbundance.get());
            for (int i = 0; i <= amount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5 + random.nextGaussian() / 2.0, (double)((float)(pos.m_123342_() + 1) + random.nextFloat()), (double)pos.m_123343_() + 0.5 + random.nextGaussian() / 2.0, vec3d.f_82479_ * (double)random.nextFloat(), (double)(random.nextFloat() / 10.0f), vec3d.f_82481_ * (double)random.nextFloat());
            }
        }
        if (EffectUtil.shouldRipple(level, pos)) {
            int amount = random.nextInt((Integer)EffectiveFg.config().rainRippleAbundance.get());
            for (int i = 0; i <= amount; ++i) {
                level.m_7106_((ParticleOptions)ParticleRegistry.RIPPLE.get(), (double)pos.m_123341_() + 0.5 + random.nextGaussian() / 2.0, (double)((float)pos.m_123342_() + 0.9f), (double)pos.m_123343_() + 0.5 + random.nextGaussian() / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

