/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.particle;

import bottomtextdanny.effective_fg.EffectiveFg;
import bottomtextdanny.effective_fg.model.SplashBottomModel;
import bottomtextdanny.effective_fg.model.SplashModel;
import bottomtextdanny.effective_fg.model.SplashRimModel;
import bottomtextdanny.effective_fg.particletype.SplashParticleOptions;
import bottomtextdanny.effective_fg.registry.ParticleRegistry;
import bottomtextdanny.effective_fg.util.ParticleModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class SplashParticle
extends TextureSheetParticle {
    static final ParticleModel WAVE_MODEL = new SplashModel(56);
    static final ParticleModel WAVE_RIM_MODEL = new SplashRimModel();
    static final ParticleModel WAVE_BOTTOM_MODEL = new SplashBottomModel(56);
    private final SpriteSet sprites;
    private float widthMultiplier;
    private final float heightMultiplier;
    private final int wave1End;
    private final int wave2Start;
    private final int wave2End;
    private final float r;
    private final float g;
    private final float b;

    protected SplashParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, float width, float height) {
        super(level, x, y, z);
        this.sprites = spriteSet;
        this.f_107226_ = 0.0f;
        this.widthMultiplier = width;
        this.heightMultiplier = height;
        int waterColor = BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
        this.r = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        this.g = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        this.b = (float)(waterColor & 0xFF) / 255.0f;
        this.wave1End = 10 + Math.round(this.widthMultiplier * 1.2f);
        this.wave2Start = 6 + Math.round(this.widthMultiplier * 0.7f);
        this.wave2End = 20 + Math.round(this.widthMultiplier * 2.4f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        block4: {
            float widthMultiplier;
            block3: {
                this.f_107209_ = this.f_107212_;
                this.f_107210_ = this.f_107213_;
                this.f_107211_ = this.f_107214_;
                this.widthMultiplier *= 1.03f;
                widthMultiplier = this.widthMultiplier;
                if (this.f_107224_++ >= this.wave2End) {
                    this.m_107274_();
                }
                if (this.f_107224_ != 1) break block3;
                int i = 0;
                while ((float)i < widthMultiplier * 10.0f) {
                    this.f_107208_.m_7106_((ParticleOptions)ParticleRegistry.DROPLET.get(), this.f_107212_ + this.f_107223_.nextGaussian() * (double)widthMultiplier / 10.0, this.f_107213_, this.f_107214_ + this.f_107223_.nextGaussian() * (double)widthMultiplier / 10.0, this.f_107223_.nextGaussian() / 10.0 * (double)widthMultiplier / 2.5, (double)(this.f_107223_.nextFloat() / 10.0f + this.heightMultiplier / 2.8f), this.f_107223_.nextGaussian() / 10.0 * (double)widthMultiplier / 2.5);
                    ++i;
                }
                break block4;
            }
            if (this.f_107224_ != this.wave2Start) break block4;
            int i = 0;
            while ((float)i < widthMultiplier * 5.0f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleRegistry.DROPLET.get(), this.f_107212_ + this.f_107223_.nextGaussian() * (double)widthMultiplier / 10.0 * 0.5, this.f_107213_, this.f_107214_ + this.f_107223_.nextGaussian() * (double)widthMultiplier / 10.0 * 0.5, this.f_107223_.nextGaussian() / 10.0 * (double)widthMultiplier / 5.0, (double)(this.f_107223_.nextFloat() / 10.0f + this.heightMultiplier / 2.2f), this.f_107223_.nextGaussian() / 10.0 * (double)widthMultiplier / 5.0);
                ++i;
            }
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        float maxV;
        float minV;
        float maxU;
        float minU;
        float yOffset = 0.001f;
        float bottomYOffset = -0.1f;
        int light = this.m_6355_(tickDelta);
        Vec3 vec3d = camera.m_90583_();
        float viewX = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float viewY = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_()) + 0.001f;
        float viewZ = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        PoseStack matrixStack = new PoseStack();
        float widthMultiplier = this.widthMultiplier;
        float heightMultiplier = this.heightMultiplier;
        if (this.f_107224_ <= this.wave1End) {
            int frameForFirstSplash = Math.round((float)this.f_107224_ / (float)this.wave1End * 12.0f);
            this.setSprite(frameForFirstSplash);
            minU = this.m_5970_();
            maxU = this.m_5952_();
            minV = this.m_5951_();
            maxV = this.m_5950_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)viewX, (double)viewY, (double)viewZ);
            matrixStack.m_85841_(widthMultiplier, -heightMultiplier, widthMultiplier);
            WAVE_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, this.r, this.g, this.b, ((Double)EffectiveFg.config().waterSplashAlpha.get()).floatValue());
            WAVE_RIM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85851_();
            matrixStack.m_85837_((double)viewX, (double)viewY, (double)viewZ);
            matrixStack.m_85841_(widthMultiplier * 1.2f, -heightMultiplier, widthMultiplier * 1.2f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85851_();
            matrixStack.m_85837_((double)viewX, (double)(viewY + -0.1f), (double)viewZ);
            matrixStack.m_85841_(widthMultiplier * 1.2f, -heightMultiplier, widthMultiplier * 1.2f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        if (this.f_107224_ >= this.wave2Start) {
            int frameForSecondSplash = Math.round((float)(this.f_107224_ - this.wave2Start) / (float)(this.wave2End - this.wave2Start) * 12.0f);
            this.setSprite(frameForSecondSplash);
            minU = this.m_5970_();
            maxU = this.m_5952_();
            minV = this.m_5951_();
            maxV = this.m_5950_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)viewX, (double)viewY, (double)viewZ);
            matrixStack.m_85836_();
            matrixStack.m_85841_(widthMultiplier * 0.5f, -heightMultiplier * 2.0f, widthMultiplier * 0.5f);
            WAVE_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, this.r, this.g, this.b, ((Double)EffectiveFg.config().waterSplashAlpha.get()).floatValue());
            WAVE_RIM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85841_(widthMultiplier * 0.6f, -heightMultiplier * 2.0f, widthMultiplier * 0.6f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)-0.1f, 0.0);
            matrixStack.m_85841_(widthMultiplier * 0.6f, -heightMultiplier * 2.0f, widthMultiplier * 0.6f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85849_();
        }
    }

    public void setSprite(int index) {
        if (!this.f_107220_) {
            this.m_108337_(this.sprites.m_5819_(index, 12));
        }
    }

    public static class Factory
    implements ParticleProvider<SplashParticleOptions> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteProvider) {
            this.spriteSet = spriteProvider;
        }

        @Nullable
        public Particle createParticle(SplashParticleOptions parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SplashParticle(level, x, y, z, this.spriteSet, parameters.width, parameters.height);
        }
    }
}

