/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.registry;

import bottomtextdanny.effective_fg.particle.DropletParticle;
import bottomtextdanny.effective_fg.particle.LavaSplashParticle;
import bottomtextdanny.effective_fg.particle.RippleParticle;
import bottomtextdanny.effective_fg.particle.SplashParticle;
import bottomtextdanny.effective_fg.particle.WaterfallCloudParticle;
import bottomtextdanny.effective_fg.particletype.SplashParticleOptions;
import com.mojang.serialization.Codec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="effective_fg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ParticleRegistry {
    public static final DeferredRegister<ParticleType<?>> ENTRIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"effective_fg");
    public static final RegistryObject<SimpleParticleType> DROPLET = ParticleRegistry.defer("droplet");
    public static final RegistryObject<ParticleType<SplashParticleOptions>> LAVA_SPLASH = ParticleRegistry.deferSplash("lava_splash");
    public static final RegistryObject<SimpleParticleType> RIPPLE = ParticleRegistry.defer("ripple");
    public static final RegistryObject<ParticleType<SplashParticleOptions>> SPLASH = ParticleRegistry.deferSplash("splash");
    public static final RegistryObject<SimpleParticleType> WATERFALL_CLOUD = ParticleRegistry.defer("waterfall_cloud");

    private static RegistryObject<SimpleParticleType> defer(String name) {
        return ENTRIES.register(name, () -> new SimpleParticleType(true));
    }

    private static RegistryObject<ParticleType<SplashParticleOptions>> deferSplash(String name) {
        return ENTRIES.register(name, () -> new ParticleType<SplashParticleOptions>(true, SplashParticleOptions.DESERIALIZER){
            private final Codec<SplashParticleOptions> codec = SplashParticleOptions.codec(this);

            public Codec<SplashParticleOptions> m_7652_() {
                return this.codec;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        if (DROPLET.isPresent()) {
            particleEngine.m_107378_((ParticleType)DROPLET.get(), DropletParticle.Factory::new);
        }
        if (RIPPLE.isPresent()) {
            particleEngine.m_107378_((ParticleType)RIPPLE.get(), RippleParticle.Factory::new);
        }
        if (LAVA_SPLASH.isPresent()) {
            particleEngine.m_107378_((ParticleType)LAVA_SPLASH.get(), LavaSplashParticle.Factory::new);
        }
        if (SPLASH.isPresent()) {
            particleEngine.m_107378_((ParticleType)SPLASH.get(), SplashParticle.Factory::new);
        }
        if (WATERFALL_CLOUD.isPresent()) {
            particleEngine.m_107378_((ParticleType)WATERFALL_CLOUD.get(), WaterfallCloudParticle.Factory::new);
        }
    }
}

