/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.util;

import bottomtextdanny.effective_fg.EffectiveFg;
import bottomtextdanny.effective_fg.registry.SoundEventRegistry;
import bottomtextdanny.effective_fg.sound.LinearFadeSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;

public final class EffectUtil {
    public static float splashWidth(Entity entity) {
        return entity.m_20205_() * 2.0f;
    }

    public static float splashHeight(float width, Entity entity) {
        return Math.max(-((float)entity.m_20184_().m_7098_()) * width, 0.0f);
    }

    public static void splashSound(double x, double y, double z, float mag) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new LinearFadeSound((SoundEvent)SoundEventRegistry.AMBIENCE_SPLASH.get(), SoundSource.AMBIENT, 20.0f + mag * 40.0f, mag * 10.0f, x, y, z));
    }

    public static void smallSplashSound(double x, double y, double z, float mag) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new LinearFadeSound((SoundEvent)SoundEventRegistry.AMBIENCE_SMALL_SPLASH.get(), SoundSource.AMBIENT, 10.0f + mag * 15.0f, mag * 5.0f, x, y, z));
    }

    public static boolean shouldSplashie(Level level, BlockPos pos, FluidState fluidState) {
        if ((Integer)EffectiveFg.config().flowingWaterSplashiesAbundance.get() > 0 && !fluidState.m_76170_() & fluidState.m_76182_() >= 0.77f) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutable.m_122159_((Vec3i)pos, direction);
                if (direction.m_122434_() == Direction.Axis.Y || !level.m_8055_((BlockPos)mutable).m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldRipple(Level level, BlockPos pos) {
        if ((Integer)EffectiveFg.config().rainRippleAbundance.get() > 0 && level.m_46758_(pos.m_7494_())) {
            FluidState fluidState = level.m_6425_(pos);
            return fluidState.m_76170_() && level.m_8055_(pos.m_7494_()).m_60795_();
        }
        return false;
    }

    private EffectUtil() {
    }
}

