/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.gson.JsonObject;
import com.wildfire.main.Breasts;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.ClientConfiguration;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.physics.BreastPhysics;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class GenderPlayer {
    public boolean needsSync;
    public final UUID uuid;
    private Gender gender;
    private float pBustSize = ((Float)ClientConfiguration.BUST_SIZE.getDefault()).floatValue();
    private boolean hurtSounds = (Boolean)ClientConfiguration.HURT_SOUNDS.getDefault();
    private boolean breastPhysics = (Boolean)ClientConfiguration.BREAST_PHYSICS.getDefault();
    private boolean armorBreastPhysics = (Boolean)ClientConfiguration.BREAST_PHYSICS_ARMOR.getDefault();
    private float bounceMultiplier = ((Float)ClientConfiguration.BOUNCE_MULTIPLIER.getDefault()).floatValue();
    private float floppyMultiplier = ((Float)ClientConfiguration.FLOPPY_MULTIPLIER.getDefault()).floatValue();
    public boolean lockSettings = false;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private boolean showBreastsInArmor = (Boolean)ClientConfiguration.SHOW_IN_ARMOR.getDefault();
    private final ClientConfiguration cfg;
    private final BreastPhysics lBreastPhysics = new BreastPhysics(this);
    private final BreastPhysics rBreastPhysics = new BreastPhysics(this);
    private final Breasts breasts = new Breasts();

    public GenderPlayer(UUID uuid) {
        this(uuid, (Gender)((Object)ClientConfiguration.GENDER.getDefault()));
    }

    public GenderPlayer(UUID uuid, Gender gender) {
        this.uuid = uuid;
        this.gender = gender;
        this.cfg = new ClientConfiguration("WildfireGender", this.uuid.toString());
        this.cfg.set(ClientConfiguration.USERNAME, this.uuid);
        this.cfg.setDefault(ClientConfiguration.GENDER);
        this.cfg.setDefault(ClientConfiguration.BUST_SIZE);
        this.cfg.setDefault(ClientConfiguration.HURT_SOUNDS);
        this.cfg.setDefault(ClientConfiguration.BREASTS_OFFSET_X);
        this.cfg.setDefault(ClientConfiguration.BREASTS_OFFSET_Y);
        this.cfg.setDefault(ClientConfiguration.BREASTS_OFFSET_Z);
        this.cfg.setDefault(ClientConfiguration.BREASTS_UNIBOOB);
        this.cfg.setDefault(ClientConfiguration.BREASTS_CLEAVAGE);
        this.cfg.setDefault(ClientConfiguration.BREAST_PHYSICS);
        this.cfg.setDefault(ClientConfiguration.BREAST_PHYSICS_ARMOR);
        this.cfg.setDefault(ClientConfiguration.SHOW_IN_ARMOR);
        this.cfg.setDefault(ClientConfiguration.BOUNCE_MULTIPLIER);
        this.cfg.setDefault(ClientConfiguration.FLOPPY_MULTIPLIER);
        this.cfg.finish();
    }

    public ClientConfiguration getConfig() {
        return this.cfg;
    }

    private <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(ClientConfiguration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(ClientConfiguration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(ClientConfiguration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean hasBreastPhysics() {
        return this.breastPhysics;
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(ClientConfiguration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    public boolean hasArmorBreastPhysics() {
        return this.armorBreastPhysics;
    }

    public boolean updateArmorBreastPhysics(boolean value) {
        return this.updateValue(ClientConfiguration.BREAST_PHYSICS_ARMOR, value, v -> {
            this.armorBreastPhysics = v;
        });
    }

    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(ClientConfiguration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public float getBounceMultiplier() {
        return (float)Math.round(this.getBounceMultiplierRaw() * 3.0f * 100.0f) / 100.0f;
    }

    public float getBounceMultiplierRaw() {
        return this.bounceMultiplier;
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(ClientConfiguration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(ClientConfiguration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public static JsonObject toJsonObject(GenderPlayer plr) {
        JsonObject obj = new JsonObject();
        ClientConfiguration.USERNAME.save(obj, plr.uuid);
        ClientConfiguration.GENDER.save(obj, plr.getGender());
        ClientConfiguration.BUST_SIZE.save(obj, Float.valueOf(plr.getBustSize()));
        ClientConfiguration.HURT_SOUNDS.save(obj, plr.hasHurtSounds());
        ClientConfiguration.BREAST_PHYSICS.save(obj, plr.hasBreastPhysics());
        ClientConfiguration.BREAST_PHYSICS_ARMOR.save(obj, plr.hasArmorBreastPhysics());
        ClientConfiguration.SHOW_IN_ARMOR.save(obj, plr.showBreastsInArmor());
        ClientConfiguration.BOUNCE_MULTIPLIER.save(obj, Float.valueOf(plr.getBounceMultiplierRaw()));
        ClientConfiguration.FLOPPY_MULTIPLIER.save(obj, Float.valueOf(plr.getFloppiness()));
        Breasts breasts = plr.getBreasts();
        ClientConfiguration.BREASTS_OFFSET_X.save(obj, Float.valueOf(breasts.getXOffset()));
        ClientConfiguration.BREASTS_OFFSET_Y.save(obj, Float.valueOf(breasts.getYOffset()));
        ClientConfiguration.BREASTS_OFFSET_Z.save(obj, Float.valueOf(breasts.getZOffset()));
        ClientConfiguration.BREASTS_UNIBOOB.save(obj, breasts.isUniboob());
        ClientConfiguration.BREASTS_CLEAVAGE.save(obj, Float.valueOf(breasts.getCleavage()));
        return obj;
    }

    public static GenderPlayer fromJsonObject(JsonObject obj) {
        GenderPlayer plr = new GenderPlayer((UUID)ClientConfiguration.USERNAME.read(obj));
        plr.updateGender((Gender)((Object)ClientConfiguration.GENDER.read(obj)));
        plr.updateBustSize(((Float)ClientConfiguration.BUST_SIZE.read(obj)).floatValue());
        plr.updateHurtSounds((Boolean)ClientConfiguration.HURT_SOUNDS.read(obj));
        plr.updateBreastPhysics((Boolean)ClientConfiguration.BREAST_PHYSICS.read(obj));
        plr.updateArmorBreastPhysics((Boolean)ClientConfiguration.BREAST_PHYSICS_ARMOR.read(obj));
        plr.updateShowBreastsInArmor((Boolean)ClientConfiguration.SHOW_IN_ARMOR.read(obj));
        plr.updateBounceMultiplier(((Float)ClientConfiguration.BOUNCE_MULTIPLIER.read(obj)).floatValue());
        plr.updateFloppiness(((Float)ClientConfiguration.FLOPPY_MULTIPLIER.read(obj)).floatValue());
        Breasts breasts = plr.getBreasts();
        breasts.updateXOffset(((Float)ClientConfiguration.BREASTS_OFFSET_X.read(obj)).floatValue());
        breasts.updateYOffset(((Float)ClientConfiguration.BREASTS_OFFSET_Y.read(obj)).floatValue());
        breasts.updateZOffset(((Float)ClientConfiguration.BREASTS_OFFSET_Z.read(obj)).floatValue());
        breasts.updateUniboob((Boolean)ClientConfiguration.BREASTS_UNIBOOB.read(obj));
        breasts.updateCleavage(((Float)ClientConfiguration.BREASTS_CLEAVAGE.read(obj)).floatValue());
        return plr;
    }

    public static GenderPlayer loadCachedPlayer(UUID uuid, boolean markForSync) {
        GenderPlayer plr = WildfireGender.getPlayerById(uuid);
        if (plr != null) {
            plr.lockSettings = false;
            plr.syncStatus = SyncStatus.CACHED;
            ClientConfiguration config = plr.getConfig();
            plr.updateGender(config.get(ClientConfiguration.GENDER));
            plr.updateBustSize(config.get(ClientConfiguration.BUST_SIZE).floatValue());
            plr.updateHurtSounds(config.get(ClientConfiguration.HURT_SOUNDS));
            plr.updateBreastPhysics(config.get(ClientConfiguration.BREAST_PHYSICS));
            plr.updateArmorBreastPhysics(config.get(ClientConfiguration.BREAST_PHYSICS_ARMOR));
            plr.updateShowBreastsInArmor(config.get(ClientConfiguration.SHOW_IN_ARMOR));
            plr.updateBounceMultiplier(config.get(ClientConfiguration.BOUNCE_MULTIPLIER).floatValue());
            plr.updateFloppiness(config.get(ClientConfiguration.FLOPPY_MULTIPLIER).floatValue());
            Breasts breasts = plr.getBreasts();
            breasts.updateXOffset(config.get(ClientConfiguration.BREASTS_OFFSET_X).floatValue());
            breasts.updateYOffset(config.get(ClientConfiguration.BREASTS_OFFSET_Y).floatValue());
            breasts.updateZOffset(config.get(ClientConfiguration.BREASTS_OFFSET_Z).floatValue());
            breasts.updateUniboob(config.get(ClientConfiguration.BREASTS_UNIBOOB));
            breasts.updateCleavage(config.get(ClientConfiguration.BREASTS_CLEAVAGE).floatValue());
            if (markForSync) {
                plr.needsSync = true;
            }
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        ClientConfiguration config = plr.getConfig();
        config.set(ClientConfiguration.USERNAME, plr.uuid);
        config.set(ClientConfiguration.GENDER, plr.getGender());
        config.set(ClientConfiguration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        config.set(ClientConfiguration.HURT_SOUNDS, plr.hasHurtSounds());
        config.set(ClientConfiguration.BREAST_PHYSICS, plr.hasBreastPhysics());
        config.set(ClientConfiguration.BREAST_PHYSICS_ARMOR, plr.hasArmorBreastPhysics());
        config.set(ClientConfiguration.SHOW_IN_ARMOR, plr.showBreastsInArmor());
        config.set(ClientConfiguration.BOUNCE_MULTIPLIER, Float.valueOf(plr.getBounceMultiplierRaw()));
        config.set(ClientConfiguration.FLOPPY_MULTIPLIER, Float.valueOf(plr.getFloppiness()));
        config.set(ClientConfiguration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        config.set(ClientConfiguration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        config.set(ClientConfiguration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        config.set(ClientConfiguration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        config.set(ClientConfiguration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        config.save();
        plr.needsSync = true;
    }

    public Breasts getBreasts() {
        return this.breasts;
    }

    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public static enum Gender {
        FEMALE((Component)new TranslatableComponent("wildfire_gender.label.female").m_130940_(ChatFormatting.LIGHT_PURPLE)),
        MALE((Component)new TranslatableComponent("wildfire_gender.label.male").m_130940_(ChatFormatting.BLUE)),
        OTHER((Component)new TranslatableComponent("wildfire_gender.label.other").m_130940_(ChatFormatting.GREEN));

        private final Component name;

        private Gender(Component name) {
            this.name = name;
        }

        public Component getDisplayName() {
            return this.name;
        }

        public boolean hasFemaleHurtSounds() {
            return this == FEMALE;
        }

        public boolean canHaveBreasts() {
            return this != MALE;
        }
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

