/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.api.IGenderArmor;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.render.GenderLayer;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.Connection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkHooks;

public class WildfireEventHandler {
    public static final KeyMapping toggleEditGUI = new KeyMapping("key.wildfire_gender.gender_menu", 71, "category.wildfire_gender.generic");
    private int toastTick = 0;
    private boolean showedToast = false;
    int timer = 0;
    private final Set<SoundEvent> playerHurtSounds = Set.of(SoundEvents.f_12323_, SoundEvents.f_12324_, SoundEvents.f_144205_, SoundEvents.f_12273_, SoundEvents.f_12274_);

    @SubscribeEvent
    public void onGUI(TickEvent.ClientTickEvent evt) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            WildfireGender.CLOTHING_PLAYERS.clear();
        }
        boolean isVanillaServer = true;
        try {
            isVanillaServer = NetworkHooks.isVanillaConnection((Connection)Minecraft.m_91087_().m_91403_().m_6198_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isVanillaServer) {
            ++this.timer;
            if (this.timer >= 5) {
                try {
                    GenderPlayer aPlr = WildfireGender.getPlayerById(Minecraft.m_91087_().f_91074_.m_142081_());
                    if (aPlr == null || !aPlr.needsSync) {
                        return;
                    }
                    PacketSendGenderInfo.send(aPlr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timer = 0;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.side.isClient()) {
            GenderPlayer aPlr = WildfireGender.getPlayerById(evt.player.m_142081_());
            if (aPlr == null) {
                return;
            }
            IGenderArmor armor = WildfireHelper.getArmorConfig(evt.player.m_6844_(EquipmentSlot.CHEST));
            aPlr.getLeftBreastPhysics().update(evt.player, armor);
            aPlr.getRightBreastPhysics().update(evt.player, armor);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        if (toggleEditGUI.m_90857_() && WildfireGender.modEnabled) {
            WildfireGender.refreshAllGenders();
            Minecraft.m_91087_().m_91152_((Screen)new WildfirePlayerListScreen(Minecraft.m_91087_()));
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent evt) {
        AbstractClientPlayer plr;
        UUID uuid;
        GenderPlayer aPlr;
        Entity entity;
        if (evt.getWorld().f_46443_ && (entity = evt.getEntity()) instanceof AbstractClientPlayer && (aPlr = WildfireGender.getPlayerById(uuid = (plr = (AbstractClientPlayer)entity).m_142081_())) == null) {
            aPlr = new GenderPlayer(uuid);
            WildfireGender.CLOTHING_PLAYERS.put(uuid, aPlr);
            WildfireGender.loadGenderInfoAsync(uuid, uuid.equals(Minecraft.m_91087_().f_91074_.m_142081_()));
            WildfireGender.refreshAllGenders();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlaySound(PlaySoundAtEntityEvent event) {
        Entity entity;
        if (event.getSound() != null && this.playerHurtSounds.contains(event.getSound()) && (entity = event.getEntity()) instanceof Player) {
            Player p = (Player)entity;
            if (p.f_19853_.f_46443_) {
                event.setCanceled(true);
                SoundEvent soundEvent = event.getSound();
                if (p.f_20916_ == p.f_20917_ && p.f_20916_ > 0) {
                    GenderPlayer plr = WildfireGender.getPlayerById(p.m_142081_());
                    if (plr != null && plr.hasHurtSounds() && plr.getGender().hasFemaleHurtSounds()) {
                        soundEvent = Math.random() > 0.5 ? WildfireSounds.FEMALE_HURT1 : WildfireSounds.FEMALE_HURT2;
                    }
                } else if (p.m_142081_().equals(Minecraft.m_91087_().f_91074_.m_142081_())) {
                    return;
                }
                p.f_19853_.m_7785_(p.m_20185_(), p.m_20186_(), p.m_20189_(), soundEvent, event.getCategory(), event.getVolume(), event.getPitch(), false);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="wildfire_gender")
    private static class ClientModEventBusListeners {
        private ClientModEventBusListeners() {
        }

        @SubscribeEvent
        public static void entityLayers(EntityRenderersEvent.AddLayers event) {
            for (String skinName : event.getSkins()) {
                LivingEntityRenderer renderer = event.getSkin(skinName);
                if (renderer == null) continue;
                renderer.m_115326_((RenderLayer)new GenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
            }
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            ClientRegistry.registerKeyBinding((KeyMapping)toggleEditGUI);
            MinecraftForge.EVENT_BUS.register((Object)new WildfireEventHandler());
        }
    }
}

