/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.wildfire.api.IGenderArmor;
import com.wildfire.main.Breasts;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.physics.BreastPhysics;
import com.wildfire.render.WildfireModelRenderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.ForgeHooksClient;

public class GenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private WildfireModelRenderer.BreastModelBox lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
    private WildfireModelRenderer.OverlayModelBox lBreastWear = new WildfireModelRenderer.OverlayModelBox(true, 64, 64, 17, 34, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.OverlayModelBox rBreastWear = new WildfireModelRenderer.OverlayModelBox(false, 64, 64, 21, 34, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox lBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox rBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private float preBreastSize = 0.0f;
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = new HashMap<String, ResourceLocation>();

    public GenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> player) {
        super(player);
    }

    public ResourceLocation getArmorResource(AbstractClientPlayer entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource bufferSource, int packedLightIn, @Nonnull AbstractClientPlayer ent, float limbAngle, float limbDistance, float partialTicks, float animationProgress, float headYaw, float headPitch) {
        if (ent.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        try {
            float rightBounceRotation;
            float rTotalX;
            float rTotal;
            UUID playerUUID = ent.m_142081_();
            GenderPlayer plr = WildfireGender.getPlayerById(playerUUID);
            if (plr == null) {
                return;
            }
            ItemStack armorStack = ent.m_6844_(EquipmentSlot.CHEST);
            IGenderArmor genderArmor = WildfireHelper.getArmorConfig(armorStack);
            boolean isChestplateOccupied = genderArmor.coversBreasts();
            if (genderArmor.alwaysHidesBreasts() || !plr.showBreastsInArmor() && isChestplateOccupied) {
                return;
            }
            PlayerRenderer rend = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)ent);
            PlayerModel model = (PlayerModel)rend.m_7200_();
            Breasts breasts = plr.getBreasts();
            float breastOffsetX = (float)Math.round((float)Math.round(breasts.getXOffset() * 100.0f) / 100.0f * 10.0f) / 10.0f;
            float breastOffsetY = (float)(-Math.round((float)Math.round(breasts.getYOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
            float breastOffsetZ = (float)(-Math.round((float)Math.round(breasts.getZOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
            BreastPhysics leftBreastPhysics = plr.getLeftBreastPhysics();
            float bSize = leftBreastPhysics.getBreastSize(partialTicks);
            float outwardAngle = (float)Math.round(breasts.getCleavage() * 100.0f) / 100.0f * 100.0f;
            outwardAngle = Math.min(outwardAngle, 10.0f);
            float reducer = 0.0f;
            if (bSize < 0.84f) {
                reducer += 1.0f;
            }
            if (bSize < 0.72f) {
                reducer += 1.0f;
            }
            if (this.preBreastSize != bSize) {
                this.lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - breastOffsetZ - reducer), 0.0f, false);
                this.rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - breastOffsetZ - reducer), 0.0f, false);
                this.preBreastSize = bSize;
            }
            float overlayRed = 1.0f;
            float overlayGreen = 1.0f;
            float overlayBlue = 1.0f;
            float overlayAlpha = ent.m_20145_() ? 0.15f : 1.0f;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float lTotal = Mth.m_14179_((float)partialTicks, (float)leftBreastPhysics.getPreBounceY(), (float)leftBreastPhysics.getBounceY());
            float lTotalX = Mth.m_14179_((float)partialTicks, (float)leftBreastPhysics.getPreBounceX(), (float)leftBreastPhysics.getBounceX());
            float leftBounceRotation = Mth.m_14179_((float)partialTicks, (float)leftBreastPhysics.getPreBounceRotation(), (float)leftBreastPhysics.getBounceRotation());
            if (breasts.isUniboob()) {
                rTotal = lTotal;
                rTotalX = lTotalX;
                rightBounceRotation = leftBounceRotation;
            } else {
                BreastPhysics rightBreastPhysics = plr.getRightBreastPhysics();
                rTotal = Mth.m_14179_((float)partialTicks, (float)rightBreastPhysics.getPreBounceY(), (float)rightBreastPhysics.getBounceY());
                rTotalX = Mth.m_14179_((float)partialTicks, (float)rightBreastPhysics.getPreBounceX(), (float)rightBreastPhysics.getBounceX());
                rightBounceRotation = Mth.m_14179_((float)partialTicks, (float)rightBreastPhysics.getPreBounceRotation(), (float)rightBreastPhysics.getBounceRotation());
            }
            float breastSize = bSize * 1.5f;
            if (breastSize > 0.7f) {
                breastSize = 0.7f;
            }
            if (bSize > 0.7f) {
                breastSize = bSize;
            }
            if (breastSize < 0.02f) {
                return;
            }
            float zOff = 0.0625f - bSize * 0.0625f;
            breastSize = bSize + 0.5f * Math.abs(bSize - 0.7f) * 2.0f;
            float resistance = Mth.m_14036_((float)genderArmor.physicsResistance(), (float)0.0f, (float)1.0f);
            boolean breathingAnimation = resistance <= 0.5f && (!ent.m_5842_() || MobEffectUtil.m_19588_((LivingEntity)ent) || ent.f_19853_.m_8055_(new BlockPos(ent.m_20185_(), ent.m_20188_(), ent.m_20189_())).m_60713_(Blocks.f_50628_));
            boolean bounceEnabled = plr.hasBreastPhysics() && (!isChestplateOccupied || plr.hasArmorBreastPhysics() && resistance < 1.0f);
            int combineTex = LivingEntityRenderer.m_115338_((LivingEntity)ent, (float)0.0f);
            RenderType type = RenderType.m_110473_((ResourceLocation)rend.m_5478_(ent));
            this.renderBreastWithTransforms(ent, model.f_102810_, armorStack, matrixStack, bufferSource, type, packedLightIn, combineTex, overlayRed, overlayGreen, overlayBlue, overlayAlpha, bounceEnabled, lTotalX, lTotal, leftBounceRotation, breastSize, breastOffsetX, breastOffsetY, breastOffsetZ, zOff, outwardAngle, breasts.isUniboob(), isChestplateOccupied, breathingAnimation, true);
            this.renderBreastWithTransforms(ent, model.f_102810_, armorStack, matrixStack, bufferSource, type, packedLightIn, combineTex, overlayRed, overlayGreen, overlayBlue, overlayAlpha, bounceEnabled, rTotalX, rTotal, rightBounceRotation, breastSize, -breastOffsetX, breastOffsetY, breastOffsetZ, zOff, -outwardAngle, breasts.isUniboob(), isChestplateOccupied, breathingAnimation, false);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderBreastWithTransforms(AbstractClientPlayer entity, ModelPart body, ItemStack armorStack, PoseStack matrixStack, MultiBufferSource bufferSource, RenderType breastRenderType, int packedLightIn, int combineTex, float red, float green, float blue, float alpha, boolean bounceEnabled, float totalX, float total, float bounceRotation, float breastSize, float breastOffsetX, float breastOffsetY, float breastOffsetZ, float zOff, float outwardAngle, boolean uniboob, boolean isChestplateOccupied, boolean breathingAnimation, boolean left) {
        matrixStack.m_85836_();
        try {
            matrixStack.m_85837_((double)(body.f_104200_ * 0.0625f), (double)(body.f_104201_ * 0.0625f), (double)(body.f_104202_ * 0.0625f));
            if (body.f_104205_ != 0.0f) {
                matrixStack.m_85845_(new Quaternion(0.0f, 0.0f, body.f_104205_, false));
            }
            if (body.f_104204_ != 0.0f) {
                matrixStack.m_85845_(new Quaternion(0.0f, body.f_104204_, 0.0f, false));
            }
            if (body.f_104203_ != 0.0f) {
                matrixStack.m_85845_(new Quaternion(body.f_104203_, 0.0f, 0.0f, false));
            }
            if (bounceEnabled) {
                matrixStack.m_85837_((double)(totalX / 32.0f), 0.0, 0.0);
                matrixStack.m_85837_(0.0, (double)(total / 32.0f), 0.0);
            }
            matrixStack.m_85837_((double)(breastOffsetX * 0.0625f), (double)(0.05625f + breastOffsetY * 0.0625f), (double)(zOff - 0.125f + breastOffsetZ * 0.0625f));
            if (!uniboob) {
                matrixStack.m_85837_((double)(-0.125f * (float)(left ? 1 : -1)), 0.0, 0.0);
            }
            if (bounceEnabled) {
                matrixStack.m_85845_(new Quaternion(0.0f, bounceRotation, 0.0f, true));
            }
            if (!uniboob) {
                matrixStack.m_85837_((double)(0.125f * (float)(left ? 1 : -1)), 0.0, 0.0);
            }
            float rotationMultiplier = 0.0f;
            if (bounceEnabled) {
                matrixStack.m_85837_(0.0, (double)(-0.035f * breastSize), 0.0);
                rotationMultiplier = -total / 12.0f;
            }
            float totalRotation = breastSize + rotationMultiplier;
            if (!bounceEnabled) {
                totalRotation = breastSize;
            }
            if (totalRotation > breastSize + 0.2f) {
                totalRotation = breastSize + 0.2f;
            }
            totalRotation = Math.min(totalRotation, 1.0f);
            if (isChestplateOccupied) {
                matrixStack.m_85837_(0.0, 0.0, (double)0.01f);
            }
            matrixStack.m_85845_(new Quaternion(0.0f, outwardAngle, 0.0f, true));
            matrixStack.m_85845_(new Quaternion(-35.0f * totalRotation, 0.0f, 0.0f, true));
            if (breathingAnimation) {
                float f5 = -Mth.m_14089_((float)((float)entity.f_19797_ * 0.09f)) * 0.45f + 0.45f;
                matrixStack.m_85845_(new Quaternion(f5, 0.0f, 0.0f, true));
            }
            matrixStack.m_85841_(0.9995f, 1.0f, 1.0f);
            this.renderBreast(entity, armorStack, matrixStack, bufferSource, breastRenderType, packedLightIn, combineTex, red, green, blue, alpha, left);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrixStack.m_85849_();
    }

    private void renderBreast(AbstractClientPlayer entity, ItemStack armorStack, PoseStack matrixStack, MultiBufferSource bufferSource, RenderType breastRenderType, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean left) {
        Item item;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(breastRenderType);
        GenderLayer.renderBox(left ? this.lBreast : this.rBreast, matrixStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (entity.m_36170_(PlayerModelPart.JACKET)) {
            matrixStack.m_85837_(0.0, 0.0, (double)-0.015f);
            matrixStack.m_85841_(1.05f, 1.05f, 1.05f);
            GenderLayer.renderBox(left ? this.lBreastWear : this.rBreastWear, matrixStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (!armorStack.m_41619_() && (item = armorStack.m_41720_()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ResourceLocation armorTexture = this.getArmorResource(entity, armorStack, EquipmentSlot.CHEST, null);
            ResourceLocation overlayTexture = null;
            float armorR = 1.0f;
            float armorG = 1.0f;
            float armorB = 1.0f;
            if (armorItem instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableItem = (DyeableLeatherItem)armorItem;
                overlayTexture = this.getArmorResource(entity, armorStack, EquipmentSlot.CHEST, "overlay");
                int color = dyeableItem.m_41121_(armorStack);
                armorR = (float)(color >> 16 & 0xFF) / 255.0f;
                armorG = (float)(color >> 8 & 0xFF) / 255.0f;
                armorB = (float)(color & 0xFF) / 255.0f;
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(left ? (double)0.001f : (double)-0.001f, (double)0.015f, (double)-0.015f);
            matrixStack.m_85841_(1.05f, 1.0f, 1.0f);
            WildfireModelRenderer.BreastModelBox armor = left ? this.lBoobArmor : this.rBoobArmor;
            RenderType armorType = RenderType.m_110431_((ResourceLocation)armorTexture);
            VertexConsumer armorVertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)armorType, (boolean)false, (boolean)armorStack.m_41790_());
            GenderLayer.renderBox(armor, matrixStack, armorVertexConsumer, packedLightIn, OverlayTexture.f_118083_, armorR, armorG, armorB, 1.0f);
            if (overlayTexture != null) {
                RenderType overlayType = RenderType.m_110431_((ResourceLocation)overlayTexture);
                VertexConsumer overlayVertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)overlayType, (boolean)false, (boolean)armorStack.m_41790_());
                GenderLayer.renderBox(armor, matrixStack, overlayVertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStack.m_85849_();
        }
    }

    private static void renderBox(WildfireModelRenderer.ModelBox model, PoseStack matrixStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_85864_();
        for (WildfireModelRenderer.TexturedQuad quad : model.quads) {
            Vector3f vector3f = new Vector3f((float)quad.normal.m_123341_(), (float)quad.normal.m_123342_(), (float)quad.normal.m_123343_());
            vector3f.m_122249_(matrix3f);
            float normalX = vector3f.m_122239_();
            float normalY = vector3f.m_122260_();
            float normalZ = vector3f.m_122269_();
            for (WildfireModelRenderer.PositionTextureVertex vertex : quad.vertexPositions) {
                bufferIn.m_85982_(matrix4f, vertex.x() / 16.0f, vertex.y() / 16.0f, vertex.z() / 16.0f).m_85950_(red, green, blue, alpha).m_7421_(vertex.texturePositionX(), vertex.texturePositionY()).m_86008_(packedOverlayIn).m_85969_(packedLightIn).m_5601_(normalX, normalY, normalZ).m_5752_();
            }
        }
    }
}

