/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.main.config.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

public class WildfireSlider
extends class_339 {
    private double value;
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<class_2561> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;

    public WildfireSlider(int xPos, int yPos, int width, int height, FloatConfigKey config, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        this(xPos, yPos, width, height, config.getMinInclusive(), config.getMaxInclusive(), currentVal, valueUpdate, messageUpdate, onSave);
    }

    public WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (class_2561)new class_2585(""));
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
    }

    protected int method_25356(boolean hovered) {
        return 0;
    }

    protected void updateMessage() {
        this.method_25355((class_2561)this.messageUpdate.get(this.lastValue));
    }

    protected void applyValue() {
        float newValue = this.getFloatValue();
        if (this.lastValue != newValue) {
            this.valueUpdate.accept(newValue);
            this.lastValue = newValue;
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        this.save();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 263 || keyCode == 262) {
            this.save();
        }
        return result;
    }

    protected class_5250 method_25360() {
        return new class_2588("gui.narrate.slider", new Object[]{this.method_25369()});
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            RenderSystem.disableDepthTest();
            this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
            int clr = 0x54000000;
            int xP = this.field_22760 + 4;
            class_437.method_25294((class_4587)matrices, (int)(xP - 2), (int)(this.field_22761 + 1), (int)(this.field_22760 + this.field_22758 - 1), (int)(this.field_22761 + this.field_22759 - 1), (int)-2145246686);
            int xPos = this.field_22760 + 4 + (int)(this.value * (double)(this.field_22758 - 6));
            class_437.method_25294((class_4587)matrices, (int)(this.field_22760 + 3), (int)(this.field_22761 + 2), (int)(xPos - 1), (int)(this.field_22761 + this.field_22759 - 2), (int)-1272831386);
            int xPos2 = this.field_22760 + 2 + (int)(this.value * (double)(this.field_22758 - 4));
            class_437.method_25294((class_4587)matrices, (int)(xPos2 - 2), (int)(this.field_22761 + 1), (int)xPos2, (int)(this.field_22761 + this.field_22759 - 1), (int)0x78FFFFFF);
            RenderSystem.enableDepthTest();
            class_327 font = class_310.method_1551().field_1772;
            WildfireSlider.method_27534((class_4587)matrices, (class_327)font, (class_2561)this.method_25369(), (int)(this.field_22760 + this.field_22758 / 2), (int)(this.field_22761 + (this.field_22759 - 8) / 2), (int)(this.field_22762 || this.changed ? 0xFFFF55 : 0xFFFFFF));
        }
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.setValueInternal(value);
        this.applyValue();
    }

    private void setValueInternal(double value) {
        this.value = class_3532.method_15350((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.lastValue = (float)value;
        this.updateMessage();
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    public void method_37020(class_6382 builder) {
    }

    private void setValueFromMouse(double mouseX) {
        this.value = (mouseX - (double)(this.field_22760 + 4)) / (double)(this.field_22758 - 8);
        if (this.value < 0.0) {
            this.value = 0.0;
        }
        if (this.value > 1.0) {
            this.value = 1.0;
        }
        this.applyValue();
        this.updateMessage();
    }
}

