/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.gson.JsonObject;
import com.wildfire.main.Breasts;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.main.config.Configuration;
import com.wildfire.physics.BreastPhysics;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class GenderPlayer {
    public boolean needsSync;
    public final UUID uuid;
    private Gender gender;
    private float pBustSize = ((Float)Configuration.BUST_SIZE.getDefault()).floatValue();
    private boolean hurtSounds = (Boolean)Configuration.HURT_SOUNDS.getDefault();
    private boolean breastPhysics = (Boolean)Configuration.BREAST_PHYSICS.getDefault();
    private boolean armorBreastPhysics = (Boolean)Configuration.BREAST_PHYSICS_ARMOR.getDefault();
    private float bounceMultiplier = ((Float)Configuration.BOUNCE_MULTIPLIER.getDefault()).floatValue();
    private float floppyMultiplier = ((Float)Configuration.FLOPPY_MULTIPLIER.getDefault()).floatValue();
    public boolean lockSettings = false;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private boolean showBreastsInArmor = (Boolean)Configuration.SHOW_IN_ARMOR.getDefault();
    private final Configuration cfg;
    private final BreastPhysics lBreastPhysics = new BreastPhysics(this);
    private final BreastPhysics rBreastPhysics = new BreastPhysics(this);
    private final Breasts breasts = new Breasts();

    public GenderPlayer(UUID uuid) {
        this(uuid, (Gender)((Object)Configuration.GENDER.getDefault()));
    }

    public GenderPlayer(UUID uuid, Gender gender) {
        this.uuid = uuid;
        this.gender = gender;
        this.cfg = new Configuration("WildfireGender", this.uuid.toString());
        this.cfg.set(Configuration.USERNAME, this.uuid);
        this.cfg.setDefault(Configuration.GENDER);
        this.cfg.setDefault(Configuration.BUST_SIZE);
        this.cfg.setDefault(Configuration.HURT_SOUNDS);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_X);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Y);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Z);
        this.cfg.setDefault(Configuration.BREASTS_UNIBOOB);
        this.cfg.setDefault(Configuration.BREASTS_CLEAVAGE);
        this.cfg.setDefault(Configuration.BREAST_PHYSICS);
        this.cfg.setDefault(Configuration.BREAST_PHYSICS_ARMOR);
        this.cfg.setDefault(Configuration.SHOW_IN_ARMOR);
        this.cfg.setDefault(Configuration.BOUNCE_MULTIPLIER);
        this.cfg.setDefault(Configuration.FLOPPY_MULTIPLIER);
        this.cfg.finish();
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    private <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(Configuration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(Configuration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(Configuration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean hasBreastPhysics() {
        return this.breastPhysics;
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(Configuration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    public boolean hasArmorBreastPhysics() {
        return this.armorBreastPhysics;
    }

    public boolean updateArmorBreastPhysics(boolean value) {
        return this.updateValue(Configuration.BREAST_PHYSICS_ARMOR, value, v -> {
            this.armorBreastPhysics = v;
        });
    }

    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(Configuration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public float getBounceMultiplier() {
        return (float)Math.round(this.getBounceMultiplierRaw() * 3.0f * 100.0f) / 100.0f;
    }

    public float getBounceMultiplierRaw() {
        return this.bounceMultiplier;
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public static JsonObject toJsonObject(GenderPlayer plr) {
        JsonObject obj = new JsonObject();
        Configuration.USERNAME.save(obj, plr.uuid);
        Configuration.GENDER.save(obj, plr.getGender());
        Configuration.BUST_SIZE.save(obj, Float.valueOf(plr.getBustSize()));
        Configuration.HURT_SOUNDS.save(obj, plr.hasHurtSounds());
        Configuration.BREAST_PHYSICS.save(obj, plr.hasBreastPhysics());
        Configuration.BREAST_PHYSICS_ARMOR.save(obj, plr.hasArmorBreastPhysics());
        Configuration.SHOW_IN_ARMOR.save(obj, plr.showBreastsInArmor());
        Configuration.BOUNCE_MULTIPLIER.save(obj, Float.valueOf(plr.getBounceMultiplierRaw()));
        Configuration.FLOPPY_MULTIPLIER.save(obj, Float.valueOf(plr.getFloppiness()));
        Breasts breasts = plr.getBreasts();
        Configuration.BREASTS_OFFSET_X.save(obj, Float.valueOf(breasts.getXOffset()));
        Configuration.BREASTS_OFFSET_Y.save(obj, Float.valueOf(breasts.getYOffset()));
        Configuration.BREASTS_OFFSET_Z.save(obj, Float.valueOf(breasts.getZOffset()));
        Configuration.BREASTS_UNIBOOB.save(obj, breasts.isUniboob());
        Configuration.BREASTS_CLEAVAGE.save(obj, Float.valueOf(breasts.getCleavage()));
        return obj;
    }

    public static GenderPlayer fromJsonObject(JsonObject obj) {
        GenderPlayer plr = new GenderPlayer((UUID)Configuration.USERNAME.read(obj));
        plr.updateGender((Gender)((Object)Configuration.GENDER.read(obj)));
        plr.updateBustSize(((Float)Configuration.BUST_SIZE.read(obj)).floatValue());
        plr.updateHurtSounds((Boolean)Configuration.HURT_SOUNDS.read(obj));
        plr.updateBreastPhysics((Boolean)Configuration.BREAST_PHYSICS.read(obj));
        plr.updateArmorBreastPhysics((Boolean)Configuration.BREAST_PHYSICS_ARMOR.read(obj));
        plr.updateShowBreastsInArmor((Boolean)Configuration.SHOW_IN_ARMOR.read(obj));
        plr.updateBounceMultiplier(((Float)Configuration.BOUNCE_MULTIPLIER.read(obj)).floatValue());
        plr.updateFloppiness(((Float)Configuration.FLOPPY_MULTIPLIER.read(obj)).floatValue());
        Breasts breasts = plr.getBreasts();
        breasts.updateXOffset(((Float)Configuration.BREASTS_OFFSET_X.read(obj)).floatValue());
        breasts.updateYOffset(((Float)Configuration.BREASTS_OFFSET_Y.read(obj)).floatValue());
        breasts.updateZOffset(((Float)Configuration.BREASTS_OFFSET_Z.read(obj)).floatValue());
        breasts.updateUniboob((Boolean)Configuration.BREASTS_UNIBOOB.read(obj));
        breasts.updateCleavage(((Float)Configuration.BREASTS_CLEAVAGE.read(obj)).floatValue());
        return plr;
    }

    public static GenderPlayer loadCachedPlayer(UUID uuid, boolean markForSync) {
        GenderPlayer plr = WildfireGender.getPlayerById(uuid);
        if (plr != null) {
            plr.lockSettings = false;
            plr.syncStatus = SyncStatus.CACHED;
            Configuration config = plr.getConfig();
            plr.updateGender(config.get(Configuration.GENDER));
            plr.updateBustSize(config.get(Configuration.BUST_SIZE).floatValue());
            plr.updateHurtSounds(config.get(Configuration.HURT_SOUNDS));
            plr.updateBreastPhysics(config.get(Configuration.BREAST_PHYSICS));
            plr.updateArmorBreastPhysics(config.get(Configuration.BREAST_PHYSICS_ARMOR));
            plr.updateShowBreastsInArmor(config.get(Configuration.SHOW_IN_ARMOR));
            plr.updateBounceMultiplier(config.get(Configuration.BOUNCE_MULTIPLIER).floatValue());
            plr.updateFloppiness(config.get(Configuration.FLOPPY_MULTIPLIER).floatValue());
            Breasts breasts = plr.getBreasts();
            breasts.updateXOffset(config.get(Configuration.BREASTS_OFFSET_X).floatValue());
            breasts.updateYOffset(config.get(Configuration.BREASTS_OFFSET_Y).floatValue());
            breasts.updateZOffset(config.get(Configuration.BREASTS_OFFSET_Z).floatValue());
            breasts.updateUniboob(config.get(Configuration.BREASTS_UNIBOOB));
            breasts.updateCleavage(config.get(Configuration.BREASTS_CLEAVAGE).floatValue());
            if (markForSync) {
                plr.needsSync = true;
            }
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        Configuration config = plr.getConfig();
        config.set(Configuration.USERNAME, plr.uuid);
        config.set(Configuration.GENDER, plr.getGender());
        config.set(Configuration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        config.set(Configuration.HURT_SOUNDS, plr.hasHurtSounds());
        config.set(Configuration.BREAST_PHYSICS, plr.hasBreastPhysics());
        config.set(Configuration.BREAST_PHYSICS_ARMOR, plr.hasArmorBreastPhysics());
        config.set(Configuration.SHOW_IN_ARMOR, plr.showBreastsInArmor());
        config.set(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(plr.getBounceMultiplierRaw()));
        config.set(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(plr.getFloppiness()));
        config.set(Configuration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        config.set(Configuration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        config.set(Configuration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        config.set(Configuration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        config.set(Configuration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        config.save();
        plr.needsSync = true;
    }

    public Breasts getBreasts() {
        return this.breasts;
    }

    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public static enum Gender {
        FEMALE((class_2561)new class_2588("wildfire_gender.label.female").method_27692(class_124.field_1076)),
        MALE((class_2561)new class_2588("wildfire_gender.label.male").method_27692(class_124.field_1078)),
        OTHER((class_2561)new class_2588("wildfire_gender.label.other").method_27692(class_124.field_1060));

        private final class_2561 name;

        private Gender(class_2561 name) {
            this.name = name;
        }

        public class_2561 getDisplayName() {
            return this.name;
        }

        public boolean hasFemaleHurtSounds() {
            return this == FEMALE;
        }

        public boolean canHaveBreasts() {
            return this != MALE;
        }
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

