/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.api.IGenderArmor;
import com.wildfire.main.Breasts;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.physics.BreastPhysics;
import com.wildfire.render.WildfireModelRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1007;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1292;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4057;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_918;
import net.minecraft.class_922;

public class GenderLayer
extends class_3887<class_742, class_591<class_742>> {
    private WildfireModelRenderer.BreastModelBox lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.0f, false);
    private WildfireModelRenderer.OverlayModelBox lBreastWear = new WildfireModelRenderer.OverlayModelBox(true, 64, 64, 17, 34, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.OverlayModelBox rBreastWear = new WildfireModelRenderer.OverlayModelBox(false, 64, 64, 21, 34, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox lBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private WildfireModelRenderer.BreastModelBox rBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    private float preBreastSize = 0.0f;
    private static final Map<String, class_2960> ARMOR_LOCATION_CACHE = new HashMap<String, class_2960>();
    private static final Map<String, class_2960> ARMOR_TEXTURE_CACHE = new HashMap<String, class_2960>();

    public GenderLayer(class_3883 render) {
        super(render);
    }

    public class_2960 getArmorResource(class_1738 item, boolean legs, @Nullable String overlay) {
        String string = "textures/models/armor/" + item.method_7686().method_7694() + "_layer_" + (legs ? 2 : 1) + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(string, class_2960::new);
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLightIn, @Nonnull class_742 ent, float limbAngle, float limbDistance, float partialTicks, float animationProgress, float headYaw, float headPitch) {
        if (ent.method_5756((class_1657)class_310.method_1551().field_1724)) {
            return;
        }
        try {
            float rightBounceRotation;
            float rTotalX;
            float rTotal;
            UUID playerUUID = ent.method_5667();
            GenderPlayer plr = WildfireGender.getPlayerById(playerUUID);
            if (plr == null) {
                return;
            }
            class_1799 armorStack = ent.method_6118(class_1304.field_6174);
            IGenderArmor genderArmor = WildfireHelper.getArmorConfig(armorStack);
            boolean isChestplateOccupied = genderArmor.coversBreasts();
            if (genderArmor.alwaysHidesBreasts() || !plr.showBreastsInArmor() && isChestplateOccupied) {
                return;
            }
            class_1007 rend = (class_1007)class_310.method_1551().method_1561().method_3953((class_1297)ent);
            class_591 model = (class_591)rend.method_4038();
            Breasts breasts = plr.getBreasts();
            float breastOffsetX = (float)Math.round((float)Math.round(breasts.getXOffset() * 100.0f) / 100.0f * 10.0f) / 10.0f;
            float breastOffsetY = (float)(-Math.round((float)Math.round(breasts.getYOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
            float breastOffsetZ = (float)(-Math.round((float)Math.round(breasts.getZOffset() * 100.0f) / 100.0f * 10.0f)) / 10.0f;
            BreastPhysics leftBreastPhysics = plr.getLeftBreastPhysics();
            float bSize = leftBreastPhysics.getBreastSize(partialTicks);
            float outwardAngle = (float)Math.round(breasts.getCleavage() * 100.0f) / 100.0f * 100.0f;
            outwardAngle = Math.min(outwardAngle, 10.0f);
            float reducer = 0.0f;
            if (bSize < 0.84f) {
                reducer += 1.0f;
            }
            if (bSize < 0.72f) {
                reducer += 1.0f;
            }
            if (this.preBreastSize != bSize) {
                this.lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - breastOffsetZ - reducer), 0.0f, false);
                this.rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, (int)(4.0f - breastOffsetZ - reducer), 0.0f, false);
                this.preBreastSize = bSize;
            }
            float overlayRed = 1.0f;
            float overlayGreen = 1.0f;
            float overlayBlue = 1.0f;
            float overlayAlpha = ent.method_5767() ? 0.15f : 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float lTotal = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPreBounceY(), (float)leftBreastPhysics.getBounceY());
            float lTotalX = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPreBounceX(), (float)leftBreastPhysics.getBounceX());
            float leftBounceRotation = class_3532.method_16439((float)partialTicks, (float)leftBreastPhysics.getPreBounceRotation(), (float)leftBreastPhysics.getBounceRotation());
            if (breasts.isUniboob()) {
                rTotal = lTotal;
                rTotalX = lTotalX;
                rightBounceRotation = leftBounceRotation;
            } else {
                BreastPhysics rightBreastPhysics = plr.getRightBreastPhysics();
                rTotal = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPreBounceY(), (float)rightBreastPhysics.getBounceY());
                rTotalX = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPreBounceX(), (float)rightBreastPhysics.getBounceX());
                rightBounceRotation = class_3532.method_16439((float)partialTicks, (float)rightBreastPhysics.getPreBounceRotation(), (float)rightBreastPhysics.getBounceRotation());
            }
            float breastSize = bSize * 1.5f;
            if (breastSize > 0.7f) {
                breastSize = 0.7f;
            }
            if (bSize > 0.7f) {
                breastSize = bSize;
            }
            if (breastSize < 0.02f) {
                return;
            }
            float zOff = 0.0625f - bSize * 0.0625f;
            breastSize = bSize + 0.5f * Math.abs(bSize - 0.7f) * 2.0f;
            float resistance = class_3532.method_15363((float)genderArmor.physicsResistance(), (float)0.0f, (float)1.0f);
            boolean breathingAnimation = resistance <= 0.5f && (!ent.method_5869() || class_1292.method_5574((class_1309)ent) || ent.field_6002.method_8320(new class_2338(ent.method_23317(), ent.method_23320(), ent.method_23321())).method_27852(class_2246.field_10422));
            boolean bounceEnabled = plr.hasBreastPhysics() && (!isChestplateOccupied || plr.hasArmorBreastPhysics() && resistance < 1.0f);
            int combineTex = class_922.method_23622((class_1309)ent, (float)0.0f);
            class_1921 type = class_1921.method_23580((class_2960)rend.method_4216(ent));
            this.renderBreastWithTransforms(ent, model.field_3391, armorStack, matrixStack, vertexConsumerProvider, type, packedLightIn, combineTex, overlayRed, overlayGreen, overlayBlue, overlayAlpha, bounceEnabled, lTotalX, lTotal, leftBounceRotation, breastSize, breastOffsetX, breastOffsetY, breastOffsetZ, zOff, outwardAngle, breasts.isUniboob(), isChestplateOccupied, breathingAnimation, true);
            this.renderBreastWithTransforms(ent, model.field_3391, armorStack, matrixStack, vertexConsumerProvider, type, packedLightIn, combineTex, overlayRed, overlayGreen, overlayBlue, overlayAlpha, bounceEnabled, rTotalX, rTotal, rightBounceRotation, breastSize, -breastOffsetX, breastOffsetY, breastOffsetZ, zOff, -outwardAngle, breasts.isUniboob(), isChestplateOccupied, breathingAnimation, false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderBreastWithTransforms(class_742 entity, class_630 body, class_1799 armorStack, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_1921 breastRenderType, int packedLightIn, int combineTex, float red, float green, float blue, float alpha, boolean bounceEnabled, float totalX, float total, float bounceRotation, float breastSize, float breastOffsetX, float breastOffsetY, float breastOffsetZ, float zOff, float outwardAngle, boolean uniboob, boolean isChestplateOccupied, boolean breathingAnimation, boolean left) {
        matrixStack.method_22903();
        try {
            matrixStack.method_22904((double)(body.field_3657 * 0.0625f), (double)(body.field_3656 * 0.0625f), (double)(body.field_3655 * 0.0625f));
            if (body.field_3674 != 0.0f) {
                matrixStack.method_22907(new class_1158(0.0f, 0.0f, body.field_3674, false));
            }
            if (body.field_3675 != 0.0f) {
                matrixStack.method_22907(new class_1158(0.0f, body.field_3675, 0.0f, false));
            }
            if (body.field_3654 != 0.0f) {
                matrixStack.method_22907(new class_1158(body.field_3654, 0.0f, 0.0f, false));
            }
            if (bounceEnabled) {
                matrixStack.method_22904((double)(totalX / 32.0f), 0.0, 0.0);
                matrixStack.method_22904(0.0, (double)(total / 32.0f), 0.0);
            }
            matrixStack.method_22904((double)(breastOffsetX * 0.0625f), (double)(0.05625f + breastOffsetY * 0.0625f), (double)(zOff - 0.125f + breastOffsetZ * 0.0625f));
            if (!uniboob) {
                matrixStack.method_22904((double)(-0.125f * (float)(left ? 1 : -1)), 0.0, 0.0);
            }
            if (bounceEnabled) {
                matrixStack.method_22907(new class_1158(0.0f, bounceRotation, 0.0f, true));
            }
            if (!uniboob) {
                matrixStack.method_22904((double)(0.125f * (float)(left ? 1 : -1)), 0.0, 0.0);
            }
            float rotationMultiplier = 0.0f;
            if (bounceEnabled) {
                matrixStack.method_22904(0.0, (double)(-0.035f * breastSize), 0.0);
                rotationMultiplier = -total / 12.0f;
            }
            float totalRotation = breastSize + rotationMultiplier;
            if (!bounceEnabled) {
                totalRotation = breastSize;
            }
            if (totalRotation > breastSize + 0.2f) {
                totalRotation = breastSize + 0.2f;
            }
            totalRotation = Math.min(totalRotation, 1.0f);
            if (isChestplateOccupied) {
                matrixStack.method_22904(0.0, 0.0, (double)0.01f);
            }
            matrixStack.method_22907(new class_1158(0.0f, outwardAngle, 0.0f, true));
            matrixStack.method_22907(new class_1158(-35.0f * totalRotation, 0.0f, 0.0f, true));
            if (breathingAnimation) {
                float f5 = -class_3532.method_15362((float)((float)entity.field_6012 * 0.09f)) * 0.45f + 0.45f;
                matrixStack.method_22907(new class_1158(f5, 0.0f, 0.0f, true));
            }
            matrixStack.method_22905(0.9995f, 1.0f, 1.0f);
            this.renderBreast(entity, armorStack, matrixStack, vertexConsumerProvider, breastRenderType, packedLightIn, combineTex, red, green, blue, alpha, left);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrixStack.method_22909();
    }

    private void renderBreast(class_742 entity, class_1799 armorStack, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_1921 breastRenderType, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean left) {
        class_1792 class_17922;
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(breastRenderType);
        GenderLayer.renderBox(left ? this.lBreast : this.rBreast, matrixStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (entity.method_7348(class_1664.field_7564)) {
            matrixStack.method_22904(0.0, 0.0, (double)-0.015f);
            matrixStack.method_22905(1.05f, 1.05f, 1.05f);
            GenderLayer.renderBox(left ? this.lBreastWear : this.rBreastWear, matrixStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (!armorStack.method_7960() && (class_17922 = armorStack.method_7909()) instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            class_2960 armorTexture = this.getArmorResource(armorItem, false, null);
            class_2960 overlayTexture = null;
            float armorR = 1.0f;
            float armorG = 1.0f;
            float armorB = 1.0f;
            if (armorItem instanceof class_4057) {
                class_4057 dyeableItem = (class_4057)armorItem;
                int color = dyeableItem.method_7800(armorStack);
                armorR = (float)(color >> 16 & 0xFF) / 255.0f;
                armorG = (float)(color >> 8 & 0xFF) / 255.0f;
                armorB = (float)(color & 0xFF) / 255.0f;
            }
            matrixStack.method_22903();
            matrixStack.method_22904(left ? (double)0.001f : (double)-0.001f, (double)0.015f, (double)-0.015f);
            matrixStack.method_22905(1.05f, 1.0f, 1.0f);
            WildfireModelRenderer.BreastModelBox armor = left ? this.lBoobArmor : this.rBoobArmor;
            class_1921 armorType = class_1921.method_25448((class_2960)armorTexture);
            class_4588 armorVertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)armorType, (boolean)false, (boolean)armorStack.method_7958());
            GenderLayer.renderBox(armor, matrixStack, armorVertexConsumer, packedLightIn, class_4608.field_21444, armorR, armorG, armorB, 1.0f);
            if (overlayTexture != null) {
                class_1921 overlayType = class_1921.method_25448(overlayTexture);
                class_4588 overlayVertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)overlayType, (boolean)false, (boolean)armorStack.method_7958());
                GenderLayer.renderBox(armor, matrixStack, overlayVertexConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStack.method_22909();
        }
    }

    private static void renderBox(WildfireModelRenderer.ModelBox model, class_4587 matrixStack, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        class_4581 matrix3f = matrixStack.method_23760().method_23762();
        for (WildfireModelRenderer.TexturedQuad quad : model.quads) {
            class_1160 vector3f = new class_1160(quad.normal.method_4943(), quad.normal.method_4945(), quad.normal.method_4947());
            vector3f.method_23215(matrix3f);
            float normalX = vector3f.method_4943();
            float normalY = vector3f.method_4945();
            float normalZ = vector3f.method_4947();
            for (WildfireModelRenderer.PositionTextureVertex vertex : quad.vertexPositions) {
                float j = vertex.x() / 16.0f;
                float k = vertex.y() / 16.0f;
                float l = vertex.z() / 16.0f;
                class_1162 vector4f = new class_1162(j, k, l, 1.0f);
                vector4f.method_22674(matrix4f);
                bufferIn.method_23919(vector4f.method_4953(), vector4f.method_4956(), vector4f.method_4957(), red, green, blue, alpha, vertex.texturePositionX(), vertex.texturePositionY(), packedOverlayIn, packedLightIn, normalX, normalY, normalZ);
            }
        }
    }
}

