/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wildfire.main.config.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class WildfireSlider
extends AbstractSliderButton {
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<Component> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;

    public WildfireSlider(int xPos, int yPos, int width, int height, FloatConfigKey config, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<Component> messageUpdate, FloatConsumer onSave) {
        this(xPos, yPos, width, height, config.getMinInclusive(), config.getMaxInclusive(), currentVal, valueUpdate, messageUpdate, onSave);
    }

    public WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<Component> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_(), 0.0);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
    }

    protected void m_5695_() {
        this.m_93666_((Component)this.messageUpdate.get(this.lastValue));
    }

    protected void m_5697_() {
        float newValue = this.getFloatValue();
        if (this.lastValue != newValue) {
            this.valueUpdate.accept(newValue);
            this.lastValue = newValue;
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.save();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean result = super.m_7933_(keyCode, scanCode, modifiers);
        if (keyCode == 263 || keyCode == 262) {
            this.save();
        }
        return result;
    }

    public void m_6303_(@Nonnull PoseStack mStack, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69465_();
        int clr = 0x54000000;
        WildfireSlider.m_93172_((PoseStack)mStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.m_5711_()), (int)(this.f_93621_ + this.f_93619_), (int)clr);
        WildfireSlider.m_93172_((PoseStack)mStack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)(this.f_93620_ + this.f_93618_ - 1), (int)(this.f_93621_ + this.f_93619_ - 1), (int)-2145246686);
        int xPos = this.f_93620_ + 4 + (int)(this.f_93577_ * (double)(this.f_93618_ - 6));
        WildfireSlider.m_93172_((PoseStack)mStack, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (int)(xPos - 1), (int)(this.f_93621_ + this.f_93619_ - 2), (int)-1272831386);
        int xPos2 = this.f_93620_ + 2 + (int)(this.f_93577_ * (double)(this.f_93618_ - 4));
        WildfireSlider.m_93172_((PoseStack)mStack, (int)(xPos2 - 2), (int)(this.f_93621_ + 1), (int)xPos2, (int)(this.f_93621_ + this.f_93619_ - 1), (int)0x78FFFFFF);
        RenderSystem.m_69482_();
        Font font = Minecraft.m_91087_().f_91062_;
        WildfireSlider.m_93215_((PoseStack)mStack, (Font)font, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(this.f_93622_ || this.changed ? 0xFFFF55 : 0xFFFFFF));
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public void m_93611_(double value) {
        this.setValueInternal(value);
        this.m_5697_();
    }

    private void setValueInternal(double value) {
        this.f_93577_ = Mth.m_14008_((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.lastValue = (float)value;
        this.m_5695_();
    }
}

