/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketGenderInfo;
import com.wildfire.main.networking.PacketSync;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendGenderInfo
extends PacketGenderInfo {
    public PacketSendGenderInfo(GenderPlayer plr) {
        super(plr);
    }

    public PacketSendGenderInfo(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public static void handle(PacketSendGenderInfo packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null || !player.m_20148_().equals(packet.uuid)) {
                return;
            }
            GenderPlayer plr = WildfireGender.getOrAddPlayerById(packet.uuid);
            packet.updatePlayerFromPacket(plr);
            PacketSync.sendToOthers(player, plr);
        });
        context.get().setPacketHandled(true);
    }

    public static void send(GenderPlayer plr) {
        if (plr == null || !plr.needsSync) {
            return;
        }
        WildfireGender.NETWORK.sendToServer((Object)new PacketSendGenderInfo(plr));
        plr.needsSync = false;
    }
}

