/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_6382;
import net.minecraft.class_640;
import net.minecraft.class_7532;

public class WildfirePlayerList
extends class_350<Entry> {
    private static final Ordering<class_640> ENTRY_ORDERING = Ordering.from((Comparator)new EntryOrderComparator());
    private static final class_2960 TXTR_SYNC = new class_2960("wildfire_gender", "textures/sync.png");
    private static final class_2960 TXTR_UNKNOWN = new class_2960("wildfire_gender", "textures/unknown.png");
    private static final class_2960 TXTR_CACHED = new class_2960("wildfire_gender", "textures/cached.png");
    private final int listWidth;
    private final WildfirePlayerListScreen parent;

    public WildfirePlayerList(WildfirePlayerListScreen parent, int listWidth, int top, int bottom) {
        super(class_310.method_1551(), parent.field_22789 - 4, parent.field_22790, top - 6, bottom, 20);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int method_25329() {
        return this.parent.field_22789 / 2 + 53;
    }

    public int method_25322() {
        return this.listWidth;
    }

    public void refreshList() {
        this.method_25339();
        if (this.field_22740.field_1687 == null || this.field_22740.field_1724 == null) {
            return;
        }
        class_634 clientPlayNetworkHandler = this.field_22740.field_1724.field_3944;
        for (class_640 playerList : ENTRY_ORDERING.sortedCopy((Iterable)clientPlayNetworkHandler.method_2880())) {
            class_1657 player = this.field_22740.field_1687.method_18470(playerList.method_2966().getId());
            if (player == null) continue;
            this.method_25321(new Entry(playerList));
        }
    }

    public void method_37020(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public class Entry
    extends class_350.class_351<Entry> {
        private final String name;
        public final class_640 nInfo;
        private final WildfireButton btnOpenGUI;

        private Entry(class_640 nInfo) {
            this.nInfo = nInfo;
            this.name = nInfo.method_2966().getName();
            this.btnOpenGUI = new WildfireButton(0, 0, 112, 20, (class_2561)class_2561.method_43473(), button -> {
                GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.method_2966().getId());
                if (aPlr == null) {
                    return;
                }
                try {
                    class_310.method_1551().method_1507((class_437)new WardrobeBrowserScreen(WildfirePlayerList.this.parent, nInfo.method_2966().getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.method_2966().getId());
            if (aPlr != null) {
                this.btnOpenGUI.field_22763 = !aPlr.lockSettings;
            }
        }

        public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_327 font = class_310.method_1551().field_1772;
            GenderPlayer aPlr = WildfireGender.getPlayerById(this.nInfo.method_2966().getId());
            RenderSystem.setShaderTexture((int)0, (class_2960)this.nInfo.method_2968());
            class_7532.method_44443((class_332)ctx, (class_2960)this.nInfo.method_2968(), (int)(x + 2), (int)(y + 2), (int)16);
            ctx.method_51433(font, this.name, x + 23, y + 2, 0xFFFFFF, false);
            if (aPlr != null) {
                this.btnOpenGUI.field_22763 = !aPlr.lockSettings;
                ctx.method_51439(font, aPlr.getGender().getDisplayName(), x + 23, y + 11, 0xFFFFFF, false);
                if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.SYNCED) {
                    ctx.method_25293(TXTR_SYNC, x + 98, y + 11, 12, 8, 0.0f, 0.0f, 12, 8, 12, 8);
                    if (mouseX > x + 98 - 2 && mouseY > y + 11 - 2 && mouseX < y + 98 + 12 + 2 && mouseY < y + 20) {
                        WildfirePlayerList.this.parent.method_47415((class_2561)class_2561.method_43471((String)"wildfire_gender.player_list.state.synced"));
                    }
                } else if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.UNKNOWN) {
                    ctx.method_25293(TXTR_UNKNOWN, x + 98, y + 11, 12, 8, 0.0f, 0.0f, 12, 8, 12, 8);
                }
            } else {
                this.btnOpenGUI.field_22763 = false;
                ctx.method_51439(font, (class_2561)class_2561.method_43471((String)"wildfire_gender.label.too_far").method_27692(class_124.field_1061), x + 23, y + 11, 0xFFFFFF, false);
            }
            this.btnOpenGUI.method_46421(x);
            this.btnOpenGUI.method_46419(y);
            this.btnOpenGUI.method_25394(ctx, mouseX, mouseY, partialTicks);
            if (this.btnOpenGUI.method_49606()) {
                WildfirePlayerListScreen.HOVER_PLAYER = aPlr;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.btnOpenGUI.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class EntryOrderComparator
    implements Comparator<class_640> {
        private EntryOrderComparator() {
        }

        @Override
        public int compare(class_640 playerListEntry, class_640 playerListEntry2) {
            class_268 team = playerListEntry.method_2955();
            class_268 team2 = playerListEntry2.method_2955();
            return ComparisonChain.start().compareTrueFirst(playerListEntry.method_2958() != class_1934.field_9219, playerListEntry2.method_2958() != class_1934.field_9219).compare((Comparable)((Object)(team != null ? team.method_1197() : "")), (Comparable)((Object)(team2 != null ? team2.method_1197() : ""))).compare((Object)playerListEntry.method_2966().getName(), (Object)playerListEntry2.method_2966().getName(), String::compareToIgnoreCase).result();
        }
    }
}

