/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.render.BreastSide;
import com.wildfire.render.GenderLayer;
import com.wildfire.render.WildfireModelRenderer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1664;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5455;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_918;

public class GenderArmorLayer<T extends class_1309, M extends class_572<T>>
extends GenderLayer<T, M> {
    private final class_1059 armorTrimsAtlas;
    protected final WildfireModelRenderer.BreastModelBox lBoobArmor;
    protected final WildfireModelRenderer.BreastModelBox rBoobArmor;
    protected final WildfireModelRenderer.BreastModelBox lTrim;
    protected final WildfireModelRenderer.BreastModelBox rTrim;
    private EntityConfig entityConfig;

    public GenderArmorLayer(class_3883<T, M> render, class_1092 bakery) {
        super(render);
        this.armorTrimsAtlas = bakery.method_24153(class_4722.field_42071);
        this.lBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
        this.rBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
        this.lTrim = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, false);
        this.rTrim = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, false);
    }

    public class_2960 getArmorResource(@Nonnull class_1738 item, boolean legs, @Nullable String overlay) {
        String material = item.method_7686().method_7694();
        String namespace = "minecraft";
        int namespaceDelim = material.indexOf(":");
        if (namespaceDelim >= 0) {
            namespace = material.substring(0, namespaceDelim);
            material = material.substring(namespaceDelim + 1);
        }
        return new class_2960(namespace, "textures/models/armor/" + material + "_layer_" + (legs ? 2 : 1) + (String)(overlay == null ? "" : "_" + overlay) + ".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLightIn, @Nonnull T ent, float limbAngle, float limbDistance, float partialTicks, float animationProgress, float headYaw, float headPitch) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (ent.method_6118(class_1304.field_6174).method_7960()) {
            return;
        }
        try {
            this.entityConfig = this.getConfig(ent);
            if (this.entityConfig == null) {
                return;
            }
            if (!this.setupRender(ent, this.entityConfig, partialTicks)) {
                return;
            }
            if (ent instanceof class_1531 && !this.genderArmor.armorStandsCopySettings()) {
                return;
            }
            class_572 model = (class_572)this.method_17165();
            matrixStack.method_22903();
            try {
                this.setupTransformations(ent, model.field_3391, matrixStack, BreastSide.LEFT);
                this.renderBreastArmor(ent, matrixStack, vertexConsumerProvider, packedLightIn, BreastSide.LEFT);
            }
            finally {
                matrixStack.method_22909();
            }
            matrixStack.method_22903();
            try {
                this.setupTransformations(ent, model.field_3391, matrixStack, BreastSide.RIGHT);
                this.renderBreastArmor(ent, matrixStack, vertexConsumerProvider, packedLightIn, BreastSide.RIGHT);
            }
            finally {
                matrixStack.method_22909();
            }
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast armor", (Throwable)e);
        }
    }

    @Override
    protected void setupTransformations(T entity, class_630 body, class_4587 matrixStack, BreastSide side) {
        class_742 player;
        super.setupTransformations(entity, body, matrixStack, side);
        if (entity instanceof class_742 && (player = (class_742)entity).method_7348(class_1664.field_7564) || entity instanceof class_1531 && this.entityConfig.hasJacketLayer()) {
            matrixStack.method_46416(0.0f, 0.0f, -0.015f);
            matrixStack.method_22905(1.05f, 1.05f, 1.05f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBreastArmor(T entity, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLightIn, BreastSide side) {
        class_1792 class_17922;
        if (this.armorStack.method_7960() || !((class_17922 = this.armorStack.method_7909()) instanceof class_1738)) {
            return;
        }
        class_1738 armorItem = (class_1738)class_17922;
        class_2960 armorTexture = this.getArmorResource(armorItem, false, null);
        class_2960 overlayTexture = null;
        boolean hasGlint = this.armorStack.method_7958();
        float armorR = 1.0f;
        float armorG = 1.0f;
        float armorB = 1.0f;
        if (armorItem instanceof class_4057) {
            class_4057 dyeableItem = (class_4057)armorItem;
            int color = dyeableItem.method_7800(this.armorStack);
            armorR = (float)(color >> 16 & 0xFF) / 255.0f;
            armorG = (float)(color >> 8 & 0xFF) / 255.0f;
            armorB = (float)(color & 0xFF) / 255.0f;
        }
        matrixStack.method_22903();
        try {
            matrixStack.method_46416(side == BreastSide.LEFT ? 0.001f : -0.001f, 0.015f, -0.015f);
            matrixStack.method_22905(1.05f, 1.0f, 1.0f);
            WildfireModelRenderer.BreastModelBox armor = side == BreastSide.LEFT ? this.lBoobArmor : this.rBoobArmor;
            class_1921 armorType = class_1921.method_25448((class_2960)armorTexture);
            class_4588 armorVertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)armorType, (boolean)false, (boolean)hasGlint);
            GenderArmorLayer.renderBox(armor, matrixStack, armorVertexConsumer, packedLightIn, class_4608.field_21444, armorR, armorG, armorB, 1.0f);
            if (overlayTexture != null) {
                class_1921 overlayType = class_1921.method_25448(overlayTexture);
                class_4588 overlayVertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)overlayType, (boolean)false, (boolean)hasGlint);
                GenderArmorLayer.renderBox(armor, matrixStack, overlayVertexConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            class_8053.method_48428((class_5455)entity.method_37908().method_30349(), (class_1799)this.armorStack, (boolean)true).ifPresent(trim -> this.renderArmorTrim(armorItem.method_7686(), matrixStack, vertexConsumerProvider, packedLightIn, (class_8053)trim, hasGlint, side));
        }
        finally {
            matrixStack.method_22909();
        }
    }

    protected void renderArmorTrim(class_1741 material, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLightIn, class_8053 trim, boolean hasGlint, BreastSide side) {
        WildfireModelRenderer.BreastModelBox trimModelBox = side == BreastSide.LEFT ? this.lTrim : this.rTrim;
        class_1058 sprite = this.armorTrimsAtlas.method_4608(trim.method_48436(material));
        class_4588 vertexConsumer = sprite.method_24108(vertexConsumerProvider.getBuffer(class_4722.method_48480((boolean)((class_8056)trim.method_48424().comp_349()).comp_1905())));
        GenderArmorLayer.renderBox(trimModelBox, matrixStack, vertexConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (hasGlint) {
            GenderArmorLayer.renderBox(trimModelBox, matrixStack, vertexConsumerProvider.getBuffer(class_1921.method_27949()), packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

