/*
 * Decompiled with CFR 0.152.
 */
package lumien.hardcoredarkness.asm;

import java.util.ListIterator;
import lumien.hardcoredarkness.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"HardcoreDarknessCore");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRendererClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.World")) {
            return this.patchWorldClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.WorldProviderHell")) {
            return this.patchHellProvider(basicClass);
        }
        return basicClass;
    }

    private byte[] patchHellProvider(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found WorldProviderHell Class: " + classNode.name);
        MethodNode generateLightBrightnessTable = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_76556_a"))) continue;
            generateLightBrightnessTable = mn;
            break;
        }
        if (generateLightBrightnessTable != null) {
            this.logger.log(Level.DEBUG, " - Patched generateLightBrightnessTable");
            InsnList toInsert = new InsnList();
            LabelNode l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "stopNetherLight", "()Z", false));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/world/WorldProvider", MCPNames.method("func_76556_a"), "()V", false));
            toInsert.add((AbstractInsnNode)new InsnNode(177));
            toInsert.add((AbstractInsnNode)l1);
            generateLightBrightnessTable.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWorldClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found World Class: " + classNode.name);
        String sunBrightnessName = "getSunBrightnessBody";
        boolean removeIndex = false;
        MethodNode getSunBrightnessBody = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(sunBrightnessName)) continue;
            getSunBrightnessBody = mn;
        }
        boolean activate2Power = false;
        Float add = new Float("0.2");
        Float mult = new Float("0.8");
        if (getSunBrightnessBody != null) {
            for (int i = 0; i < getSunBrightnessBody.instructions.size(); ++i) {
                AbstractInsnNode an = getSunBrightnessBody.instructions.get(i);
                if (!(an instanceof LdcInsnNode)) continue;
                LdcInsnNode lin = (LdcInsnNode)an;
                if (lin.cst.equals(mult)) {
                    this.logger.log(Level.DEBUG, " - Patched minimal sky light (1/2)");
                    getSunBrightnessBody.instructions.set((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "sky1", "()F", false));
                    activate2Power = true;
                    continue;
                }
                if (!activate2Power || !lin.cst.equals(add)) continue;
                this.logger.log(Level.DEBUG, " - Patched minimal sky light (2/2)");
                getSunBrightnessBody.instructions.set((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "sky2", "()F", false));
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRendererClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityRenderer Class: " + classNode.name);
        String methodName = MCPNames.method("func_78472_g");
        boolean removeIndex = false;
        MethodNode updateLightmap = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(methodName)) continue;
            updateLightmap = mn;
        }
        Float m0 = new Float("0.95");
        Float m3 = new Float("0.96");
        Float a0 = new Float("0.05");
        Float a3 = new Float("0.03");
        if (updateLightmap != null) {
            this.logger.log(Level.DEBUG, " - Patched updateLightmap");
            boolean insertedHook = false;
            ListIterator iterator = updateLightmap.instructions.iterator();
            boolean potion = false;
            for (int i = 0; i < updateLightmap.instructions.size(); ++i) {
                AbstractInsnNode an = updateLightmap.instructions.get(i);
                if (an instanceof LdcInsnNode) {
                    LdcInsnNode lin = (LdcInsnNode)an;
                    if (potion) continue;
                    if (lin.cst.equals(m0) || lin.cst.equals(m3)) {
                        updateLightmap.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "up", "(F)F", false));
                        continue;
                    }
                    if (!lin.cst.equals(a0) && !lin.cst.equals(a3)) continue;
                    updateLightmap.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "down", "(F)F", false));
                    continue;
                }
                if (!(an instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)an;
                if (min.name.equals(MCPNames.method("func_70644_a"))) {
                    if (!(updateLightmap.instructions.get(i + 1) instanceof JumpInsnNode)) continue;
                    float mod1 = 0.9f;
                    float mod2 = 1.0f - mod1;
                    this.logger.log(Level.DEBUG, " - Patched Nightvision Potion");
                    AbstractInsnNode insertAfter = updateLightmap.instructions.get(i + 1);
                    InsnList instructions = new InsnList();
                    instructions.add((AbstractInsnNode)new VarInsnNode(23, 11));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod1)));
                    instructions.add((AbstractInsnNode)new InsnNode(106));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod2)));
                    instructions.add((AbstractInsnNode)new InsnNode(98));
                    instructions.add((AbstractInsnNode)new VarInsnNode(56, 11));
                    instructions.add((AbstractInsnNode)new VarInsnNode(23, 12));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod1)));
                    instructions.add((AbstractInsnNode)new InsnNode(106));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod2)));
                    instructions.add((AbstractInsnNode)new InsnNode(98));
                    instructions.add((AbstractInsnNode)new VarInsnNode(56, 12));
                    instructions.add((AbstractInsnNode)new VarInsnNode(23, 13));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod1)));
                    instructions.add((AbstractInsnNode)new InsnNode(106));
                    instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(mod2)));
                    instructions.add((AbstractInsnNode)new InsnNode(98));
                    instructions.add((AbstractInsnNode)new VarInsnNode(56, 13));
                    updateLightmap.instructions.insert(insertAfter, instructions);
                    i += 18;
                    continue;
                }
                if (min.name.equals(MCPNames.method("func_177502_q"))) {
                    this.logger.log(Level.DEBUG, " - Patched End Light Removal");
                    InsnList toInsert = new InsnList();
                    LabelNode l0 = new LabelNode(new Label());
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "stopEndLight", "()Z", false));
                    toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                    toInsert.add((AbstractInsnNode)new InsnNode(87));
                    toInsert.add((AbstractInsnNode)new InsnNode(3));
                    toInsert.add((AbstractInsnNode)l0);
                    updateLightmap.instructions.insert(updateLightmap.instructions.get(i), toInsert);
                    continue;
                }
                if (!min.name.equals(MCPNames.method("func_110564_a"))) continue;
                this.logger.log(Level.DEBUG, " - Patched Lightmap Manipulation");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", MCPNames.field("field_78504_Q"), "[I"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/hardcoredarkness/handler/AsmHandler", "modifyLightmap", "([I)[I", false));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/client/renderer/EntityRenderer", MCPNames.field("field_78504_Q"), "[I"));
                updateLightmap.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                i += 5;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

