/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.tileentity;

import mal.lootbags.LootBags;
import mal.lootbags.network.LootbagsPacketHandler;
import mal.lootbags.network.message.RecyclerMessageServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityRecycler
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private ItemStack lootbagSlot;
    private int lootbagCount = 0;
    private int totalValue = 0;
    private ItemStack[] inventory = new ItemStack[27];

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.inventory.length; ++i) {
                int val;
                if (this.inventory[i] == null || !LootBags.isItemDroppable(this.inventory[i]) || this.totalValue > Integer.MAX_VALUE - (val = LootBags.getItemValue(this.inventory[i]))) continue;
                this.totalValue += val;
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a > 0) continue;
                this.inventory[i] = null;
            }
            if (this.totalValue >= LootBags.TOTALVALUE && this.lootbagCount < 0x7FFFFFFE) {
                this.totalValue -= LootBags.TOTALVALUE;
                ++this.lootbagCount;
            }
            if (this.lootbagSlot == null && this.lootbagCount > 0) {
                this.lootbagSlot = new ItemStack((Item)LootBags.lootbagItem, 1, LootBags.RECYCLEDID);
                --this.lootbagCount;
            }
            if (this.lootbagCount <= 0) {
                this.lootbagCount = 0;
            }
            LootbagsPacketHandler.instance.sendToAll((IMessage)new RecyclerMessageServer(this, this.lootbagCount, this.totalValue));
        }
    }

    public int getTotalBags() {
        return this.lootbagCount + (this.lootbagSlot != null ? 1 : 0);
    }

    public void setData(int count, int value) {
        this.lootbagCount = count;
        this.totalValue = value;
    }

    public int getValue() {
        return this.totalValue;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lootbagCount = nbt.func_74762_e("lootbagCount");
        this.totalValue = nbt.func_74762_e("totalValue");
        NBTTagList lootbag = nbt.func_150295_c("lootbagItem", 10);
        NBTTagCompound var = lootbag.func_150305_b(0);
        this.lootbagSlot = ItemStack.func_77949_a((NBTTagCompound)var);
        NBTTagList input = nbt.func_150295_c("inputItems", 10);
        for (int i = 0; i < input.func_74745_c(); ++i) {
            NBTTagCompound var4 = input.func_150305_b(i);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.inventory.length) continue;
            this.inventory[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("lootbagCount", this.lootbagCount);
        nbt.func_74768_a("totalValue", this.totalValue);
        NBTTagList lootbag = new NBTTagList();
        if (this.lootbagSlot != null) {
            NBTTagCompound var = new NBTTagCompound();
            var.func_74774_a("Slot", (byte)0);
            this.lootbagSlot.func_77955_b(var);
            lootbag.func_74742_a((NBTBase)var);
        }
        nbt.func_74782_a("lootbagItem", (NBTBase)lootbag);
        NBTTagList input = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(var4);
            input.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("inputItems", (NBTBase)input);
        return nbt;
    }

    public NBTTagCompound getDropNBT() {
        int vp = this.lootbagSlot == null ? 0 : 1;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("lootbagCount", this.lootbagCount + vp);
        tag.func_74768_a("totalValue", this.totalValue);
        return tag;
    }

    public int func_70302_i_() {
        return this.inventory.length + 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.lootbagSlot;
        }
        if (slot < this.func_70302_i_()) {
            return this.inventory[slot - 1];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int dec) {
        if (slot == 0) {
            if (this.lootbagSlot != null) {
                if (this.lootbagSlot.field_77994_a <= dec) {
                    ItemStack is = this.lootbagSlot;
                    this.lootbagSlot = null;
                    return is;
                }
                ItemStack is = this.lootbagSlot.func_77979_a(dec);
                if (this.lootbagSlot.field_77994_a == 0) {
                    this.lootbagSlot = null;
                }
                return is;
            }
        } else if (slot < this.func_70302_i_() && this.inventory[slot - 1] != null) {
            if (this.inventory[slot - 1].field_77994_a <= dec) {
                ItemStack is = this.inventory[slot - 1];
                this.inventory[slot - 1] = null;
                return is;
            }
            ItemStack is = this.inventory[slot - 1].func_77979_a(dec);
            if (this.inventory[slot - 1].field_77994_a == 0) {
                this.inventory[slot - 1] = null;
            }
            return is;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        if (slot == 0) {
            this.lootbagSlot = item;
            if (item != null && item.field_77994_a > this.func_70297_j_()) {
                item.field_77994_a = this.func_70297_j_();
            }
        } else if (slot < this.func_70302_i_()) {
            this.inventory[slot - 1] = item;
            if (item != null && item.field_77994_a > this.func_70297_j_()) {
                item.field_77994_a = this.func_70297_j_();
            }
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (slot < this.func_70302_i_()) {
            if (LootBags.isItemRecyleBlacklisted(stack) && !LootBags.isItemRecycleWhitelisted(stack)) {
                return false;
            }
            if (LootBags.isItemDroppable(stack)) {
                return true;
            }
        }
        return false;
    }

    public void activate(World world, int x, int y, int z, EntityPlayer player) {
        player.openGui((Object)LootBags.LootBagsInstance, 1, world, x, y, z);
    }

    public void activate(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)LootBags.LootBagsInstance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public String func_70005_c_() {
        return "recycler";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] i = new int[this.func_70302_i_()];
        for (int ii = 0; ii < i.length; ++ii) {
            i[ii] = ii;
        }
        return i;
    }

    public boolean func_180462_a(int slot, ItemStack itemStackIn, EnumFacing direction) {
        return slot != 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

