/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mal.lootbags.Bag;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.loot.LootItem;
import mal.lootbags.loot.LootRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BagHandler {
    private static HashMap<Integer, Bag> bagList = new HashMap();
    public static final int HARDMAX = 5;

    public static void clearBags() {
        bagList = new HashMap();
    }

    public static void addBag(Bag bag) {
        bagList.put(bag.getBagIndex(), bag);
        LootbagsUtil.LogDebug("Added bag: " + bag.getBagName() + " with ID: " + bag.getBagIndex() + ".");
    }

    public static Bag getBag(int index) {
        if (!BagHandler.isIDFree(index)) {
            return bagList.get(index);
        }
        return null;
    }

    public static Bag getBag(String name) {
        for (Bag b : bagList.values()) {
            if (!b.getBagName().equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public static boolean isIDFree(int ID) {
        return !bagList.containsKey(ID);
    }

    public static HashMap<Integer, Bag> getBagList() {
        return bagList;
    }

    public static void populateBagLists() {
        for (Bag bag : bagList.values()) {
            if (bag == null) continue;
            bag.populateBag();
        }
    }

    public static int getLowestUsedID() {
        int ID = Integer.MAX_VALUE;
        for (Bag bag : bagList.values()) {
            if (bag.getBagIndex() >= ID) continue;
            ID = bag.getBagIndex();
        }
        return ID;
    }

    public static int getHighestUsedID() {
        int ID = -1;
        for (Bag bag : bagList.values()) {
            if (bag.getBagIndex() <= ID) continue;
            ID = bag.getBagIndex();
        }
        return ID;
    }

    public static ArrayList<LootItem> generateContent(Collection<LootItem> collection) {
        ArrayList<LootItem> list = new ArrayList<LootItem>();
        for (LootItem c : collection) {
            list.add(c);
        }
        return list;
    }

    public static boolean isBagEmpty(int ID) {
        if (BagHandler.isIDFree(ID)) {
            return true;
        }
        return bagList.get(ID).isBagEmpty();
    }

    public static ArrayList<Bag> getBagListRandomized() {
        ArrayList<Bag> list = new ArrayList<Bag>();
        list.addAll(bagList.values());
        Collections.shuffle(list, LootBags.getRandom());
        return list;
    }

    public static int getBagCount() {
        return bagList.size();
    }

    public static void generateBagRecipes(List recipeList) {
        for (Bag b : bagList.values()) {
            Bag source;
            if (b.getCraftingSource() == null || (source = BagHandler.getBag(b.getCraftingSource())) == null) continue;
            int bagsneeded = b.getCraftingCount();
            if (bagsneeded < 1) {
                bagsneeded = 1;
            }
            if (bagsneeded > 9) {
                bagsneeded = 9;
            }
            Object[] c = new Object[bagsneeded];
            for (int j = 0; j < c.length; ++j) {
                c[j] = new ItemStack((Item)LootBags.lootbagItem, 1, source.getBagIndex());
            }
            Object[] d = new Object[]{new ItemStack((Item)LootBags.lootbagItem, 1, b.getBagIndex())};
            if (LootBags.CRAFTTYPES == 0) continue;
            if (LootBags.CRAFTTYPES < 3) {
                recipeList.add(new LootRecipe(b.getBagItem(), c));
            }
            if (LootBags.CRAFTTYPES <= 1) continue;
            recipeList.add(new LootRecipe(new ItemStack((Item)LootBags.lootbagItem, bagsneeded, source.getBagIndex()), d));
        }
    }
}

