/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.item;

import java.util.ArrayList;
import java.util.List;
import mal.lootbags.Bag;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.rendering.IItemVarientDetails;
import mal.lootbags.rendering.ItemRenderingRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LootbagItem
extends Item
implements IItemVarientDetails {
    private final String name = "itemlootbag";

    public LootbagItem() {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName("itemlootbag"));
        this.func_77655_b("lootbags_itemlootbag");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public String getName() {
        return "itemlootbag";
    }

    public String func_77653_i(ItemStack stack) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
        Bag b = BagHandler.getBag(stack.func_77952_i());
        if (b != null) {
            return b.getBagNameColor() + s;
        }
        return s;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List list, boolean bool) {
        Bag b = BagHandler.getBag(is.func_77952_i());
        if (b == null) {
            return;
        }
        if (b.isBagEmpty()) {
            list.add(TextFormatting.RED + "Bag Disabled - Loot Table is empty.");
            list.add(TextFormatting.RED + "This is not good.");
            return;
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74767_n("generated")) {
            for (String s : b.getBagTextOpened()) {
                list.addAll(LootbagItem.parseTextCommand(s, b));
            }
        } else {
            for (String s : b.getBagTextUnopened()) {
                list.addAll(LootbagItem.parseTextCommand(s, b));
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            for (String s : b.getBagTextShift()) {
                list.addAll(LootbagItem.parseTextCommand(s, b));
            }
        }
    }

    public static ArrayList<String> parseTextCommand(String text, Bag currentBag) {
        String sret = "";
        if (currentBag == null) {
            return new ArrayList<String>();
        }
        String color = "";
        if (text.startsWith("\u00ef\u00bf\u00bd")) {
            color = text.substring(0, 2);
            text = text.substring(2);
        }
        switch (text.toUpperCase()) {
            case "DROPCHANCES": {
                sret = I18n.func_74838_a((String)("name.lootbags_" + currentBag.getBagName() + ".name")) + " drop chances: Monster: " + currentBag.getMonsterDropChance() + " Passive: " + currentBag.getPassiveDropChance() + " Player: " + currentBag.getPlayerDropChance() + " Boss: " + currentBag.getBossDropChance();
                break;
            }
            default: {
                sret = text;
            }
        }
        return LootbagsUtil.addLineBreaks(sret, color);
    }

    public static void setTagCompound(ItemStack is, ItemStack[] inventory) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList nbtinventory = new NBTTagList();
        if (inventory != null) {
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (inventory[i] != null) {
                    inventory[i].func_77955_b(var4);
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
        }
        nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
        nbt.func_74757_a("generated", true);
        is.func_77982_d(nbt);
    }

    public static ItemStack[] getInventory(ItemStack is) {
        ItemStack[] inventory = new ItemStack[5];
        NBTTagList items = is.func_77978_p().func_150295_c("inventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            ItemStack ii;
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[i] = ii = new ItemStack(item);
        }
        return inventory;
    }

    public static void generateInventory(ItemStack is) {
        boolean gen = false;
        if (is.func_77978_p() != null) {
            gen = is.func_77978_p().func_74767_n("generated");
        }
        if (!gen) {
            int numitems = LootbagItem.getNumItems(is);
            ItemStack[] items = new ItemStack[5];
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList nbtinventory = new NBTTagList();
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (i < numitems) {
                    ItemStack inv;
                    items[i] = inv = LootbagItem.getLootItem(is.func_77952_i(), i, items);
                    if (inv != null && inv.func_190916_E() > 0) {
                        inv.func_77955_b(var4);
                    }
                } else {
                    items[i] = ItemStack.field_190927_a;
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
            nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
            nbt.func_74757_a("generated", true);
            is.func_77982_d(nbt);
        }
    }

    private static ItemStack getLootItem(int damage, int slot, ItemStack[] items) {
        return LootbagItem.getLootItem(0, damage, slot, items);
    }

    private static ItemStack getLootItem(int rerollCount, int damage, int slot, ItemStack[] items) {
        boolean reroll = false;
        Bag b = BagHandler.getBag(damage);
        if (b == null) {
            LootbagsUtil.LogError("Bag at ID: " + damage + " doesn't exist!");
            return null;
        }
        if (b.getItemRepeats() == 3) {
            return b.getSpecificItem(slot);
        }
        ItemStack is = b.getRandomItem();
        if (is == null || is.func_77973_b() == null || is.func_190916_E() <= 0 || is.func_190926_b()) {
            reroll = true;
        }
        if (LootbagItem.itemAlreadyRolled(is, items, b)) {
            reroll = true;
        }
        if (reroll && rerollCount < LootBags.MAXREROLLCOUNT) {
            return LootbagItem.getLootItem(rerollCount += items.length, damage, slot, items);
        }
        if (rerollCount >= LootBags.MAXREROLLCOUNT) {
            return ItemStack.field_190927_a;
        }
        return is;
    }

    private static boolean itemAlreadyRolled(ItemStack stack, ItemStack[] items, Bag b) {
        if (items == null) {
            return false;
        }
        if (b.getItemRepeats() == 0) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].func_190926_b()) continue;
            if (b.getItemRepeats() == 1 && stack.func_77969_a(items[i])) {
                return true;
            }
            if (b.getItemRepeats() != 2 || stack.func_77973_b() != items[i].func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack is = player.func_184586_b(handIn);
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (BagHandler.isBagEmpty(is.func_77952_i())) {
                return new ActionResult(EnumActionResult.PASS, (Object)is);
            }
            LootbagItem.generateInventory(is);
            player.openGui((Object)LootBags.LootBagsInstance, 0, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)is);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack is = player.func_184586_b(hand);
            if (BagHandler.isBagEmpty(is.func_77952_i())) {
                return EnumActionResult.FAIL;
            }
            if (!player.func_70093_af()) {
                return EnumActionResult.FAIL;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IInventory) {
                LootbagItem.generateInventory(is);
                ItemStack[] iss = LootbagItem.getInventory(is);
                block0: for (int j = 0; j < iss.length; ++j) {
                    ItemStack stack = iss[j];
                    if (stack == null) continue;
                    IInventory ite = (IInventory)te;
                    int size = ite.func_70302_i_();
                    for (int i = 0; i < size; ++i) {
                        ItemStack itstack = ite.func_70301_a(i);
                        if (!ite.func_94041_b(i, stack) || itstack != null && !LootBags.areItemStacksEqualItem(itstack, stack, true, true) && ite.func_70301_a(i) != null) continue;
                        if (itstack == null) {
                            ite.func_70299_a(i, stack);
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.func_190916_E() + stack.func_190916_E() <= itstack.func_77976_d()) {
                            itstack.func_190917_f(stack.func_190916_E());
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.func_190916_E() >= itstack.func_77976_d()) continue;
                        int diff = itstack.func_77976_d() - itstack.func_190916_E();
                        ite.func_70301_a(i).func_190920_e(ite.func_70301_a(i).func_77976_d());
                        stack.func_190918_g(diff);
                        if (stack.func_190916_E() > 0) continue;
                        iss[j] = null;
                        continue block0;
                    }
                }
                LootbagItem.setTagCompound(is, iss);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77663_a(ItemStack is, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && LootbagItem.checkInventory(is)) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (LootBags.areItemStacksEqualItem(is, player.func_184592_cb(), true, true)) {
                player.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
            } else {
                player.field_71071_by.func_70304_b(itemSlot);
            }
        }
    }

    public static boolean checkInventory(ItemStack is) {
        if (is.func_77978_p() == null) {
            return false;
        }
        boolean gen = is.func_77978_p().func_74767_n("generated");
        if (gen) {
            ItemStack[] stack = LootbagItem.getInventory(is);
            if (stack == null) {
                return true;
            }
            boolean b = true;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null || stack[i] == ItemStack.field_190927_a || stack[i].func_190916_E() <= 0) continue;
                b = false;
            }
            return b;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        String base = "name.lootbags";
        Bag bag = BagHandler.getBag(stack.func_77952_i());
        if (bag == null) {
            return base + "_" + "itemlootbag";
        }
        return base + "_" + bag.getBagName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (Bag b : BagHandler.getBagList().values()) {
            if (b.getSecret() && !LootBags.SHOWSECRETBAGS) continue;
            subItems.add((Object)new ItemStack(itemIn, 1, b.getBagIndex()));
        }
    }

    @Override
    public void registerItemVariants(ItemRenderingRegister register) {
        for (Bag b : BagHandler.getBagList().values()) {
            if (b.getUseAltJson()) {
                register.reg((Item)this, b.getBagIndex(), b.getBagName());
                continue;
            }
            register.reg((Item)this, b.getBagIndex(), b.getDefaultName());
        }
    }

    private static int getNumItems(ItemStack is) {
        int max;
        Bag b = BagHandler.getBag(is.func_77952_i());
        if (b == null) {
            LootbagsUtil.LogError("Bag at ID: " + is.func_77952_i() + " doesn't exist!");
            return 0;
        }
        int min = b.getMinItems();
        if (min == (max = b.getMaxItems())) {
            return min;
        }
        return LootBags.getRandom().nextInt(max - min + 1) + min;
    }

    public boolean func_77651_p() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof LootbagItem)) {
            return super.getEntityLifespan(itemStack, world);
        }
        if (!BagHandler.isBagEmpty(itemStack.func_77952_i())) {
            return super.getEntityLifespan(itemStack, world);
        }
        return 1;
    }
}

