/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.jei;

import javax.annotation.Nonnull;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.jei.JEILoot;
import mal.lootbags.jei.LootWrapper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LootCategory
extends BlankRecipeCategory<LootWrapper> {
    protected static final int FIRSTY = 46;
    protected static final int FIRSTX = 1;
    protected static final int WIDTH = 164;
    protected static final int HEIGHT = 127;
    protected static final int ITEMSPERROW = 10;
    protected static final int ITEMSPERCOL = 5;
    protected static final int SPACINGX = 16;
    protected static final int SPACINGY = 16;
    protected static final int ITEMSPERPAGE = 50;
    @Nonnull
    private final IDrawable background;

    public LootCategory() {
        ResourceLocation location = new ResourceLocation("lootbags", "textures/gui/jei_lootbag_gui.png");
        this.background = JEILoot.getJEIHelpers().getGuiHelper().createDrawable(location, 0, 0, 164, 127);
    }

    public String getUid() {
        return "lootbags.loot";
    }

    public String getTitle() {
        return LootbagsUtil.translateToLocal("jei.loot.title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull LootWrapper wrapper, @Nonnull IIngredients ingredients) {
        int x = 1;
        int y = 46;
        layout.getItemStacks().init(0, true, 74, 2);
        for (int i = 1; i < Math.min(50, ingredients.getOutputs(ItemStack.class).size()) + 1; ++i) {
            layout.getItemStacks().init(i, false, x, y);
            if ((x += 16) < 161) continue;
            x = 1;
            y += 16;
        }
        layout.getItemStacks().addTooltipCallback((ITooltipCallback)wrapper);
        IFocus focus = layout.getFocus();
        int slots = Math.min(wrapper.amountOfItems((IFocus<ItemStack>)focus), 50);
        layout.getItemStacks().set(0, wrapper.getBag());
        for (int i = 0; i < slots; ++i) {
            layout.getItemStacks().set(i + 1, wrapper.getItems((IFocus<ItemStack>)focus, i, slots));
        }
    }

    public String getModName() {
        return "Lootbags";
    }
}

