/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.loot;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import mal.lootbags.LootbagsUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class LootItem
extends WeightedRandom.Item
implements Comparable<LootItem> {
    private ItemStack item;
    private String modid;
    private String name;
    private LootEntryItem lootitem;
    private int damage;
    private int minstack;
    private int maxstack;
    private byte[] nbt;
    private boolean generalItem = false;

    public LootItem(@Nullable LootEntryItem lootitem, ItemStack item, String modid, String itemname, int minstack, int maxstack, int weight, boolean isgeneral) {
        super(weight);
        this.lootitem = lootitem;
        this.item = item;
        this.modid = modid;
        this.name = itemname;
        this.damage = item.func_77952_i();
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.generalItem = isgeneral;
        try {
            if (item.func_77978_p() != null) {
                this.nbt = LootbagsUtil.compress(item.func_77978_p());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LootItem(@Nullable LootEntryItem lootitem, ItemStack item, int minstack, int maxstack, int weight, boolean isgeneral) {
        super(weight);
        this.lootitem = lootitem;
        try {
            this.modid = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).func_110624_b();
            this.name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).func_110623_a();
        }
        catch (Exception e) {
            LootbagsUtil.LogError("Mod/Item ID lookup failed for: " + item.toString() + ". This is likely an issue caused by a different mod.");
        }
        this.item = item;
        this.damage = item.func_77952_i();
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.generalItem = isgeneral;
        try {
            if (item.func_77978_p() != null) {
                this.nbt = LootbagsUtil.compress(item.func_77978_p());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LootItem(@Nullable LootEntryItem lootitem, String modid, String itemname, int damage, int minstack, int maxstack, int weight, boolean isgeneral) {
        super(weight);
        this.lootitem = lootitem;
        ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, itemname)), 1);
        this.modid = modid;
        this.name = itemname;
        this.damage = damage;
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.nbt = null;
        this.generalItem = isgeneral;
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() != null) {
            stack.func_190920_e(maxstack);
            stack.func_77964_b(damage);
            if (stack.func_190916_E() > stack.func_77976_d()) {
                stack.func_190920_e(stack.func_77976_d());
            }
            if (stack.func_190916_E() < 1) {
                stack.func_190920_e(1);
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (minstack > maxstack) {
                minstack = maxstack;
            }
            this.item = stack;
        }
    }

    public LootItem(@Nullable LootEntryItem lootitem, String modid, String itemname, int damage, int minstack, int maxstack, int weight, byte[] nbt, boolean isgeneral) {
        super(weight);
        this.lootitem = lootitem;
        ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, itemname)), 1);
        this.modid = modid;
        this.name = itemname;
        this.damage = damage;
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.nbt = nbt;
        this.generalItem = isgeneral;
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, itemname));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, itemname));
            if (item != null) {
                stack = new ItemStack(item, maxstack, damage);
            } else if (block != null) {
                stack = new ItemStack(block, maxstack, damage);
            }
        }
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() != null) {
            stack.func_190920_e(maxstack);
            stack.func_77964_b(damage);
            ByteArrayInputStream st = new ByteArrayInputStream(nbt);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)st);
                stack.func_77982_d(tag);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stack.func_190916_E() > stack.func_77976_d()) {
                stack.func_190920_e(stack.func_77976_d());
            }
            if (stack.func_190916_E() < 1) {
                stack.func_190920_e(1);
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (minstack > maxstack) {
                minstack = maxstack;
            }
            this.item = stack;
        }
    }

    public void reinitializeLootItem() {
        ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.modid, this.name)), 1);
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.modid, this.name));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.modid, this.name));
            if (item != null) {
                stack = new ItemStack(item, this.maxstack, this.damage);
            } else if (block != null) {
                stack = new ItemStack(block, this.maxstack, this.damage);
            }
        }
        if (stack != null && !stack.func_190926_b() && stack != ItemStack.field_190927_a && stack.func_77973_b() != null) {
            stack.func_190920_e(this.maxstack);
            stack.func_77964_b(this.damage);
            if (this.nbt != null) {
                ByteArrayInputStream st = new ByteArrayInputStream(this.nbt);
                try {
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)st);
                    stack.func_77982_d(tag);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stack.func_190916_E() > stack.func_77976_d()) {
                stack.func_190920_e(stack.func_77976_d());
            }
            if (stack.func_190916_E() < 1) {
                stack.func_190920_e(1);
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (this.minstack > this.maxstack) {
                this.minstack = this.maxstack;
            }
            this.item = stack;
        } else {
            LootbagsUtil.LogInfo("Loot Item with name: " + this.modid + ":" + this.name + " did not find an item with that name and mod ID. Ensure that the information is correct.");
        }
    }

    public ItemStack getContentItem() {
        return this.item;
    }

    public String getItemName() {
        return this.name;
    }

    public String getItemModID() {
        return this.modid;
    }

    public int getItemWeight() {
        return this.field_76292_a;
    }

    public void setItemWeight(int weight) {
        this.field_76292_a = weight;
    }

    public boolean getGeneral() {
        return this.generalItem;
    }

    public int getMinStack() {
        return this.minstack;
    }

    public int getMaxStack() {
        return this.maxstack;
    }

    public LootEntryItem getLootItem() {
        return this.lootitem;
    }

    public String toString() {
        return this.item.toString() + ":" + this.minstack + ":" + this.maxstack + ":" + this.field_76292_a;
    }

    public LootItem copy() {
        return new LootItem(this.lootitem, this.item, this.modid, this.name, this.minstack, this.maxstack, this.field_76292_a, this.generalItem);
    }

    @Override
    public int compareTo(LootItem loot) {
        if (this.field_76292_a > loot.getItemWeight()) {
            return 1;
        }
        if (this.field_76292_a < loot.getItemWeight()) {
            return -1;
        }
        return 0;
    }
}

