/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import java.lang.reflect.Field;
import java.util.Random;
import mal.lootbags.LootBags;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;

public class LootEntryItemAccess {
    public static int getLootEntryItemWeight(LootEntry item) {
        return item.field_186364_c;
    }

    public static ItemStack getLootEntryItemStack(LootEntryItem item) {
        ItemStack itemstack = new ItemStack(item.field_186368_a);
        return LootEntryItemAccess.applyMetadata(item, itemstack);
    }

    public static LootTable getLootTable(LootEntryTable table, LootContext context) {
        ResourceLocation rtable = table.field_186371_a;
        return context.func_186497_e().func_186521_a(rtable);
    }

    public static RandomValueRange getStackSizes(LootEntryItem item) {
        for (int i = 0; i < item.field_186369_b.length; ++i) {
            LootFunction lootfunction = item.field_186369_b[i];
            if (!(lootfunction instanceof SetCount)) continue;
            try {
                String cRng = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? "countRange" : "field_186568_a";
                Field countRangeField = SetCount.class.getDeclaredField(cRng);
                countRangeField.setAccessible(true);
                RandomValueRange range = (RandomValueRange)countRangeField.get(lootfunction);
                return range;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ItemStack applyFunctions(LootEntryItem item, ItemStack stack, LootContext context) {
        if (item == null) {
            return stack;
        }
        for (LootFunction lootfunction : item.field_186369_b) {
            if (!LootConditionManager.func_186638_a((LootCondition[])lootfunction.func_186554_a(), (Random)LootBags.getRandom(), (LootContext)context)) continue;
            stack = lootfunction.func_186553_a(stack, LootBags.getRandom(), context);
        }
        return stack;
    }

    private static ItemStack applyMetadata(LootEntryItem item, ItemStack stack) {
        if (item == null) {
            return stack;
        }
        for (LootFunction lootfunction : item.field_186369_b) {
            if (!(lootfunction instanceof SetDamage) && !(lootfunction instanceof SetMetadata)) continue;
            stack = lootfunction.func_186553_a(stack, LootBags.getRandom(), null);
        }
        return stack;
    }
}

