/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WildfirePlayerList
extends ExtendedList<Entry> {
    private static final ResourceLocation TXTR_SYNC = new ResourceLocation("wildfire_gender", "textures/sync.png");
    private static final ResourceLocation TXTR_CACHED = new ResourceLocation("wildfire_gender", "textures/cached.png");
    private static final ResourceLocation TXTR_UNKNOWN = new ResourceLocation("wildfire_gender", "textures/unknown.png");
    private final int listWidth;
    private WildfirePlayerListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtils.func_76338_a((String)value);
    }

    public WildfirePlayerList(WildfirePlayerListScreen parent, int listWidth, int top, int bottom) {
        super(parent.getMinecraft(), parent.field_230708_k_ - 4, parent.field_230709_l_, top - 6, bottom, 20);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int func_230952_d_() {
        return this.parent.field_230708_k_ / 2 + 53;
    }

    public int func_230949_c_() {
        return this.listWidth;
    }

    public void refreshList() {
        this.func_230963_j_();
        NetworkPlayerInfo[] playersC = this.field_230668_b_.func_147114_u().func_175106_d().toArray(new NetworkPlayerInfo[this.field_230668_b_.func_147114_u().func_175106_d().size()]);
        for (int h = 0; h < playersC.length; ++h) {
            NetworkPlayerInfo loadedPlayer = playersC[h];
            this.func_230513_b_((AbstractList.AbstractListEntry)new Entry(loadedPlayer, false));
        }
    }

    protected void func_230433_a_(MatrixStack mStack) {
    }

    public boolean isLoadingPlayers() {
        boolean loadingPlayers = false;
        for (int i = 0; i < this.func_231039_at__().size(); ++i) {
            GenderPlayer aPlr = WildfireGender.getPlayerByName(((Entry)((Object)this.func_231039_at__().get((int)i))).nInfo.func_178845_a().getId().toString());
            if (aPlr != null) continue;
            loadingPlayers = true;
        }
        return loadingPlayers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Entry
    extends AbstractOptionList.Entry<Entry> {
        private final String name;
        private final boolean gender;
        public final NetworkPlayerInfo nInfo;
        private final WildfireButton btnOpenGUI;

        private Entry(NetworkPlayerInfo nInfo, boolean gender) {
            this.nInfo = nInfo;
            this.name = nInfo.func_178845_a().getName();
            this.gender = gender;
            this.btnOpenGUI = new WildfireButton(0, 0, 112, 20, (ITextComponent)new StringTextComponent(""), button -> {
                GenderPlayer aPlr = WildfireGender.getPlayerByName(nInfo.func_178845_a().getId().toString());
                if (aPlr == null) {
                    return;
                }
                try {
                    Minecraft.func_71410_x().func_147108_a((Screen)new WardrobeBrowserScreen(WildfirePlayerList.this.parent, nInfo.func_178845_a().getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            GenderPlayer aPlr = WildfireGender.getPlayerByName(nInfo.func_178845_a().getId().toString());
            if (aPlr != null) {
                this.btnOpenGUI.field_230693_o_ = !aPlr.lockSettings;
            }
        }

        public NetworkPlayerInfo getNetworkInfo() {
            return this.nInfo;
        }

        public void func_230432_a_(MatrixStack m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            FontRenderer font = ((WildfirePlayerList)WildfirePlayerList.this).field_230668_b_.field_71466_p;
            String tooltip = "";
            PlayerEntity playerentity = ((WildfirePlayerList)WildfirePlayerList.this).field_230668_b_.field_71441_e.func_217371_b(this.nInfo.func_178845_a().getId());
            GenderPlayer aPlr = WildfireGender.getPlayerByName(this.nInfo.func_178845_a().getId().toString());
            boolean flag1 = false;
            WildfirePlayerList.this.field_230668_b_.func_110434_K().func_110577_a(this.nInfo.func_178837_g());
            int i3 = 8 + (flag1 ? 8 : 0);
            int j3 = 8 * (flag1 ? -1 : 1);
            AbstractGui.func_238466_a_((MatrixStack)m, (int)(left + 2), (int)(top + 2), (int)16, (int)16, (float)8.0f, (float)i3, (int)8, (int)j3, (int)64, (int)64);
            if (playerentity != null && playerentity.func_175148_a(PlayerModelPart.HAT)) {
                int k3 = 8 + (flag1 ? 8 : 0);
                int l3 = 8 * (flag1 ? -1 : 1);
                AbstractGui.func_238466_a_((MatrixStack)m, (int)(left + 1), (int)(top + 1), (int)18, (int)18, (float)40.0f, (float)k3, (int)8, (int)l3, (int)64, (int)64);
            }
            font.func_238421_b_(m, this.name, (float)(left + 23), (float)(top + 2), 0xFFFFFF);
            if (aPlr != null) {
                this.btnOpenGUI.field_230693_o_ = !aPlr.lockSettings;
                switch (aPlr.gender) {
                    case 0: {
                        font.func_238421_b_(m, TextFormatting.LIGHT_PURPLE + new TranslationTextComponent("wildfire_gender.label.female").getString(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
                        break;
                    }
                    case 1: {
                        font.func_238421_b_(m, TextFormatting.BLUE + new TranslationTextComponent("wildfire_gender.label.male").getString(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
                        break;
                    }
                    case 2: {
                        font.func_238421_b_(m, TextFormatting.GREEN + new TranslationTextComponent("wildfire_gender.label.other").getString(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
                    }
                }
                if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.SYNCED) {
                    WildfirePlayerList.this.field_230668_b_.func_110434_K().func_110577_a(TXTR_SYNC);
                    AbstractGui.func_238466_a_((MatrixStack)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                    if (mouseX > left + 98 - 2 && mouseY > top + 11 - 2 && mouseX < left + 98 + 12 + 2 && mouseY < top + 20) {
                        WildfirePlayerList.this.parent.setTooltip(new TranslationTextComponent("wildfire_gender.player_list.state.synced").getString());
                    }
                } else if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.UNKNOWN) {
                    WildfirePlayerList.this.field_230668_b_.func_110434_K().func_110577_a(TXTR_UNKNOWN);
                    AbstractGui.func_238466_a_((MatrixStack)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                }
            } else {
                this.btnOpenGUI.field_230693_o_ = false;
                font.func_238421_b_(m, TextFormatting.RED + new StringTextComponent("Too Far Away").getString(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
            }
            this.btnOpenGUI.field_230690_l_ = left;
            this.btnOpenGUI.field_230691_m_ = top;
            this.btnOpenGUI.func_230430_a_(m, mouseX, mouseY, partialTicks);
            if (this.btnOpenGUI.func_230449_g_()) {
                WildfirePlayerListScreen.HOVER_PLAYER = aPlr;
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)((Object)this.btnOpenGUI));
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.btnOpenGUI.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.btnOpenGUI.func_231048_c_(mouseX, mouseY, button);
        }
    }
}

