/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.WildfireSlider;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.lwjgl.opengl.GL11;

public class WildfireCharacterSettingsScreen
extends Screen {
    private WildfireSlider bounceSlider;
    private WildfireSlider floppySlider;
    private ResourceLocation BACKGROUND;
    private float preBounceMult = 0.0f;
    private float preFloppyMult = 0.0f;
    private boolean changedSlider = false;
    private boolean changedFloppySlider = false;
    private Screen parent;
    private UUID playerUUID;
    private int yPos = 0;
    boolean enablePhysics;
    boolean enablePhysicsArmor;
    boolean enableHurtSounds;
    boolean enableShowInArmor;
    float bounceMult;
    float floppyMult;

    protected WildfireCharacterSettingsScreen(Screen parent, UUID uuid) {
        super((ITextComponent)new TranslationTextComponent("Gender Settings"));
        this.parent = parent;
        this.playerUUID = uuid;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        Minecraft m = Minecraft.func_71410_x();
        GenderPlayer aPlr = WildfireGender.getPlayerByName(this.playerUUID.toString());
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        this.yPos = y - 47;
        this.enablePhysics = aPlr.breast_physics;
        this.enablePhysicsArmor = aPlr.breast_physics_armor;
        this.enableShowInArmor = aPlr.show_in_armor;
        this.enableHurtSounds = aPlr.hurtSounds;
        this.bounceMult = aPlr.bounceMultiplier;
        this.floppyMult = aPlr.floppyMultiplier;
        this.func_230480_a_((Widget)new WildfireButton(this.field_230708_k_ / 2 - 78 - 1, this.yPos, 157, 20, (ITextComponent)new StringTextComponent("Breast Physics: " + (this.enablePhysics ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")), button -> {
            this.enablePhysics ^= true;
            button.func_238482_a_((ITextComponent)new StringTextComponent("Breast Physics: " + (this.enablePhysics ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")));
            aPlr.breast_physics = this.enablePhysics;
            GenderPlayer.saveGenderInfo(aPlr);
        }, new WildfireButton.ITooltip(){

            @Override
            public void onTooltip(WildfireButton button, MatrixStack matrices, int mouseX, int mouseY) {
                WildfireCharacterSettingsScreen.this.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Enable / Disable Breast Physics"), mouseX, mouseY);
            }
        }));
        this.func_230480_a_((Widget)new WildfireButton(this.field_230708_k_ / 2 - 78 - 1, this.yPos + 20, 157, 20, (ITextComponent)new StringTextComponent("Armor Physics: " + (this.enablePhysicsArmor ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")), button -> {
            this.enablePhysicsArmor ^= true;
            button.func_238482_a_((ITextComponent)new StringTextComponent("Armor Physics: " + (this.enablePhysicsArmor ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")));
            aPlr.breast_physics_armor = this.enablePhysicsArmor;
            GenderPlayer.saveGenderInfo(aPlr);
        }, new WildfireButton.ITooltip(){

            @Override
            public void onTooltip(WildfireButton button, MatrixStack matrices, int mouseX, int mouseY) {
                WildfireCharacterSettingsScreen.this.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Enables Physics With Armor Equipped"), mouseX, mouseY);
            }
        }));
        this.func_230480_a_((Widget)new WildfireButton(this.field_230708_k_ / 2 - 78 - 1, this.yPos + 40, 157, 20, (ITextComponent)new StringTextComponent("Hide In Armor: " + (!this.enableShowInArmor ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")), button -> {
            this.enableShowInArmor ^= true;
            button.func_238482_a_((ITextComponent)new StringTextComponent("Hide In Armor: " + (!this.enableShowInArmor ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")));
            aPlr.show_in_armor = this.enableShowInArmor;
            GenderPlayer.saveGenderInfo(aPlr);
        }, new WildfireButton.ITooltip(){

            @Override
            public void onTooltip(WildfireButton button, MatrixStack matrices, int mouseX, int mouseY) {
                WildfireCharacterSettingsScreen.this.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Hide Breast Model When Wearing Armor"), mouseX, mouseY);
            }
        }));
        this.bounceSlider = new WildfireSlider(this.field_230708_k_ / 2 - 80 + 1, this.yPos + 60, 157, 20, (ITextComponent)new StringTextComponent(""), this.field_230704_d_, 0.0, 1.0, this.bounceMult, false, false, new Button.IPressable(){

            public void onPress(Button arg0) {
            }
        }, new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
            }
        });
        this.func_230480_a_((Widget)this.bounceSlider);
        this.floppySlider = new WildfireSlider(this.field_230708_k_ / 2 - 80 + 1, this.yPos + 80, 157, 20, (ITextComponent)new StringTextComponent(""), this.field_230704_d_, 0.0, 1.0, this.floppyMult, false, false, new Button.IPressable(){

            public void onPress(Button arg0) {
            }
        }, new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
            }
        });
        this.func_230480_a_((Widget)this.floppySlider);
        this.func_230480_a_((Widget)new WildfireButton(this.field_230708_k_ / 2 - 78 - 1, this.yPos + 100, 157, 20, (ITextComponent)new StringTextComponent("Female Hurt Sounds: " + (this.enableHurtSounds ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")), button -> {
            this.enableHurtSounds ^= true;
            button.func_238482_a_((ITextComponent)new StringTextComponent("Female Hurt Sounds: " + (this.enableHurtSounds ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled")));
            aPlr.hurtSounds = this.enableHurtSounds;
            GenderPlayer.saveGenderInfo(aPlr);
        }, new WildfireButton.ITooltip(){

            @Override
            public void onTooltip(WildfireButton button, MatrixStack matrices, int mouseX, int mouseY) {
                ArrayList<StringTextComponent> list = new ArrayList<StringTextComponent>();
                list.add(new StringTextComponent("Enables Custom Hurt Sounds."));
                list.add(new StringTextComponent(TextFormatting.RED + "Mod Needed On Server To Work!"));
                List orderedList = Lists.transform(list, ITextComponent::func_241878_f);
                RenderSystem.disableDepthTest();
                WildfireCharacterSettingsScreen.this.func_238654_b_(matrices, orderedList, mouseX, mouseY);
                RenderSystem.enableDepthTest();
            }
        }));
        this.func_230480_a_((Widget)new WildfireButton(this.field_230708_k_ / 2 + 73, this.yPos - 11, 9, 9, (ITextComponent)new StringTextComponent("X"), button -> Minecraft.func_71410_x().func_147108_a(this.parent)));
        this.BACKGROUND = new ResourceLocation("wildfire_gender", "textures/gui/settings_bg.png");
        super.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack m, int f1, int f2, float f3) {
        float bounceText;
        super.func_230446_a_(m);
        PlayerEntity plrEntity = Minecraft.func_71410_x().field_71441_e.func_217371_b(this.playerUUID);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.BACKGROUND != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BACKGROUND);
        }
        int i = (this.field_230708_k_ - 172) / 2;
        int j = (this.field_230709_l_ - 124) / 2;
        this.func_238474_b_(m, i, j, 0, 0, 172, 144);
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        this.field_230712_o_.func_243248_b(m, (ITextComponent)new TranslationTextComponent("wildfire_gender.char_settings.title"), (float)(x - 79), (float)(this.yPos - 10), 0x444444);
        if (this.preBounceMult != (float)this.bounceSlider.getValue()) {
            this.bounceMult = (float)this.bounceSlider.getValue();
            this.preBounceMult = (float)this.bounceSlider.getValue();
            this.changedSlider = true;
        }
        if (this.preFloppyMult != (float)this.floppySlider.getValue()) {
            this.floppyMult = (float)this.floppySlider.getValue();
            this.preFloppyMult = (float)this.floppySlider.getValue();
            this.changedFloppySlider = true;
        }
        super.func_230430_a_(m, f1, f2, f3);
        if (plrEntity != null) {
            Screen.func_238471_a_((MatrixStack)m, (FontRenderer)this.field_230712_o_, (String)plrEntity.func_145748_c_().getString(), (int)x, (int)(this.yPos - 30), (int)0xFFFFFF);
        }
        if ((float)Math.round((bounceText = this.bounceMult * 3.0f) * 10.0f) / 10.0f == 3.0f) {
            this.field_230712_o_.func_238421_b_(m, "#Anime Breast Physics!!!", (float)(x - 72), (float)(this.yPos + 67), this.bounceSlider.func_231047_b_(f1, f2) || this.changedSlider ? 0xFFFF55 : 0xFFFFFF);
        } else if ((float)Math.round(bounceText * 100.0f) / 100.0f == 0.0f) {
            this.field_230712_o_.func_238421_b_(m, "Why Are Physics Even On?", (float)(x - 72), (float)(this.yPos + 67), this.bounceSlider.func_231047_b_(f1, f2) || this.changedSlider ? 0xFFFF55 : 0xFFFFFF);
        } else {
            this.field_230712_o_.func_238421_b_(m, "Bounce Intensity: " + (float)Math.round(bounceText * 10.0f) / 10.0f + "x", (float)(x - 72), (float)(this.yPos + 67), this.bounceSlider.func_231047_b_(f1, f2) || this.changedSlider ? 0xFFFF55 : 0xFFFFFF);
        }
        this.field_230712_o_.func_238421_b_(m, "Breast Momentum: " + Math.round(this.floppyMult * 100.0f) + "%", (float)(x - 72), (float)(this.yPos + 87), this.floppySlider.func_231047_b_(f1, f2) || this.changedFloppySlider ? 0xFFFF55 : 0xFFFFFF);
        if ((float)Math.round(bounceText * 10.0f) / 10.0f > 1.0f) {
            Screen.func_238471_a_((MatrixStack)m, (FontRenderer)this.field_230712_o_, (String)(TextFormatting.ITALIC + "Setting 'Bounce Intensity' to a high value will look very unnatural!"), (int)x, (int)(y + 90), (int)0xFF6666);
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        Minecraft m = Minecraft.func_71410_x();
        GenderPlayer aPlr = WildfireGender.getPlayerByName(this.playerUUID.toString());
        if (this.changedSlider) {
            aPlr.bounceMultiplier = this.bounceMult = (float)this.bounceSlider.getValue();
            GenderPlayer.saveGenderInfo(aPlr);
            this.changedSlider = false;
            this.bounceSlider.dragging = false;
        }
        if (this.changedFloppySlider) {
            aPlr.floppyMultiplier = this.floppyMult = (float)this.floppySlider.getValue();
            GenderPlayer.saveGenderInfo(aPlr);
            this.changedFloppySlider = false;
            this.floppySlider.dragging = false;
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }
}

