/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.main.Breasts;
import com.wildfire.main.Configuration;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.physics.BreastPhysics;
import org.json.simple.JSONObject;

public class GenderPlayer {
    public String username;
    public int gender;
    public float pBustSize = 0.6f;
    public boolean hurtSounds = true;
    public boolean breast_physics = false;
    public boolean breast_physics_armor = false;
    public float bounceMultiplier = 0.34f;
    public float floppyMultiplier = 0.95f;
    public String preCapeURL = "";
    public boolean lockSettings = false;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    public boolean show_in_armor = false;
    private Configuration cfg;
    private BreastPhysics lBreastPhysics = new BreastPhysics(this);
    private BreastPhysics rBreastPhysics = new BreastPhysics(this);
    private Breasts breasts = new Breasts();

    public GenderPlayer(String username) {
        this(username, 1);
    }

    public GenderPlayer(String username, int gender) {
        this.username = username;
        this.gender = gender;
        this.cfg = new Configuration("WildfireGender", this.username);
        this.cfg.setDefaultParameter("username", "NOT_AVAILABLE");
        this.cfg.setDefaultParameter("gender", 1);
        this.cfg.setDefaultParameter("bust_size", Float.valueOf(0.6f));
        this.cfg.setDefaultParameter("cape_url", "");
        this.cfg.setDefaultParameter("show_elytra", true);
        this.cfg.setDefaultParameter("hurt_sounds", true);
        this.cfg.setDefaultParameter("breasts_xOffset", 0);
        this.cfg.setDefaultParameter("breasts_yOffset", 0);
        this.cfg.setDefaultParameter("breasts_zOffset", 0);
        this.cfg.setDefaultParameter("breasts_uniboob", true);
        this.cfg.setDefaultParameter("breasts_cleavage", "0.05");
        this.cfg.setDefaultParameter("breast_physics", false);
        this.cfg.setDefaultParameter("breast_physics_armor", false);
        this.cfg.setDefaultParameter("show_in_armor", true);
        this.cfg.setDefaultParameter("bounce_multiplier", "0.34");
        this.cfg.setDefaultParameter("floppy_multiplier", "0.95");
        this.cfg.finish();
    }

    public void sendNetwork() {
    }

    public void getNetwork() {
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public float getBounceMultiplier() {
        float bounceMult = Float.valueOf(this.bounceMultiplier).floatValue();
        return (float)Math.round(bounceMult * 3.0f * 100.0f) / 100.0f;
    }

    public float getFloppiness() {
        return Float.valueOf(this.floppyMultiplier).floatValue();
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public void updateBustSize(float v) {
        this.pBustSize = v;
    }

    public static JSONObject toJSONObject(GenderPlayer plr) {
        JSONObject obj = new JSONObject();
        obj.put("username", plr.username);
        obj.put("gender", plr.gender);
        obj.put("bust_size", Float.valueOf(plr.pBustSize));
        obj.put("hurt_sounds", plr.hurtSounds);
        obj.put("breast_physics", plr.breast_physics);
        obj.put("breast_physics_armor", plr.breast_physics_armor);
        obj.put("show_in_armor", plr.show_in_armor);
        obj.put("bounce_multiplier", Float.valueOf(plr.bounceMultiplier));
        obj.put("floppy_multiplier", Float.valueOf(plr.floppyMultiplier));
        obj.put("breasts_xOffset", Float.valueOf(plr.getBreasts().xOffset));
        obj.put("breasts_yOffset", Float.valueOf(plr.getBreasts().yOffset));
        obj.put("breasts_zOffset", Float.valueOf(plr.getBreasts().zOffset));
        obj.put("breasts_uniboob", plr.getBreasts().isUniboob);
        obj.put("breasts_cleavage", Float.valueOf(plr.getBreasts().cleavage));
        return obj;
    }

    public void toJSONObject() {
        GenderPlayer.toJSONObject(this);
    }

    public static GenderPlayer fromJSONObject(JSONObject obj) {
        GenderPlayer plr = new GenderPlayer(obj.get("username").toString());
        plr.gender = Integer.valueOf(obj.get("gender").toString());
        plr.pBustSize = Float.valueOf(obj.get("bust_size").toString()).floatValue();
        plr.hurtSounds = Boolean.valueOf(obj.get("hurt_sounds").toString());
        plr.breast_physics = Boolean.valueOf(obj.get("breast_physics").toString());
        plr.breast_physics_armor = Boolean.valueOf(obj.get("breast_physics_armor").toString());
        plr.show_in_armor = Boolean.valueOf(obj.get("show_in_armor").toString());
        plr.bounceMultiplier = Float.valueOf(obj.get("bounce_multiplier").toString()).floatValue();
        plr.floppyMultiplier = Float.valueOf(obj.get("floppy_multiplier").toString()).floatValue();
        plr.getBreasts().xOffset = Float.valueOf(obj.get("breasts_xOffset").toString()).floatValue();
        plr.getBreasts().yOffset = Float.valueOf(obj.get("breasts_yOffset").toString()).floatValue();
        plr.getBreasts().zOffset = Float.valueOf(obj.get("breasts_zOffset").toString()).floatValue();
        plr.getBreasts().isUniboob = Boolean.valueOf(obj.get("breasts_uniboob").toString());
        plr.getBreasts().cleavage = Float.valueOf(obj.get("breasts_cleavage").toString()).floatValue();
        return plr;
    }

    public static GenderPlayer loadSyncedPlayer(String uuid) {
        GenderPlayer plr = WildfireHelper.getPlayerData(uuid);
        if (plr != null) {
            plr.syncStatus = SyncStatus.SYNCED;
        }
        return plr;
    }

    public static GenderPlayer loadCachedPlayer(String uuid) {
        GenderPlayer plr = WildfireGender.getPlayerByName(uuid);
        if (plr != null) {
            plr.lockSettings = false;
            plr.syncStatus = SyncStatus.CACHED;
            try {
                plr.gender = Integer.valueOf(plr.getConfig().getParameter("gender").toString());
            }
            catch (Exception e) {
                plr.gender = Boolean.valueOf(plr.getConfig().getParameter("gender").toString()) != false ? 1 : 0;
            }
            plr.updateBustSize(Float.valueOf(plr.getConfig().getParameter("bust_size").toString()).floatValue());
            plr.hurtSounds = plr.getConfig().getBool("hurt_sounds");
            plr.breast_physics = plr.getConfig().getBool("breast_physics");
            plr.breast_physics_armor = plr.getConfig().getBool("breast_physics_armor");
            plr.show_in_armor = plr.getConfig().getBool("show_in_armor");
            plr.bounceMultiplier = Float.valueOf(plr.getConfig().getParameter("bounce_multiplier").toString()).floatValue();
            plr.floppyMultiplier = Float.valueOf(plr.getConfig().getParameter("floppy_multiplier").toString()).floatValue();
            plr.getBreasts().xOffset = Float.valueOf(plr.getConfig().getParameter("breasts_xOffset").toString()).floatValue();
            plr.getBreasts().yOffset = Float.valueOf(plr.getConfig().getParameter("breasts_yOffset").toString()).floatValue();
            plr.getBreasts().zOffset = Float.valueOf(plr.getConfig().getParameter("breasts_zOffset").toString()).floatValue();
            plr.getBreasts().isUniboob = Boolean.valueOf(plr.getConfig().getParameter("breasts_uniboob").toString());
            plr.getBreasts().cleavage = Float.valueOf(plr.getConfig().getParameter("breasts_cleavage").toString()).floatValue();
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        plr.getConfig().setParameter("username", plr.username);
        plr.getConfig().setParameter("gender", plr.gender);
        plr.getConfig().setParameter("bust_size", Float.valueOf(plr.getBustSize()));
        plr.getConfig().setParameter("hurt_sounds", plr.hurtSounds);
        plr.getConfig().setParameter("breast_physics", plr.breast_physics);
        plr.getConfig().setParameter("breast_physics_armor", plr.breast_physics_armor);
        plr.getConfig().setParameter("show_in_armor", plr.show_in_armor);
        plr.getConfig().setParameter("bounce_multiplier", Float.valueOf(plr.bounceMultiplier));
        plr.getConfig().setParameter("floppy_multiplier", Float.valueOf(plr.floppyMultiplier));
        plr.getConfig().setParameter("breasts_xOffset", Float.valueOf(plr.getBreasts().xOffset));
        plr.getConfig().setParameter("breasts_yOffset", Float.valueOf(plr.getBreasts().yOffset));
        plr.getConfig().setParameter("breasts_zOffset", Float.valueOf(plr.getBreasts().zOffset));
        plr.getConfig().setParameter("breasts_uniboob", plr.getBreasts().isUniboob);
        plr.getConfig().setParameter("breasts_cleavage", Float.valueOf(plr.getBreasts().cleavage));
        plr.getConfig().save();
    }

    public Breasts getBreasts() {
        return this.breasts;
    }

    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

