/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireCommonEvents;
import com.wildfire.main.networking.PacketHurt;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.main.networking.PacketSync;
import com.wildfire.main.proxy.GenderClient;
import com.wildfire.main.proxy.GenderServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="wildfire_gender")
public class WildfireGender {
    public static final String VERSION = "2.8";
    public static final String MODID = "wildfire_gender";
    public static boolean modEnabled = true;
    public static final boolean SYNCING_ENABLED = false;
    private static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("wildfire_gender", "main_channel")).clientAcceptedVersions(v -> v == NetworkRegistry.ABSENT || v == NetworkRegistry.ACCEPTVANILLA || v.equals(PROTOCOL_VERSION)).serverAcceptedVersions(v -> v == NetworkRegistry.ACCEPTVANILLA || v.equals(PROTOCOL_VERSION)).networkProtocolVersion(() -> "1").simpleChannel();
    public static ArrayList<GenderPlayer> CLOTHING_PLAYER = new ArrayList();
    public static ArrayList<GenderPlayer> SERVER_PLAYER = new ArrayList();
    public static final GenderServer PROXY = (GenderServer)DistExecutor.safeRunForDist(() -> GenderClient::new, () -> GenderServer::new);

    public WildfireGender() {
        File f = new File(System.getProperty("user.dir") + "/config/KittGender/");
        if (f.exists()) {
            boolean bl = f.renameTo(new File(System.getProperty("user.dir") + "/config/WildfireGender/"));
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
    }

    public static GenderPlayer getPlayerByName(String username) {
        for (int i = 0; i < CLOTHING_PLAYER.size(); ++i) {
            try {
                if (!username.toLowerCase().equals(WildfireGender.CLOTHING_PLAYER.get((int)i).username.toLowerCase())) continue;
                return CLOTHING_PLAYER.get(i);
            }
            catch (Exception e) {
                GenderPlayer plr = new GenderPlayer(username);
                CLOTHING_PLAYER.add(plr);
                return plr;
            }
        }
        return null;
    }

    public void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new WildfireCommonEvents());
        NETWORK.registerMessage(1, PacketSync.class, PacketSync::encode, PacketSync::new, PacketSync::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, PacketSendGenderInfo.class, PacketSendGenderInfo::encode, PacketSendGenderInfo::new, PacketSendGenderInfo::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(3, PacketHurt.class, PacketHurt::encode, PacketHurt::new, PacketHurt::handle);
    }

    public void setupClient(FMLClientSetupEvent event) {
        PROXY.register();
    }

    public static void loadGenderInfoAsync(final String uuid) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                WildfireGender.loadGenderInfo(uuid);
            }
        });
        thread.setName("WFGM_GetPlayer-" + uuid);
        thread.start();
    }

    public static void refreshAllGenders() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
    }

    public static GenderPlayer loadGenderInfo(String uuid) {
        GenderPlayer syncPlr = GenderPlayer.loadSyncedPlayer(uuid);
        if (syncPlr != null) {
            return syncPlr;
        }
        GenderPlayer plr = GenderPlayer.loadCachedPlayer(uuid);
        return plr;
    }

    public static void drawTextLabel(MatrixStack m, String txt, int x, int y) {
        GlStateManager.func_227737_l_();
        AbstractGui.func_238467_a_((MatrixStack)m, (int)x, (int)y, (int)(x + Minecraft.func_71410_x().field_71466_p.func_78256_a(txt) + 3), (int)(y + 11), (int)0x60000000);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(m, txt, (float)(x + 2), (float)(y + 2), 0xFFFFFF);
    }

    public static void drawRightTextLabel(MatrixStack m, String txt, int x, int y) {
        GlStateManager.func_227737_l_();
        int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(txt) + 3;
        AbstractGui.func_238467_a_((MatrixStack)m, (int)(x - w), (int)y, (int)x, (int)(y + 11), (int)0x60000000);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(m, txt, (float)(x - w + 2), (float)(y + 2), 0xFFFFFF);
    }

    public static void drawCenterTextLabel(MatrixStack m, String txt, int x, int y) {
        GlStateManager.func_227737_l_();
        int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(txt) + 3;
        AbstractGui.func_238467_a_((MatrixStack)m, (int)(x - w / 2), (int)y, (int)(x + w / 2 + 1), (int)(y + 11), (int)0x60000000);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(m, txt, (float)(x - w / 2 + 2), (float)(y + 2), 0xFFFFFF);
    }

    public static interface WildfireCB {
        public void onExecute(boolean var1, Object var2);
    }
}

