/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireSounds;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PacketHurt {
    private final String uuid;
    private boolean hurtSounds;
    private final int gender;
    private Vector3d pos;

    public PacketHurt(Vector3d pos, GenderPlayer plr) {
        this.uuid = plr.username;
        this.gender = plr.gender;
        this.hurtSounds = plr.hurtSounds;
        this.pos = pos;
    }

    public PacketHurt(PacketBuffer buffer) {
        this.uuid = buffer.func_150789_c(36);
        this.gender = buffer.readInt();
        this.pos = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.hurtSounds = buffer.readBoolean();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.uuid);
        buffer.writeInt(this.gender);
        buffer.writeDouble(this.pos.func_82615_a());
        buffer.writeDouble(this.pos.func_82617_b());
        buffer.writeDouble(this.pos.func_82616_c());
        buffer.writeBoolean(this.hurtSounds);
    }

    public static void handle(PacketHurt packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            GenderPlayer plr = WildfireGender.getPlayerByName(packet.uuid);
            if (plr == null) {
                return;
            }
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                PlayerEntity ent;
                SoundEvent hurtSound = null;
                if (packet.gender == 0) {
                    SoundEvent soundEvent = hurtSound = Math.random() > 0.5 ? WildfireSounds.FEMALE_HURT1 : WildfireSounds.FEMALE_HURT2;
                }
                if (hurtSound == null) {
                    return;
                }
                if (packet.hurtSounds && (ent = Minecraft.func_71410_x().field_71441_e.func_217371_b(UUID.fromString(packet.uuid))) != null) {
                    WildfireGender.PROXY.playSound(hurtSound, SoundCategory.PLAYERS, 1.0f, 1.0f, ent);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(boolean toServer, Vector3d pos, GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        PacketHurt syncPacket = new PacketHurt(pos, plr);
        if (toServer) {
            WildfireGender.NETWORK.sendToServer((Object)syncPacket);
        } else {
            WildfireGender.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)syncPacket);
        }
    }
}

