/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.physics;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireHelper;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class BreastPhysics {
    private float bounceVel = 0.0f;
    private float targetBounce = 0.0f;
    private float velocity = 0.0f;
    private float wfg_femaleBreast;
    private float wfg_preBounce;
    private float bounceRotVel = 0.0f;
    private float targetRotVel = 0.0f;
    private float rotVelocity = 0.0f;
    private float wfg_bounceRotation;
    private float wfg_preBounceRotation;
    private float bounceVelX = 0.0f;
    private float targetBounceX = 0.0f;
    private float velocityX = 0.0f;
    private float wfg_femaleBreastX;
    private float wfg_preBounceX;
    private boolean justSneaking = false;
    private boolean alreadySleeping = false;
    private float breastSize = 0.0f;
    private float preBreastSize = 0.0f;
    private Vector3d motion;
    private Vector3d prePos;
    private GenderPlayer genderPlayer;
    private int randomB = 1;
    private boolean alreadyFalling = false;

    public BreastPhysics(GenderPlayer genderPlayer) {
        this.genderPlayer = genderPlayer;
    }

    public void update(PlayerEntity plr) {
        this.wfg_preBounce = this.wfg_femaleBreast;
        this.wfg_preBounceX = this.wfg_femaleBreastX;
        this.wfg_preBounceRotation = this.wfg_bounceRotation;
        this.preBreastSize = this.breastSize;
        float breastWeight = this.genderPlayer.getBustSize() * 1.25f;
        if (this.prePos == null) {
            this.prePos = plr.func_213303_ch();
            return;
        }
        float targetBreastSize = this.genderPlayer.getBustSize();
        if (this.genderPlayer.gender == 1) {
            targetBreastSize = 0.0f;
        }
        this.breastSize = this.breastSize < targetBreastSize ? (this.breastSize += Math.abs(this.breastSize - targetBreastSize) / 2.0f) : (this.breastSize -= Math.abs(this.breastSize - targetBreastSize) / 2.0f);
        this.motion = plr.func_213303_ch().func_178788_d(this.prePos);
        this.prePos = plr.func_213303_ch();
        float bounceIntensity = this.genderPlayer.getBustSize() * 3.0f * this.genderPlayer.getBounceMultiplier();
        if (!this.genderPlayer.getBreasts().isUniboob) {
            bounceIntensity *= WildfireHelper.randFloat(0.5f, 1.5f);
        }
        if (plr.field_70143_R > 0.0f && !this.alreadyFalling) {
            this.randomB = WildfireHelper.randInt(0, 1) == 1 ? -1 : 1;
            this.alreadyFalling = true;
        }
        if (plr.field_70143_R == 0.0f) {
            this.alreadyFalling = false;
        }
        this.targetBounce = (float)this.motion.func_82617_b() * bounceIntensity;
        this.targetBounce += breastWeight;
        float horizVel = (float)Math.sqrt(Math.pow(this.motion.func_82615_a(), 2.0) + Math.pow(this.motion.func_82616_c(), 2.0)) * bounceIntensity;
        this.targetRotVel = -((plr.field_70761_aq - plr.field_70760_ar) / 15.0f) * bounceIntensity;
        float f = 1.0f;
        f = (float)plr.func_213322_ci().func_189985_c();
        f /= 0.2f;
        if ((f = f * f * f) < 1.0f) {
            f = 1.0f;
        }
        this.targetBounce += MathHelper.func_76134_b((float)(plr.field_184619_aG * 0.6662f + (float)Math.PI)) * 0.5f * plr.field_70721_aZ * 0.5f / f;
        this.targetRotVel += (float)this.motion.func_82617_b() * bounceIntensity * (float)this.randomB;
        if (plr.func_213283_Z() == Pose.CROUCHING && !this.justSneaking) {
            this.justSneaking = true;
            this.targetBounce += bounceIntensity;
        }
        if (plr.func_213283_Z() != Pose.CROUCHING && this.justSneaking) {
            this.justSneaking = false;
            this.targetBounce += bounceIntensity;
        }
        if (plr.func_184187_bx() != null) {
            float movement;
            AbstractHorseEntity horse;
            if (plr.func_184187_bx() instanceof BoatEntity) {
                BoatEntity boat = (BoatEntity)plr.func_184187_bx();
                int rowTime = (int)boat.func_184448_a(0, plr.field_184619_aG);
                int rowTime2 = (int)boat.func_184448_a(1, plr.field_184619_aG);
                float rotationL = (float)MathHelper.func_151238_b((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((MathHelper.func_76126_a((float)(-rowTime2)) + 1.0f) / 2.0f));
                float rotationR = (float)MathHelper.func_151238_b((double)-0.7853981852531433, (double)0.7853981852531433, (double)((MathHelper.func_76126_a((float)((float)(-rowTime) + 1.0f)) + 1.0f) / 2.0f));
                System.out.println(rotationL + ", " + rotationR);
                if (rotationL < -1.0f || rotationR < -0.6f) {
                    this.targetBounce = bounceIntensity / 3.25f;
                }
            }
            if (plr.func_184187_bx() instanceof MinecartEntity) {
                MinecartEntity cart = (MinecartEntity)plr.func_184187_bx();
                float speed = (float)cart.func_213322_ci().func_189985_c();
                if (Math.random() * (double)speed < 0.5 && speed > 0.2f) {
                    this.targetBounce = Math.random() > 0.5 ? -bounceIntensity / 6.0f : bounceIntensity / 6.0f;
                }
            }
            if (plr.func_184187_bx() instanceof AbstractHorseEntity && horse.field_70173_aa % this.clampMovement(movement = (float)(horse = (AbstractHorseEntity)plr.func_184187_bx()).func_213322_ci().func_72433_c()) == 5 && movement > 0.1f) {
                this.targetBounce = bounceIntensity / 4.0f;
            }
            if (plr.func_184187_bx() instanceof PigEntity) {
                PigEntity pig = (PigEntity)plr.func_184187_bx();
                movement = (float)pig.func_213322_ci().func_72433_c();
                System.out.println(movement);
                if (pig.field_70173_aa % this.clampMovement(movement) == 5 && movement > 0.08f) {
                    this.targetBounce = bounceIntensity / 4.0f;
                }
            }
            if (plr.func_184187_bx() instanceof StriderEntity) {
                StriderEntity strider = (StriderEntity)plr.func_184187_bx();
                this.targetBounce += ((float)(strider.func_70042_X() * 3.0) - 4.5f) * bounceIntensity;
            }
        }
        if (plr.field_82175_bq && plr.field_70173_aa % 5 == 0 && plr.func_213283_Z() != Pose.SLEEPING) {
            this.targetBounce = Math.random() > 0.5 ? (this.targetBounce += -0.25f * bounceIntensity) : (this.targetBounce += 0.25f * bounceIntensity);
        }
        if (plr.func_213283_Z() == Pose.SLEEPING && !this.alreadySleeping) {
            this.targetBounce = bounceIntensity;
            this.alreadySleeping = true;
        }
        if (plr.func_213283_Z() != Pose.SLEEPING && this.alreadySleeping) {
            this.targetBounce = bounceIntensity;
            this.alreadySleeping = false;
        }
        float percent = this.genderPlayer.getFloppiness();
        float bounceAmount = 0.45f * (1.0f - percent) + 0.15f;
        bounceAmount = MathHelper.func_76131_a((float)bounceAmount, (float)0.15f, (float)0.6f);
        float delta = 2.25f - 1.0f * bounceAmount;
        float distanceFromMin = Math.abs(this.bounceVel + 0.5f) * 0.5f;
        float distanceFromMax = Math.abs(this.bounceVel - 2.65f) * 0.5f;
        if (this.bounceVel < -0.5f) {
            this.targetBounce += distanceFromMin;
        }
        if (this.bounceVel > 2.5f) {
            this.targetBounce -= distanceFromMax;
        }
        if (this.targetBounce < -1.5f) {
            this.targetBounce = -1.5f;
        }
        if (this.targetBounce > 2.5f) {
            this.targetBounce = 2.5f;
        }
        if (this.targetRotVel < -25.0f) {
            this.targetRotVel = -25.0f;
        }
        if (this.targetRotVel > 25.0f) {
            this.targetRotVel = 25.0f;
        }
        this.velocity = MathHelper.func_219799_g((float)bounceAmount, (float)this.velocity, (float)((this.targetBounce - this.bounceVel) * delta));
        this.bounceVel += this.velocity * percent * 1.1625f;
        this.velocityX = MathHelper.func_219799_g((float)bounceAmount, (float)this.velocityX, (float)((this.targetBounceX - this.bounceVelX) * delta));
        this.bounceVelX += this.velocityX * percent;
        this.rotVelocity = MathHelper.func_219799_g((float)bounceAmount, (float)this.rotVelocity, (float)((this.targetRotVel - this.bounceRotVel) * delta));
        this.bounceRotVel += this.rotVelocity * percent;
        this.wfg_bounceRotation = this.bounceRotVel;
        this.wfg_femaleBreastX = this.bounceVelX;
        this.wfg_femaleBreast = this.bounceVel;
    }

    public float getBreastSize(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.preBreastSize, (float)this.breastSize);
    }

    public float getPreBounceY() {
        return this.wfg_preBounce;
    }

    public float getBounceY() {
        return this.wfg_femaleBreast;
    }

    public float getPreBounceX() {
        return this.wfg_preBounceX;
    }

    public float getBounceX() {
        return this.wfg_femaleBreastX;
    }

    public float getBounceRotation() {
        return this.wfg_bounceRotation;
    }

    public float getPreBounceRotation() {
        return this.wfg_preBounceRotation;
    }

    private int clampMovement(float movement) {
        int val = (int)(10.0f - movement * 2.0f);
        if (val < 1) {
            val = 1;
        }
        return val;
    }
}

