/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.wildfire.gui.SteinButton;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WildfireCapeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("wildfire_gender", "textures/gui/cape_bg.png");
    private Screen parent;
    private String errorMsg;
    private int errorMsgTimer;

    public WildfireCapeScreen(Screen parent) {
        super((Component)new TranslatableComponent("wildfire_gender.cape_screen.title"));
        this.parent = parent;
    }

    private void displayError(String string) {
        this.errorMsg = string;
    }

    public void m_7856_() {
        Minecraft mc = Minecraft.m_91087_();
        String playerName = Player.m_36198_((GameProfile)mc.f_91074_.m_36316_()).toString();
        GenderPlayer plr = WildfireGender.getPlayerByName(playerName);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        EditBox nameField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 91, y - 6, 174, 12, (Component)new TextComponent(""));
        nameField.m_94190_(false);
        nameField.m_5755_(false);
        nameField.m_94202_(-1);
        nameField.m_94205_(-1);
        nameField.m_94182_(false);
        nameField.m_94199_(1000);
        nameField.m_94144_(plr.capeURL);
        this.m_142416_((GuiEventListener)nameField);
        this.m_142416_((GuiEventListener)new SteinButton(this.f_96543_ / 2 + 53, this.f_96544_ / 2 + 5, 40, 14, (Component)new TextComponent("Update"), button -> {
            try {
                URL url = new URL(nameField.m_94155_());
                if (url.toString().contains("file:/")) {
                    this.displayError("Cannot Be A Local File!");
                    return;
                }
                BufferedImage image = ImageIO.read(url);
                int height = image.getHeight();
                int width = image.getWidth();
                if (width == 64 && height == 32) {
                    plr.capeURL = nameField.m_94155_();
                    GenderPlayer.saveGenderInfo(plr);
                    plr.refreshCape();
                    this.displayError(ChatFormatting.DARK_GREEN + "Updated Custom Cape!");
                } else {
                    this.displayError("Texture " + ChatFormatting.BOLD + "Must" + ChatFormatting.RESET + " Be 64x32");
                }
            }
            catch (Exception e) {
                if (nameField.m_94155_().equals("")) {
                    plr.capeURL = "";
                    plr.CAPE_TEXTURE = null;
                    plr.ELYTRA_TEXTURE = null;
                    GenderPlayer.saveGenderInfo(plr);
                    this.displayError("Removed Custom Cape");
                }
                this.displayError("Invalid URL");
            }
        }));
        this.m_142416_((GuiEventListener)new SteinButton(this.f_96543_ / 2 + 20, this.f_96544_ / 2 + 5, 32, 14, (Component)new TextComponent("Reset"), button -> {
            nameField.m_94144_("");
            plr.capeURL = "";
            plr.CAPE_TEXTURE = null;
            plr.ELYTRA_TEXTURE = null;
            GenderPlayer.saveGenderInfo(plr);
            this.displayError("Removed Custom Cape");
        }));
        this.m_142416_((GuiEventListener)new SteinButton(this.f_96543_ / 2 - 92, this.f_96544_ / 2 + 5, 84, 14, (Component)new TextComponent("Elytra: ").m_130946_(plr.showElytraTexture ? "Enabled" : "Disabled"), button -> {
            if (plr == null) {
                return;
            }
            plr.showElytraTexture ^= true;
            button.m_93666_((Component)new TextComponent("Elytra: ").m_130946_(plr.showElytraTexture ? "Enabled" : "Disabled"));
            GenderPlayer.saveGenderInfo(plr);
            plr.refreshCape();
        }, new SteinButton.ITooltip(){

            @Override
            public void onTooltip(SteinButton button, PoseStack matrices, int mouseX, int mouseY) {
                WildfireCapeScreen.this.m_96602_(matrices, (Component)new TextComponent("Override default Elytra texture with cape."), mouseX, mouseY);
            }
        }));
        this.m_142416_((GuiEventListener)new SteinButton(this.f_96543_ / 2 + 83, y - 18, 9, 9, (Component)new TextComponent("X"), button -> Minecraft.m_91087_().m_91152_(this.parent)));
        mc.f_91068_.m_90926_(true);
        super.m_7856_();
    }

    protected void drawBackground(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - 194) / 2;
        int j = (this.f_96544_ - 46) / 2;
        this.m_93228_(matrices, i, j, 0, 0, 194, 46);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrices);
        this.drawBackground(matrices, partialTicks, mouseX, mouseY);
        Minecraft mc = Minecraft.m_91087_();
        String playerName = Player.m_36198_((GameProfile)mc.f_91074_.m_36316_()).toString();
        GenderPlayer plr = WildfireGender.getPlayerByName(playerName);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.f_96547_.m_92889_(matrices, (Component)new TranslatableComponent("wildfire_gender.cape_screen.title"), (float)(x - 92), (float)(y - 18), 0x444444);
        this.f_96547_.m_92750_(matrices, this.errorMsg, (float)(x - 92), (float)(y - 34), 0xFF5522);
        if (plr.CAPE_TEXTURE != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)plr.CAPE_TEXTURE);
            WildfireCapeScreen.m_93133_((PoseStack)matrices, (int)(x - 64), (int)(y + 30), (float)0.0f, (float)0.0f, (int)128, (int)64, (int)128, (int)64);
        }
        int xP = this.f_96543_ / 2 - 138;
        int yP = this.f_96544_ / 2 + 40;
        LocalPlayer ent = Minecraft.m_91087_().f_91074_;
        if (ent != null) {
            WildfireCapeScreen.renderEntityInInventory(xP, yP, 45, xP, yP - 76, (LivingEntity)ent);
        }
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
    }

    public void m_7861_() {
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public void m_96624_() {
        ++this.errorMsgTimer;
        if (this.errorMsgTimer > 100) {
            this.errorMsg = "";
            this.errorMsgTimer = 0;
        }
        super.m_96624_();
    }

    public static void renderEntityInInventory(int p_98851_, int p_98852_, int p_98853_, float p_98854_, float p_98855_, LivingEntity p_98856_) {
        float var6 = (float)Math.atan(p_98854_ / 40.0f);
        float var7 = (float)Math.atan(p_98855_ / 40.0f);
        PoseStack var8 = RenderSystem.m_157191_();
        var8.m_85836_();
        var8.m_85837_((double)p_98851_, (double)p_98852_, 1050.0);
        var8.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack var9 = new PoseStack();
        var9.m_85837_(0.0, 0.0, 1000.0);
        var9.m_85841_((float)p_98853_, (float)p_98853_, (float)p_98853_);
        Quaternion var10 = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion var11 = Vector3f.f_122223_.m_122240_(20.0f);
        var10.m_80148_(var11);
        var9.m_85845_(var10);
        float var12 = p_98856_.f_20883_;
        float var13 = p_98856_.m_146908_();
        float var14 = p_98856_.m_146909_();
        float var15 = p_98856_.f_20886_;
        float var16 = p_98856_.f_20885_;
        p_98856_.f_20883_ = 180.0f + var6 * 20.0f;
        p_98856_.m_146922_(180.0f + var6 * 40.0f);
        p_98856_.m_146926_(-var7 * 20.0f);
        p_98856_.f_20885_ = p_98856_.m_146908_();
        p_98856_.f_20886_ = p_98856_.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher var17 = Minecraft.m_91087_().m_91290_();
        var11.m_80157_();
        var17.m_114412_(var11);
        var17.m_114468_(false);
        MultiBufferSource.BufferSource var18 = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> var17.m_114384_((Entity)p_98856_, 0.0, 0.0, 0.0, 0.0f, 1.0f, var9, (MultiBufferSource)var18, 0xF000F0));
        var18.m_109911_();
        var17.m_114468_(true);
        p_98856_.f_20883_ = var12;
        p_98856_.m_146922_(var13);
        p_98856_.m_146926_(var14);
        p_98856_.f_20886_ = var15;
        p_98856_.f_20885_ = var16;
        var8.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

