/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.wildfire.main.Configuration;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.physics.BreastPhysics;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.json.simple.JSONObject;

public class GenderPlayer {
    public String username;
    public int gender;
    public float pBustSize = 0.6f;
    public boolean hurtSounds = true;
    public boolean breast_physics = false;
    public boolean breast_physics_armor = false;
    public float bounceMultiplier = 0.34f;
    public float floppyMultiplier = 0.95f;
    public String capeURL = "";
    public String preCapeURL = "";
    public boolean lockSettings = false;
    public boolean showElytraTexture = true;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private Configuration cfg;
    private BreastPhysics breastPhysics = new BreastPhysics(this);
    public ResourceLocation CAPE_TEXTURE;
    public ResourceLocation ELYTRA_TEXTURE;
    private boolean downloadedCape = false;

    public GenderPlayer(String username) {
        this(username, 1);
    }

    public GenderPlayer(String username, int gender) {
        this.username = username;
        this.gender = gender;
        this.cfg = new Configuration("WildfireGender", this.username);
        this.cfg.setDefaultParameter("username", "NOT_AVAILABLE");
        this.cfg.setDefaultParameter("gender", 1);
        this.cfg.setDefaultParameter("bust_size", Float.valueOf(0.6f));
        this.cfg.setDefaultParameter("cape_url", "");
        this.cfg.setDefaultParameter("show_elytra", true);
        this.cfg.setDefaultParameter("hurt_sounds", true);
        this.cfg.setDefaultParameter("breast_physics", false);
        this.cfg.setDefaultParameter("breast_physics_armor", false);
        this.cfg.setDefaultParameter("bounce_multiplier", "0.34");
        this.cfg.setDefaultParameter("floppy_multiplier", "0.95");
        this.cfg.finish();
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public float getBounceMultiplier() {
        float bounceMult = Float.valueOf(this.bounceMultiplier).floatValue();
        return (float)Math.round(bounceMult * 3.0f * 100.0f) / 100.0f;
    }

    public float getFloppiness() {
        return Float.valueOf(this.floppyMultiplier).floatValue();
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public void updateBustSize(float v) {
        this.pBustSize = v;
    }

    public static JSONObject toJSONObject(GenderPlayer plr) {
        JSONObject obj = new JSONObject();
        obj.put("username", plr.username);
        obj.put("gender", plr.gender);
        obj.put("bust_size", Float.valueOf(plr.pBustSize));
        obj.put("cape_url", plr.capeURL);
        obj.put("show_elytra", plr.showElytraTexture);
        obj.put("hurt_sounds", plr.hurtSounds);
        obj.put("breast_physics", plr.breast_physics);
        obj.put("breast_physics_armor", plr.breast_physics_armor);
        obj.put("bounce_multiplier", Float.valueOf(plr.bounceMultiplier));
        obj.put("floppy_multiplier", Float.valueOf(plr.floppyMultiplier));
        return obj;
    }

    public void toJSONObject() {
        GenderPlayer.toJSONObject(this);
    }

    public static GenderPlayer fromJSONObject(JSONObject obj) {
        GenderPlayer plr = new GenderPlayer(obj.get("username").toString());
        plr.gender = Integer.valueOf(obj.get("gender").toString());
        plr.pBustSize = Float.valueOf(obj.get("bust_size").toString()).floatValue();
        plr.capeURL = obj.get("cape_url").toString();
        plr.showElytraTexture = Boolean.valueOf(obj.get("show_elytra").toString());
        plr.hurtSounds = Boolean.valueOf(obj.get("hurt_sounds").toString());
        plr.breast_physics = Boolean.valueOf(obj.get("breast_physics").toString());
        plr.breast_physics_armor = Boolean.valueOf(obj.get("breast_physics_armor").toString());
        plr.bounceMultiplier = Float.valueOf(obj.get("bounce_multiplier").toString()).floatValue();
        plr.floppyMultiplier = Float.valueOf(obj.get("floppy_multiplier").toString()).floatValue();
        return plr;
    }

    public static GenderPlayer loadSyncedPlayer(String uuid) {
        GenderPlayer plr = WildfireHelper.getPlayerData(uuid);
        if (plr != null) {
            plr.syncStatus = SyncStatus.SYNCED;
        }
        return plr;
    }

    public static GenderPlayer loadCachedPlayer(String uuid) {
        GenderPlayer plr = WildfireGender.getPlayerByName(uuid);
        if (plr != null) {
            plr.lockSettings = false;
            plr.syncStatus = SyncStatus.CACHED;
            try {
                plr.gender = Integer.valueOf(plr.getConfig().getParameter("gender").toString());
            }
            catch (Exception e) {
                plr.gender = Boolean.valueOf(plr.getConfig().getParameter("gender").toString()) != false ? 1 : 0;
            }
            plr.updateBustSize(Float.valueOf(plr.getConfig().getParameter("bust_size").toString()).floatValue());
            plr.capeURL = plr.getConfig().getParameter("cape_url").toString();
            plr.showElytraTexture = plr.getConfig().getBool("show_elytra");
            plr.hurtSounds = plr.getConfig().getBool("hurt_sounds");
            plr.breast_physics = plr.getConfig().getBool("breast_physics");
            plr.breast_physics_armor = plr.getConfig().getBool("breast_physics_armor");
            plr.bounceMultiplier = Float.valueOf(plr.getConfig().getParameter("bounce_multiplier").toString()).floatValue();
            plr.floppyMultiplier = Float.valueOf(plr.getConfig().getParameter("floppy_multiplier").toString()).floatValue();
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        plr.getConfig().setParameter("username", plr.username);
        plr.getConfig().setParameter("gender", plr.gender);
        plr.getConfig().setParameter("bust_size", Float.valueOf(plr.getBustSize()));
        plr.getConfig().setParameter("cape_url", plr.capeURL);
        plr.getConfig().setParameter("show_elytra", plr.showElytraTexture);
        plr.getConfig().setParameter("hurt_sounds", plr.hurtSounds);
        plr.getConfig().setParameter("breast_physics", plr.breast_physics);
        plr.getConfig().setParameter("breast_physics_armor", plr.breast_physics_armor);
        plr.getConfig().setParameter("bounce_multiplier", Float.valueOf(plr.bounceMultiplier));
        plr.getConfig().setParameter("floppy_multiplier", Float.valueOf(plr.floppyMultiplier));
        plr.getConfig().save();
    }

    public BreastPhysics getBreastPhysics() {
        return this.breastPhysics;
    }

    public void refreshCape() {
        this.downloadedCape = false;
        this.loadCape(this.capeURL);
    }

    private static NativeImage elytraConverter(NativeImage img, NativeImage original) {
        int imageWidth = 64;
        int imageHeight = 32;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = 0; y < imageHeight; ++y) {
                if (img.m_85087_(x, y) == 0) continue;
                original.m_84988_(x, y, img.m_84985_(x, y));
            }
        }
        img.close();
        return original;
    }

    public ResourceLocation getElytraTexture() {
        return this.ELYTRA_TEXTURE;
    }

    public void loadCape(String capeURL) {
        if (!capeURL.equals("")) {
            String string = Hashing.sha1().hashUnencodedChars((CharSequence)capeURL).toString();
            ResourceLocation identifier = new ResourceLocation("capes/" + string);
            if (!this.downloadedCape) {
                this.downloadedCape = true;
                Minecraft.m_91087_().execute(() -> {
                    try {
                        NativeImage capeTexture = NativeImage.m_85058_((InputStream)((HttpURLConnection)new URL(capeURL).openConnection(Minecraft.m_91087_().m_91096_())).getInputStream());
                        this.CAPE_TEXTURE = Minecraft.m_91087_().m_91097_().m_118490_("cape" + string, new DynamicTexture(capeTexture));
                        if (!this.showElytraTexture) {
                            NativeImage defaultElytra = NativeImage.m_85058_((InputStream)GenderPlayer.class.getClassLoader().getResourceAsStream("assets/minecraft/textures/entity/elytra.png"));
                            NativeImage newElytra = GenderPlayer.elytraConverter(capeTexture, defaultElytra);
                            this.ELYTRA_TEXTURE = Minecraft.m_91087_().m_91097_().m_118490_("elytra2" + string, new DynamicTexture(newElytra));
                        } else {
                            this.ELYTRA_TEXTURE = Minecraft.m_91087_().m_91097_().m_118490_("elytra" + string, new DynamicTexture(capeTexture));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

