/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.mojang.authlib.GameProfile;
import com.wildfire.gui.screen.SteinPlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.main.proxy.GenderClient;
import com.wildfire.render.GenderCapeLayer;
import com.wildfire.render.GenderElytraLayer;
import com.wildfire.render.GenderLayer;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.Connection;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class WildfireEventHandler {
    private int showTimer = 0;
    private boolean wasActive = WildfireGender.modEnabled;
    int timer = 0;
    public boolean addedLayer = false;

    @SubscribeEvent
    public void onGUI(RenderGameOverlayEvent.Post evt) {
        if (evt.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            if (this.wasActive != WildfireGender.modEnabled) {
                this.showTimer = 10;
                this.wasActive = WildfireGender.modEnabled;
            }
            if (this.showTimer > 0) {
                WildfireGender.drawTextLabel(evt.getMatrixStack(), WildfireGender.modEnabled ? ChatFormatting.GREEN + "Enabled" : ChatFormatting.RED + "Disabled", 2, 2);
            }
        }
    }

    @SubscribeEvent
    public void onGUI(TickEvent.ClientTickEvent evt) {
        if (Minecraft.m_91087_().f_91073_ == null && WildfireGender.CLOTHING_PLAYER.size() > 0) {
            WildfireGender.CLOTHING_PLAYER.clear();
        }
        boolean isVanillaServer = true;
        try {
            isVanillaServer = NetworkHooks.isVanillaConnection((Connection)Minecraft.m_91087_().m_91403_().m_6198_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isVanillaServer) {
            ++this.timer;
            if (this.timer >= 5) {
                try {
                    GenderPlayer aPlr = WildfireGender.getPlayerByName(Minecraft.m_91087_().f_91074_.m_142081_().toString());
                    if (aPlr == null) {
                        return;
                    }
                    PacketSendGenderInfo.send(aPlr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timer = 0;
            }
        }
        if (this.showTimer > 0) {
            --this.showTimer;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.side.isClient()) {
            GenderPlayer aPlr = WildfireGender.getPlayerByName(evt.player.m_142081_().toString());
            if (aPlr == null) {
                return;
            }
            if (!aPlr.preCapeURL.equals(aPlr.capeURL)) {
                System.out.println("Reloading Cape For Player " + aPlr.username);
                aPlr.preCapeURL = aPlr.capeURL;
                aPlr.refreshCape();
            }
            aPlr.getBreastPhysics().update(evt.player);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        if (GenderClient.toggleEditGUI.m_90859_()) {
            String playerUUID = Player.m_36198_((GameProfile)Minecraft.m_91087_().f_91074_.m_36316_()).toString();
            if (WildfireGender.modEnabled) {
                WildfireGender.refreshAllGenders();
                Minecraft.m_91087_().m_91152_((Screen)new SteinPlayerListScreen(Minecraft.m_91087_()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent evt) {
        if (!evt.getWorld().f_46443_) {
            return;
        }
        if (evt.getEntity() instanceof AbstractClientPlayer) {
            AbstractClientPlayer plr = (AbstractClientPlayer)evt.getEntity();
            String playerName = Player.m_36198_((GameProfile)plr.m_36316_()).toString();
            GenderPlayer aPlr = WildfireGender.getPlayerByName(plr.m_142081_().toString());
            if (aPlr == null) {
                aPlr = new GenderPlayer(plr.m_142081_().toString());
                WildfireGender.CLOTHING_PLAYER.add(aPlr);
                WildfireGender.loadGenderInfoAsync(plr.m_142081_().toString());
                WildfireGender.refreshAllGenders();
                return;
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class EntityRenderEventsTestClientModStuff {
        private EntityRenderEventsTestClientModStuff() {
        }

        @SubscribeEvent
        public static void entityLayers(EntityRenderersEvent.AddLayers event) {
            Map skinMap = Minecraft.m_91087_().m_91290_().getSkinMap();
            skinMap.forEach((string, r) -> {
                LivingEntityRenderer renderer = (LivingEntityRenderer)r;
                renderer.m_115326_((RenderLayer)new GenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
                renderer.m_115326_((RenderLayer)new GenderElytraLayer((RenderLayerParent)renderer));
                renderer.m_115326_((RenderLayer)new GenderCapeLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
                List layerRenderers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingEntityRenderer.class, (Object)renderer, (String)"f_115291_");
                ListIterator it = layerRenderers.listIterator();
                while (it.hasNext()) {
                    RenderLayer elem = (RenderLayer)it.next();
                    if (!(elem instanceof ElytraLayer) && !(elem instanceof CapeLayer)) continue;
                    it.remove();
                }
            });
        }
    }
}

