/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireSounds;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class PacketHurt {
    private final String uuid;
    private boolean hurtSounds;
    private final int gender;
    private Vec3 pos;

    public PacketHurt(Vec3 pos, GenderPlayer plr) {
        this.uuid = plr.username;
        this.gender = plr.gender;
        this.hurtSounds = plr.hurtSounds;
        this.pos = pos;
    }

    public PacketHurt(FriendlyByteBuf buffer) {
        this.uuid = buffer.m_130136_(36);
        this.gender = buffer.readInt();
        this.pos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.hurtSounds = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.uuid);
        buffer.writeInt(this.gender);
        buffer.writeDouble(this.pos.m_7096_());
        buffer.writeDouble(this.pos.m_7098_());
        buffer.writeDouble(this.pos.m_7094_());
        buffer.writeBoolean(this.hurtSounds);
    }

    public static void handle(PacketHurt packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            GenderPlayer plr = WildfireGender.getPlayerByName(packet.uuid);
            if (plr == null) {
                return;
            }
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Player ent;
                SoundEvent hurtSound = null;
                if (packet.gender == 0) {
                    SoundEvent soundEvent = hurtSound = Math.random() > 0.5 ? WildfireSounds.FEMALE_HURT1 : WildfireSounds.FEMALE_HURT2;
                }
                if (hurtSound == null) {
                    return;
                }
                if (packet.hurtSounds && (ent = Minecraft.m_91087_().f_91073_.m_46003_(UUID.fromString(packet.uuid))) != null) {
                    WildfireGender.PROXY.playSound(hurtSound, SoundSource.PLAYERS, 1.0f, 1.0f, ent);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(boolean toServer, Vec3 pos, GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        PacketHurt syncPacket = new PacketHurt(pos, plr);
        if (toServer) {
            WildfireGender.NETWORK.sendToServer((Object)syncPacket);
        } else {
            WildfireGender.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)syncPacket);
        }
    }
}

