/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class PacketSendCape {
    private final String uuid;

    public PacketSendCape(GenderPlayer plr) {
        this.uuid = plr.username;
    }

    public PacketSendCape(FriendlyByteBuf buffer) {
        this.uuid = buffer.m_130136_(36);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.uuid);
    }

    public static void handle(PacketSendCape packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            GenderPlayer plr = WildfireGender.getPlayerByName(packet.uuid);
            if (plr == null) {
                return;
            }
            System.out.println("Direction: " + ((NetworkEvent.Context)context.get()).getDirection());
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                PacketSendCape.send(false, plr);
            } else {
                System.out.println("Load URL" + plr.capeURL);
                plr.refreshCape();
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(boolean toServer, GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        PacketSendCape syncPacket = new PacketSendCape(plr);
        if (toServer) {
            WildfireGender.NETWORK.sendToServer((Object)syncPacket);
        } else {
            WildfireGender.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)syncPacket);
        }
    }
}

